<?php
	session_start();
	
	include 'WebsiteSampleDemo/WebClientPrint.php';
	use Neodynamic\SDK\Web\WebClientPrint;
	use Neodynamic\SDK\Web\Utils;
	use Neodynamic\SDK\Web\DefaultPrinter;
	use Neodynamic\SDK\Web\InstalledPrinter;
	use Neodynamic\SDK\Web\ClientPrintJob;
	if (isset($urlParts['query'])){
		$rawQuery = $urlParts['query'];
		if($rawQuery[WebClientPrint::CLIENT_PRINT_JOB]){
			parse_str($rawQuery, $qs);

			$useDefaultPrinter = ($qs['useDefaultPrinter'] === 'checked');
			$printerName = urldecode($qs['printerName']);
			$vale = $qs['valebolet'];
			
			//Create ESC/POS commands for sample receipt
			$esc = '0x1B'; //ESC byte in hex notation
			$newLine = '0x0A'; //LF byte in hex notation
			
			
			$cmds = $esc . "@"; //Initializes the printer (ESC @)
			$cmds .= $esc . '!' . '0x24'; 
			$cmds .= $newLine . $newLine;
			$cmds .= $esc . '!' . '0x20'; 
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			
			
			$cmds .= $newLine;
			
			
			$cmds .= $newLine;
			$cmds .= '0x1B0x780x01';
			
			//$cmds .= $newLine;
			
			
			//CAmbio de letra
			//$cmds .= '0x1B0x780x01';
			//Justificar A La derecha 0x02, 0x01(centrado),0x03(Justificacion Total)
			//$cmds .= '0x1B0x610x02';
			
			//Margen izquierdo
			$cmds .= '0x1B0x6C0x04';
			
			//$cmds .= $newLine;
			//$cmds .= '0x1B0x650x310x15';
			$con = mysqli_connect('localhost','root','','busine_oxigeno');
			
			$query10 = "select a.fecha,d.condicion,a.monto_total, a.neto,a.iva,b.rut,b.giro_comercial,b.telefonos,b.razon_social,b.direccion,c.nombre as comuna from factura a join clientes b on a.cliente_id = b.id left
						join comuna c on b.comuna = c.codigo join condicion_pago d on a.forma_pago = d.id where a.factura=$vale";
			$result10= mysqli_query($con,$query10);
			while($row10 = mysqli_fetch_array($result10)){
				$rut = $row10['rut'];
				$montot = $row10['monto_total'];
				$netot = $row10['neto'];
				$ivat = $row10['iva'];
				$razon_social = $row10['razon_social'];
				$direccion = $row10['direccion'];
				$comuna = $row10['comuna'];
				$mediopago = $row10['condicion'];
				$girocomercial = $row10['giro_comercial'];
				$telefono = $row10['telefonos'];
				$fecha = $row10['fecha'];
				
				
			}
			
			list($anio,$mes,$dia) = explode('-',$fecha);
			
			$nyear = substr($anio, -2);
			
			switch($mes) 
			{
			case "01":
				$var = "Enero";
				break;
			case "02":
				$var = "Febrero";
				break;
			case "03":
				$var = "Marzo";
				break;
			case "04":
				$var = "Abril";
				break;
			case "05":
				$var = "Mayo";
				break;
			case "06":
				$var = "Junio";
				break;
			case "07":
				$var = "Julio";
				break;
			case "08":
				$var = "Agosto";
				break;
			case "09":
				$var = "Septiembre";
				break;
			case "10":
				$var = "Octubre";
				break;
			case "11":
				$var = "Noviembre";
				break;
			case "12":
				$var = "Diciembre";
				break;
				
				
			}
					
			$cmds .= $newLine . $newLine;
				
			$cmds .= $esc . '!' . '0x00'; //Character font A selected (ESC ! 0)
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= '0x1B0x610x02';
			
			$cmds .= $newLine;
			$cmds .= str_pad($dia, 11, " ", STR_PAD_RIGHT).str_pad($var, 12, " ", STR_PAD_RIGHT).str_pad($nyear, 7, " ", STR_PAD_LEFT);
			//$cmds .= $newLine;//New Line
			
			
			$cmds .= $newLine;
			$cmds .= '      '.$razon_social.'                     '.$rut;
			$cmds .= $newLine;
			$cmds .= '0x1B0x50';
			$cmds .= $newLine;
			$cmds .= '           '.$direccion.'                           '.$comuna;
			//$cmds .= $newLine;//New Line
			//$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= '               '.$guia.'               '.$mediopago.'             '.$ocompra.'              ';
			$cmds .= $newLine;//New Line
			//$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= '    '.$girocomercial.'             '.$telefono.'               SANTIAGO';
			//$cmds .= $newLine;//New Line
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			
			//$cmds .= $newLine;
			
			
			$cmds .= $newLine . $newLine;
			$cmds .= $esc . '!' . '0x00'; //Character font A selected (ESC ! 0)
			$totalfact = 0;
			
			$consulta9="SELECT a.factura_id as idboleta,a.producto_id as idproduct,b.codigo_externo as codigo,b.especificaciones as descripcion, a.descuento,a.cantidad,
						b.psale as precio_prod,a.precio as subtotal,a.enviado FROM factura_det a join productos b on a.producto_id = b.id where a.factura_id = $vale;";
			$resultado9 = mysqli_query($con,$consulta9);
			$totalsale2 = 0;
			$cmds .= $newLine;
			$cmds .= '0x1B0x610x02';
			$contador = 0;
			while($rows9 = mysqli_fetch_array($resultado9)){
				$contador++;
				
				$cmds .= $newLine;
				
				
				$cmds .= str_pad($rows9['cantidad'], 10, " ", STR_PAD_RIGHT).str_pad($rows9['descripcion'], 40, " ", STR_PAD_RIGHT).str_pad(number_format($rows9['precio_prod'],0,",","."), 5, " ", STR_PAD_RIGHT).'      '.str_pad(number_format($rows9['subtotal'],0,",","."), 15, " ", STR_PAD_RIGHT);
				//$cmds .= $newLine;
				
				
				
			}
			
			/*$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;*/
			
			if($contador >= 10){
				$h = 7;
				for($j=0; $j<= $h; $j++ )
				$cmds .= $newLine;
				/*$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			*/
				
			}else{
				$f = 10;
				for($j=0; $j<= ($f - $contador); $j++ )
				$cmds .= $newLine;
			}
			
			function basico($numero) {
				$valor = array ('uno','dos','tres','cuatro','cinco','seis','siete','ocho',
				'nueve','diez','veinticuatro','veinticinco',
				'veintiseis','veintisiete','veintiocho','veintinueve');
				return $valor[$numero - 1];
			}

			function decenas($n) {
				$decenas = array (30=>'treinta',40=>'cuarenta',50=>'cincuenta',60=>'sesenta',
				70=>'setenta',80=>'ochenta',90=>'noventa');
				if( $n <= 29) return basico($n);
				$x = $n % 10;
				if ( $x == 0 ) {
					return $decenas[$n]; 
				} else return $decenas[$n - $x].' y '. basico($x);
			}

			function centenas($n) {
				$cientos = array (100 =>'cien',200 =>'doscientos',300=>'trecientos',
				400=>'cuatrocientos', 500=>'quinientos',600=>'seiscientos',
				700=>'setecientos',800=>'ochocientos', 900 =>'novecientos');
				if( $n >= 100) {
					if ( $n % 100 == 0 ) {
						return $cientos[$n]; 
					} else {
						$u = (int) substr($n,0,1);
						$d = (int) substr($n,1,2);
						return (($u == 1)?'ciento':$cientos[$u*100]).' '.decenas($d);
					}
				} else return decenas($n);
			}

			function miles($n) {
				if($n > 999) {
					if( $n == 1000) {return 'mil';}
					else {
						$l = strlen($n);
						$c = (int)substr($n,0,$l-3);
						$x = (int)substr($n,-3);
						if($c == 1) {$cadena = 'mil '.centenas($x);}
						else if($x != 0) {$cadena = centenas($c).' mil '.centenas($x);}
						else $cadena = centenas($c). ' mil';
						return $cadena;
					}
				} else return centenas($n);
			}

			function millones($n) {
				if($n == 1000000) {return 'un millon';}
				else {
					$l = strlen($n);
					$c = (int)substr($n,0,$l-6);
					$x = (int)substr($n,-6);
					if($c == 1) {
						$cadena = ' millon ';
					} else {
						$cadena = ' millones ';
					}
					return miles($c).$cadena.(($x > 0)?miles($x):'');
				}
			}
			function convertir($n) {
				switch (true) {
				case ( $n >= 1 && $n <= 29)  : return basico($n); break;
				case ( $n >= 30 && $n < 100) : return decenas($n); break;
				case ( $n >= 100 && $n < 1000) : return centenas($n); break;
				case ($n >= 1000 && $n <= 999999): return miles($n); break;
				case ($n >= 1000000): return millones($n);
				}
			}



			
			
			$cmds .= $newLine;
			$cmds .= '0x1B0x610x00';
			$cmds .= $newLine;
			$cmds .= '0x1B0x6C0x10';
			//$cmds .= 'CIENTO CINCUENTA MIL PESOS';
			
			
			$cmds .= $newLine;//New Line
			$cmds .= '0x1B0x6C0x03';
			$cmds .= $newLine;//New Line			
			$cmds .= $esc . '!' . '0x14'; 
			$cmds .= $newLine;//New Line
			//$cmds .= 'UN MILLON NOVESCIENTOS NOVENTA Y NUEVE MIL NOVESCIENTOS NOVENTA Y NUEVE';
			$cmds .= ucfirst(convertir($montot));
			
			//$cmds .= substr(ucfirst(convertir($totalfact)), 0, -20);
			$cmds .= $newLine;
			$cmds .= '0x1B0x610x02';
			
			$cmds .= $newLine;
			$cmds .= str_pad(number_format($netot,0,",","."), 15, " ", STR_PAD_RIGHT);
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= str_pad(number_format($ivat,0,",","."), 15, " ", STR_PAD_RIGHT);
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= $newLine;
			$cmds .= str_pad(number_format($montot,0,",","."), 15, " ", STR_PAD_RIGHT);
			$cmds .= $newLine;
			$cmds .= '0x0C';
			
			
			$cpj = new ClientPrintJob();
			//set ESC/POS commands to print...
			$cpj->printerCommands = $cmds;
			$cpj->formatHexValues = true;
			//set client printer
			if ($useDefaultPrinter || $printerName === 'null'){
				$cpj->clientPrinter = new DefaultPrinter();
			}else{
				$cpj->clientPrinter = new InstalledPrinter($printerName);
			}

			//Send ClientPrintJob back to the client
			ob_clean();
			echo $cpj->sendToClient();
			ob_end_flush(); 
			exit();
		}
	}
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");             	// fecha pasada...
  	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 	// ultima modificacion
  	header("Cache-Control: no-cache, must-revalidate");           	// HTTP/1.1
  	header("Pragma: no-cache");
	header("Content-type: text/html; charset=utf8");
	if (!isset($_SESSION['idUsuario'])) {
		include "no_autorizado.html";
	} else {
		// carga rutinas de acceso a base de datos
		include "include/header.php";
		$con=opendblocal();
		include "include/funciones.php";
		$nom_usuario = 	$_SESSION["nombreUsuario"];
		$rol_usuario = $_SESSION["rolUsuario"];
		date_default_timezone_set("Chile/Continental");		
		$menu="COMPRAS";
		$opcion="ORDEN DE COMPRA";
		$hoy=date("d/m/Y");
		if ($fecha=="") {
			$fecha=$hoy;
		}
		
		
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
    
    <title><?php echo $_SESSION["titulo"];?></title>
    <meta name="author" content="SuggeElson" />
    <meta name="description" content="Supr admin template - new premium responsive admin template. This template is designed to help you build the site administration without losing valuable time.Template contains all the important functions which must have one backend system.Build on great twitter boostrap framework" />
    <meta name="keywords" content="admin, admin template, admin theme, responsive, responsive admin, responsive admin template, responsive theme, themeforest, 960 grid system, grid, grid theme, liquid, masonry, jquery, administration, administration template, administration theme, mobile, touch , responsive layout, boostrap, twitter boostrap" />
    <meta name="application-name" content="Supr admin template" />

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!-- Le styles -->
    <!-- Use new way for google web fonts 
    http://www.smashingmagazine.com/2012/07/11/avoiding-faux-weights-styles-google-web-fonts -->
    <!-- Headings -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css' />  -->
    <!-- Text -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Droid+Sans:400,700' rel='stylesheet' type='text/css' /> --> 
    <!--[if lt IE 9]>
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:700" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Droid+Sans:400" rel="stylesheet" type="text/css" />
    <link href="http://fonts.googleapis.com/css?family=Droid+Sans:700" rel="stylesheet" type="text/css" />
    <![endif]-->

    <link href="css/bootstrap/bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="css/bootstrap/bootstrap-responsive.min.css" rel="stylesheet" type="text/css" />
    <link href="css/supr-theme/jquery.ui.supr.css" rel="stylesheet" type="text/css" />
    <link href="css/icons.css" rel="stylesheet" type="text/css" />
    <!-- Plugin stylesheets -->
    <link href="plugins/qtip/jquery.qtip.css" rel="stylesheet" type="text/css" />
    <link href="plugins/fullcalendar/fullcalendar.css" rel="stylesheet" type="text/css" />
    <link href="plugins/jpages/jPages.css" rel="stylesheet" type="text/css" />
    <link href="plugins/prettify/prettify.css" type="text/css" rel="stylesheet" />
    <link href="plugins/inputlimiter/jquery.inputlimiter.css" type="text/css" rel="stylesheet" />
    <link href="plugins/ibutton/jquery.ibutton.css" type="text/css" rel="stylesheet" />
    <link href="plugins/uniform/uniform.default.css" type="text/css" rel="stylesheet" />
    <link href="plugins/color-picker/color-picker.css" type="text/css" rel="stylesheet" />
    <link href="plugins/select/select2.css" type="text/css" rel="stylesheet" />
    <link href="plugins/validate/validate.css" type="text/css" rel="stylesheet" />
    <link href="plugins/pnotify/jquery.pnotify.default.css" type="text/css" rel="stylesheet" />
    <link href="plugins/smartWizzard/smart_wizard.css" type="text/css" rel="stylesheet" />
    <link href="plugins/dataTables/jquery.dataTables.css" type="text/css" rel="stylesheet" />
    <link href="plugins/elfinder/elfinder.css" type="text/css" rel="stylesheet" />
    <link href="plugins/plupload/jquery.ui.plupload/css/jquery.ui.plupload.css" type="text/css" rel="stylesheet" />
    <link href="plugins/search/tipuesearch.css" type="text/css" rel="stylesheet" />

    <!-- Main stylesheets -->
    <link href="css/main.css" rel="stylesheet" type="text/css" /> 

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->

    <!-- Le javascript
    ================================================== -->
    <script type="text/javascript" src="js/jquery.min.js"></script>
    <script type="text/javascript" src="js/bootstrap/bootstrap.js"></script>  
    <script type="text/javascript" src="js/jquery_cookie.js"></script>
    <script type="text/javascript" src="js/jquery.mousewheel.js"></script>

    <!-- Load plugins -->
    <script type="text/javascript" src="plugins/qtip/jquery.qtip.min.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.grow.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.pie.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.resize.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.tooltip_0.4.4.js"></script>
    <script type="text/javascript" src="plugins/flot/jquery.flot.orderBars.js"></script>

    <script type="text/javascript" src="plugins/sparkline/jquery.sparkline.min.js"></script>
    <script type="text/javascript" src="plugins/knob/jquery.knob.js"></script>
    <script type="text/javascript" src="plugins/fullcalendar/fullcalendar.min.js"></script>
    <script type="text/javascript" src="plugins/prettify/prettify.js"></script>

    <script type="text/javascript" src="plugins/watermark/jquery.watermark.min.js"></script>
    <script type="text/javascript" src="plugins/elastic/jquery.elastic.js"></script>
    <script type="text/javascript" src="plugins/inputlimiter/jquery.inputlimiter.1.3.min.js"></script>
    <script type="text/javascript" src="plugins/maskedinput/jquery.maskedinput-1.3.min.js"></script>
    <script type="text/javascript" src="plugins/ibutton/jquery.ibutton.min.js"></script>
    <script type="text/javascript" src="plugins/uniform/jquery.uniform.min.js"></script>
    <script type="text/javascript" src="plugins/stepper/ui.stepper.js"></script>
    <script type="text/javascript" src="plugins/color-picker/colorpicker.js"></script>
    <script type="text/javascript" src="plugins/timeentry/jquery.timeentry.min.js"></script>
    <script type="text/javascript" src="plugins/select/select2.min.js"></script>
    <script type="text/javascript" src="plugins/dualselect/jquery.dualListBox-1.3.min.js"></script>
    <script type="text/javascript" src="plugins/tiny_mce/jquery.tinymce.js"></script>
    <script type="text/javascript" src="plugins/validate/jquery.validate.min.js"></script>
    <script type="text/javascript" src="plugins/search/tipuesearch_set.js"></script>
    <script type="text/javascript" src="plugins/search/tipuesearch_data.js"></script><!-- JSON for searched results -->
    <script type="text/javascript" src="plugins/search/tipuesearch.js"></script>

    <script type="text/javascript" src="plugins/animated-progress-bar/jquery.progressbar.js"></script>
    <script type="text/javascript" src="plugins/pnotify/jquery.pnotify.min.js"></script>
    <script type="text/javascript" src="plugins/lazy-load/jquery.lazyload.min.js"></script>
    <script type="text/javascript" src="plugins/jpages/jPages.min.js"></script>
    <script type="text/javascript" src="plugins/pretty-photo/jquery.prettyPhoto.js"></script>
    <script type="text/javascript" src="plugins/smartWizzard/jquery.smartWizard-2.0.min.js"></script>

    <script type="text/javascript" src="plugins/ios-fix/ios-orientationchange-fix.js"></script>

    <script type="text/javascript" src="plugins/dataTables3/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="plugins/elfinder/elfinder.min.js"></script>
    <script type="text/javascript" src="plugins/plupload/plupload.js"></script>
    <script type="text/javascript" src="plugins/plupload/plupload.html4.js"></script>
    <script type="text/javascript" src="plugins/plupload/jquery.plupload.queue/jquery.plupload.queue.js"></script>

    <!-- Init plugins -->
    <script type="text/javascript" src="js/statistic.js"></script><!-- Control graphs ( chart, pies and etc) -->

    <!-- Important Place before main.js  -->
    <script type="text/javascript" src="js/jquery-ui.min.js"></script>
    <script type="text/javascript" src="plugins/touch-punch/jquery.ui.touch-punch.min.js"></script>
    <script type="text/javascript" src="js/main.js"></script>
    <script type="text/javascript" src="js/basic.js"></script>
    <script type="text/javascript" src="js/ajax.js"></script>
    <script type="text/javascript" src="js/ajax_pos_functions.js"></script>
    <script type="text/javascript" src="js/bootstrap-modal.js"></script>
    
    <!-- Le fav and touch icons -->
    <link rel="shortcut icon" href="images/favicon.ico" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="images/apple-touch-icon-144-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="images/apple-touch-icon-114-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="images/apple-touch-icon-72-precomposed.png" />
    <link rel="apple-touch-icon-precomposed" href="images/apple-touch-icon-57-precomposed.png" />
    
    <script type="text/javascript">
        //adding load class to body and hide page
        document.documentElement.className += 'loadstate';
    </script>
	
    <script>
    $(function() {
	    $( "#dp_fecha_venta" ).datepicker({ dateFormat: "dd/mm/yy", dayNamesMin: ["Do","Lu","Ma","Mi","Ju","Vi","Sa"], monthNames: ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"] });
		$( "#dp_f_inicio" ).datepicker({ dateFormat: "dd/mm/yy", dayNamesMin: ["Do","Lu","Ma","Mi","Ju","Vi","Sa"], monthNames: ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"] });

		$( "#dp_f_termino" ).datepicker({ dateFormat: "dd/mm/yy", dayNamesMin: ["Do","Lu","Ma","Mi","Ju","Vi","Sa"], monthNames: ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"] });
	    $( "#dp_fecha_ocompra" ).datepicker({ dateFormat: "dd/mm/yy", dayNamesMin: ["Do","Lu","Ma","Mi","Ju","Vi","Sa"], monthNames: ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"] });
	    $( "#dp_fecha_entrega" ).datepicker({ dateFormat: "dd/mm/yy", dayNamesMin: ["Do","Lu","Ma","Mi","Ju","Vi","Sa"], monthNames: ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"] });
				
	  });

	<?php 
 	if ($sw_error==11) { ?>
	 	$(document).ready(function(){
			$.pnotify({
				type: 'error',
			    title: 'ERROR ARCHIVO ADJUNTO!',
	    		text: '\nFormato Cotizaci\363n inv\341lido. Opciones v\341lidas: \n [WORD, EXCEL, PDF].',
			    icon: 'picon icon24 typ-icon-cancel white',
			    opacity: 0.95,
			    history: false,
			    sticker: false
			});
		});
	<?php } ?>
 	<?php
 	if ($sw_error==1) { ?>
	 	$(document).ready(function(){
			$.pnotify({
				type: 'error',
			    title: 'ERROR DE INGRESO!',
	    		text: 'ORDEN DE COMPRA ya fue registrada.',
			    icon: 'picon icon24 typ-icon-cancel white',
			    opacity: 0.95,
			    history: false,
			    sticker: false
			});
		});
	<?php } ?>
	
	function volver()
	{
		document.factura_arrdo.oper.value=0;
		document.factura_arrdo.status.value=0;
		document.factura_arrdo.submit();
	}
	function agregar()
	{
		document.factura_arrdo.oper.value=1;
		document.factura_arrdo.submit();
	}
	function cancelar()
	{
		document.factura_arrdo.oper.value=0;
		document.factura_arrdo.submit();
	}
	function editar( id )
	{
		document.factura_arrdo.oper.value=3;
		document.factura_arrdo.id.value=id;
		document.factura_arrdo.submit();
	}
	function borrar( nombre, id )
	{
		if (confirm("\277 Confirma la eliminaci\363n de esta Orden de Compra: #\n" + nombre + " ?")) {
			document.factura_arrdo.id.value = id;
			document.factura_arrdo.oper.value = 4;
			document.factura_arrdo.submit();
		}
	}
	
	function busqueda()
	{
		document.factura_arrdo.submit();
	}

	function resetear()
	{
		
		document.factura_arrdo.f_inicio.value = "";
		document.factura_arrdo.f_termino.value = "";
		document.factura_arrdo.f_cliente.selectedIndex = 0;
		document.factura_arrdo.submit();
	}

	function enlacePaginacion( pagina ) 
	{
		document.factura_arrdo.page.value=pagina;
		document.factura_arrdo.submit();
	}
	function ordenar( orden )
	{
		document.factura_arrdo.orden.value = orden;
		document.factura_arrdo.submit();
	}
	$(document).ready(function(){
			$('#confirmsale3').attr('disabled','disabled');
			  $("#descTotalOculto").hide();
                        $("#DetCheques").hide();
                        $("#aldia").show();              
                        $("#30dias").hide();
                        $("#60dias").hide();
                        $("#90dias").hide();
						$("#DetCheques").hide();
			
	
		
		$("#plazos").change(function(){                                                                            
                        if(this.value==1)
                        {
                            $("#aldia").show();
                            $("#30dias").hide();
                            $("#60dias").hide();
                            $("#90dias").hide();    
                        }else if(this.value==2)
                        {
                            $("#30dias").show();
                            $("#aldia").hide(); 
                            $("#60dias").hide();
                            $("#90dias").hide();
                        }else if(this.value==3)
                        {
                            $("#60dias").show();
                            $("#aldia").hide();              
                            $("#30dias").show();
                            $("#90dias").hide();
                        }else if(this.value==4)
                        {
                            $("#90dias").show();
                            $("#aldia").hide();              
                            $("#30dias").show();
                            $("#60dias").show();
                        }
                        
                        });	
			$("#medio_pago").change(function(){
                                                    
                        if(this.value==3)
                        {
                                $("#DetCheques").show();
                                document.ventas.plazos.selectedIndex=0;
                        }else{
                             $("#DetCheques").hide();
                        }
                        
                        });
						
			$('#search_cliente').click(function(){				
				$('#popup2').fadeIn('fast');
				$('.popup2-overlay').fadeIn('fast');
				$('.popup2-overlay').height($(window).height());		
				return false;			
			}); 
			$('#close2').click(function(){
				$('#popup2').fadeOut('fast');
				$('.popup2-overlay').fadeOut('fast');
				return false;
			});
			
				$('#busqueda').click(function(){
					
				var ret = 0;
				if(ret == 0){
					if($('#factura').val()==""){
						ret = 1;
						alert('Por favor Ingrese Número de Factura');
						$('#factura').focus();
					}
				}
				if(ret == 0){
					if($('#clienteRut').val()==""){
						ret = 1;
						alert('Por favor Asocie un Cliente');
						$('#clienteRut').focus();
					}
				}
				
				if(ret == 0){
						
				$('#popup10').fadeIn('fast');
				$('.popup10-overlay').fadeIn('fast');
				$('.popup10-overlay').height($(window).height());		
				$('.text').focus();		
				return false;	
				}
				
					
			});
			
			$('#close10').click(function(){
				$('#popup10').fadeOut('fast');
				$('.popup10-overlay').fadeOut('fast');
				return false;
			});
				
			
			
			$('#efectivo').keypress(function(e){   
				if(e.which == 13){               
					var valorTotals = document.getElementById("bruto").innerHTML;
					var valorTota;
					valorTota = valorTotals.replace("$", ''); 
					valorTota = valorTota.replace(".", '');            
					var efectivo = document.getElementById("efectivo");            
					if (valorTota!=0)
					 {                       
						vuelto_factura( $('#efectivo').val()); 
									
					 }else if(efectivo.value=="")
					 {
						alert("Ingrese un Valor");
					 }else
						alert("No ha ingresado Productos!");
						//efectivo.value="";
						$('#efectivo').focus();
				}				  
			});
			
			
			/*$('#factura').keypress(function(e){   
				if(e.which == 13){               
					GeneraFactura($(this).val());
				}				  
			});*/
		
		$('#desctotal').keypress(function(e){   
			if(e.which == 13){               
				UpdateTotalFact($(this).val());
			}				  
		});
		
		$('#codigopfact').keypress(function(e){   
			if(e.which == 13){               
				LoadProductsFactArrdo();
			}				  
		});
				
				

});


function guardar()
{
	javascript:jsWebClientPrint.print('useDefaultPrinter=' + $('#useDefaultPrinter').attr('checked') + '&printerName=' + $('#installedPrinterName').val() + '&valebolet=' + $('#factura').val());
	document.factura_arrdo.oper.value=0;
	document.factura_arrdo.submit();
}

    </script>
    

    
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head>
      
    <body>
	<form method="post" action="arriendos.php" target="_self" enctype="multipart/form-data" name="factura_arrdo" id="factura_arrdo" onKeypress="if(event.keyCode == 13) event.returnValue = false;" onSubmit="return false;">
    <!-- loading animation -->
    <div id="qLoverlay"></div>
    <div id="qLbar"></div>
    
    <div id="header">

        <div class="navbar">
          <div class="mylogo">
            <div class="navbar-inner">
              <div class="container-fluid">
                <div class="nav-no-collapse">
                    <ul class="nav pull-right usernav">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle avatar" data-toggle="dropdown">
                               
                                <span class="txt"><?php echo $nom_usuario;?></span>
                                <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu">
                                <li class="menu">
                                    <ul>
                                        <li>
                                            <a href="#"><span class="icon16 icomoon-icon-user-3"></span>Editar Perfil</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li><a href="index.php"><span class="icon16 icomoon-icon-exit"></span> Salida</a></li>
                    </ul>
                </div><!-- /.nav-collapse -->
              </div>
            </div><!-- /navbar-inner -->
            </div>
          </div><!-- /navbar --> 

    </div><!-- End #header -->

    <div id="wrapper">

        <!--Responsive navigation button-->  
        <div class="resBtn">
            <a href="#"><span class="icon16 silk-icon-icons"></span></a>
        </div>
        
        <!--Sidebar collapse button-->  
        <div class="collapseBtn">
             <a href="#" class="tipR" title="Ocultar Menu"><span class="icon12 minia-icon-layout"></span></a>
        </div>

        <!--Sidebar background-->
        <div id="sidebarbg"></div>
        <!--Sidebar content-->
        <div id="sidebar">


            <div class="sidenav">

                <div class="sidebar-widget" style="margin: -1px 0 0 0;">
                    <h4 class="title" style="margin-bottom:0;">Menu Navegaci&oacute;n</h4>
                </div><!-- End .sidenav-widget -->

                <div class="mainnav">
                	<?php 	include "menu.php";?>
                </div>
                
            </div><!-- End sidenav -->


        </div><!-- End #sidebar -->

        <div id="content" class="clearfix" style="min-height: 530px;">
        <!--Body content-->
        <?php
		if ($oper==0) {	// Visualizar
			if(isset($_POST['page'])){
			    $page= $_POST['page'];
			}else{
			    $page=1;
			}	
			$rows_per_page= 10;
			$tiene_filtro = false;
			$query = "SELECT * from factura_arrdo A";
			if ($f_inicio <> "") {
				if ($tiene_filtro==false) {
					$tiene_filtro = true;
					$condicion = " WHERE DATE_FORMAT(A.fecha, '%d/%m/%Y') >= '".strtoupper(trim($f_inicio))."'";
				} else {
					$condicion = $condicion . " AND DATE_FORMAT(A.fecha, '%d/%m/%Y') >= '".strtoupper(trim($f_inicio))."'";
				}
			}	
			if ($f_termino <> "") {
				if ($tiene_filtro==false) {
					$tiene_filtro = true;
					$condicion = " WHERE DATE_FORMAT(A.fecha, '%d/%m/%Y') <= '".strtoupper(trim($f_termino))."'";
				} else {
					$condicion = $condicion . " AND DATE_FORMAT(A.fecha, '%d/%m/%Y') <= '".strtoupper(trim($f_termino))."'";
				}
			}	
			if ($f_cliente > 0) {
				if ($tiene_filtro==false) {
					$tiene_filtro = true;
					$condicion = " WHERE A.cliente_id = ".trim($f_cliente);
				} else {
					$condicion = $condicion . " AND A.cliente_id = ".trim($f_cliente);
				}
			}	
			$query = $query . $condicion;
			$result = mysqli_query($con,$query);
			$num_rows=mysqli_num_rows($result);	
			$lastpage= ceil($num_rows / $rows_per_page);
			//COMPRUEBO QUE EL VALOR DE LA P�GINA SEA CORRECTO Y SI ES LA ULTIMA P�GINA
			$page=(int)$page;
			if($page > $lastpage){
			    $page= $lastpage;
			}
			if($page < 1){
			    $page=1;
			}	
			//CREO LA SENTENCIA LIMIT PARA A�ADIR A LA CONSULTA QUE DEFINITIVA
			$limit= 'LIMIT '. ($page -1) * $rows_per_page . ',' .$rows_per_page;
			?>
            <div class="contentwrapper"><!--Content wrapper-->

                <div class="heading">

                    <?php include "info.php";?>

                </div><!-- End .heading-->

                <!-- Build page from here: -->
                    <div class="row-fluid">

                        <div class="span12">
                            
                            <div class="box">

                                <div class="title">
                                    <h4>
                                        <span class="icon16 silk-icon-checklist"></span>
                                         <span>Lista De Facturas Arriendos</span>
									  <!--<span style="margin-left:5%;"><input type="checkbox" class="nonstyle"onclick="marcar(this);"> </span>
									  <span style="color:blue;font-size:12px;">Seleccionar Todos</span>-->
									<button class="btn btn-success btn-mini tipL marginR10 marginB10 right" title="Nueva Factura" id="neworder" onclick="agregar()">Nueva Factura
                                           
                                        </button>
									
                                    </h4>
                                </div>
                                <div class="content noPad">
	                                <div class="form-row row-fluid" style="text-align: left;">
                                            
	                                    <div class="span12">
	                                        <div class="row-fluid" style="height: 34px;">
                                                   
                                                    <!--<span class="span1" style="margin-left: 10px; border: 0px dotted blue;"><button class="btn tipL" title="Limpiar Filtros" href="#" onClick="limpiar();"><span class="icon12 icomoon-icon-link-2"></span></button></span> -->
	                                        	  <span class="span1" style="margin-left: 10px; border: 0px dotted blue;"><button class="btn tipL" title="Limpiar Filtros" href="" onClick="resetear();"><span class="icon12 icomoon-icon-link-2"></span></button></span>
	                                        	<span class="span1" style="margin-left: 50px; border: 0px dotted red;"><input id="dp_f_inicio" name="f_inicio" type="text" value="<?php echo $f_inicio;?>" maxlength="10" placeholder="Inicio" /></span>
	                                        	<span class="span1" style="margin-left: 10px; border: 0px dotted yellow;"><input id="dp_f_termino" name="f_termino" type="text" value="<?php echo $f_termino;?>" maxlength="10" placeholder="Termino" /></span>
	                                            <span class="span4" style="margin-left: 20px; border: 0px dotted red;">
	                                            <select name="f_cliente" id="f_cliente" class="nostyle" style="width: 240px;">
													<OPTION>Seleccione Cliente</OPTION>
													<?php
														$query = "SELECT * from clientes where estado=0 order by id";
														$result = mysqli_query($con,$query);
														while ($row = mysqli_fetch_array($result))
														{
															if ($f_cliente==$row["id"]) {
																echo "<OPTION value=".$row["id"]." selected>".$row["razon_social"]."</OPTION>\n";
															} else {
																echo "<OPTION value=".$row["id"].">".$row["razon_social"]."</OPTION>\n";
															}
														}
														mysqli_free_result($result);
													?>
	                                            </select>&nbsp;&nbsp;
                                                     
	                                            
	                                            </span>
                                                        <span class="span1" style="border: 0px dotted green; text-align: left; margin-left: -80px;"><button class="btn tipR" title="Filtrar Facturas" href="#" onClick="busqueda();"><span class="icon12 brocco-icon-filter"></span></button></span>
	                                        </div>
	                                    </div>
	                                </div>
                                    <table class="responsive table table-bordered">
                                        <thead>
                                          <tr>
                                            <th style="text-align: center; width: 3%;">#</th>
                                            <th style="text-align: center; width: 10%;">Fecha&nbsp;&nbsp;&nbsp;<a href="#" onClick="ordenar(11);"><span class="icon-chevron-up" title="Ascendente"></span></a>&nbsp;<a href="#" onClick="ordenar(12);"><span class="icon-chevron-down" title="Descendente"></span></a></th>
                                            <th style="text-align: left; width: 18%;">&nbsp;Factura&nbsp;&nbsp;&nbsp;<a href="#" onClick="ordenar(21);"><span class="icon-chevron-up" title="Ascendente"></span></a>&nbsp;<a href="#" onClick="ordenar(22);"><span class="icon-chevron-down" title="Descendente"></span></a></th>
                                            <th style="text-align: left;">&nbsp;Cliente&nbsp;&nbsp;&nbsp;<a href="#" onClick="ordenar(31);"><span class="icon-chevron-up" title="Ascendente"></span></a>&nbsp;<a href="#" onClick="ordenar(32);"><span class="icon-chevron-down" title="Descendente"></span></a></th>
                                            <th style="text-align: center; width: 20%;">Dirección</th>
                                            <th style="text-align: center; width: 10%;">Total</th>
                                            <th width="40" style="text-align: center;">Estado</th>
                                            <th width="10%">Acciones</th>
                                          </tr>
                                        </thead>
                                        <tbody>
                                        <?php
										$contador=(($page-1)*($rows_per_page));
										if ($orden==11 || $orden==0) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY A.fecha DESC ";
										}
										if ($orden==12) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY A.fecha ASC ";
										}
										if ($orden==21) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY A.compra ASC ";
										}
										if ($orden==22) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY A.compra DESC ";
										}
										if ($orden==31) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY B.razon_social ASC ";
										}
										if ($orden==32) {
											$query = "SELECT A.*, DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaCompra', B.razon_social,B.direccion FROM factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.ID ".$condicion." ORDER BY B.razon_social DESC ";
										}
										$query .= " $limit";
										//echo "<tr><td colspan=6>".$query."</td></tr>\n";
										$result = mysqli_query($con,$query);
										while ($row = mysqli_fetch_array($result))
										{
                                		    echo "<TR>\n";
                                		    $contador=$contador+1;
											?>
	                                          <tr>
	                                            <td style="text-align: center;"><?php echo $contador;?></td>
	                                            <td style="text-align: center;"><?php echo $row["FechaCompra"];?></td>
	                                            <td style="text-align: left;">&nbsp;<?php echo trim($row["factura"]);?></td>
	                                            <td style="text-align: left;">&nbsp;<?php echo $row["razon_social"];?></td>
	                                            <td style="text-align: center;"><?php echo $row["direccion"];?></td>
	                                            <td style="text-align: center;"><?php echo "$".number_format($row["monto_total"],0,",",".");?></td>
												 <?php if ($row["estado"]==1) { ?>
		                                            <td style="text-align: center;"><code  class="btn-success tipL" title="Orden Pagada"><span class="icon10 icomoon-icon-checkmark white"></code></td>
		                                        <?php } else { ?>
		                                            <td style="text-align: center;"><code class="btn-danger tipL" title="Orden Pendiente"><span class="icon10 icomoon-icon-cancel-2 white"></code></td>
		                                        <?php } ?> 
													<td>											
														 <?php if ($row["acepta_compra"]==0) { ?>
														 <a href="#" title="Editar Factura" class="tip" onClick="editar(<?php echo trim($row['id']);?>);"><span class="icon12 icomoon-icon-pencil"></span></a>
														<?php } ?>																												
													</td>    
	                                           
	                                          </tr>
	                                    <?php      
										}
										mysqli_free_result($result);
										?>
                                        </tbody>
                                    </table>
                                </div>
								<?php
								//UNA VEZ Q MUESTRO LOS DATOS TENGO Q MOSTRAR EL BLOQUE DE PAGINACI�N SIEMPRE Y CUANDO HAYA M�S DE UNA P�GINA
								if($num_rows != 0){
									$nextpage= $page +1;
									$prevpage= $page -1;
									?>
                                    <div class="pagination">
									<table border=0 cellspacing=0 cellpadding=0 align="center">
									<tr>
									<td>	
										<ul id="pagination-digg">
										<?php
										//SI ES LA PRIMERA P�GINA DESHABILITO EL BOTON DE PREVIOUS, MUESTRO EL 1 COMO ACTIVO Y MUESTRO EL RESTO DE P�GINAS
										if ($page == 1) {
										?>
											<li><a href="#"><span class="icon12 minia-icon-arrow-left-3"></span></a></li>											
											<li class="active"><a href="#">1</a></li> 
										<?php
											for($i= $page+1; $i<= $lastpage ; $i++){
										?>
												<li><a href="#" onClick="enlacePaginacion(<?php echo trim($i);?>);"><?php echo $i;?></a></li>
										<?php 
									 		}
										//Y SI LA ULTIMA P�GINA ES MAYOR QUE LA ACTUAL MUESTRO EL BOTON NEXT O LO DESHABILITO
											if($lastpage >$page ){
										?>		
												<li><a href="#" onClick="enlacePaginacion(<?php echo trim($nextpage);?>);"><span class="icon12 minia-icon-arrow-right-3"></span></a></li>
										<?php
											}else{
										?>
												<li><a href="#"><span class="icon12 minia-icon-arrow-right-3"></span></a></li>
										<?php	
											}
										} else {
										//EN CAMBIO SI NO ESTAMOS EN LA P�GINA UNO HABILITO EL BOTON DE PREVIUS Y MUESTRO LAS DEM�S
										?>
											<li><a href="#" onClick="enlacePaginacion(<?php echo trim($prevpage);?>);"><span class="icon12 minia-icon-arrow-left-3"></span></a></li>											
										<?php
											for($i= 1; $i<= $lastpage ; $i++){
												//COMPRUEBO SI ES LA P�GINA ACTIVA O NO
												if($page == $i){
										?>	
													<li class="active"><a href="#"><?php echo $i;?></a></li>
										<?php
												}else{
										?>	
													<li><a href="#" onClick="enlacePaginacion(<?php echo trim($i);?>);"><?php echo $i;?></a></li>
										<?php
												}
											}
											//Y SI NO ES LA �LTIMA P�GINA ACTIVO EL BOTON NEXT		
											if($lastpage >$page ){	
										?>	
												<li><a href="#" onClick="enlacePaginacion(<?php echo trim($nextpage);?>);"><span class="icon12 minia-icon-arrow-right-3"></span></a></li>
										<?php
											}else{
										?> 
												<li><a href="#"><span class="icon12 minia-icon-arrow-right-3"></span></a></li>
										<?php
											}
										}	  
										?>
										</ul>
									</td>
									</tr>
									</table>
									</div>
								<?php
								} ?>			

                            </div><!-- End .box -->

                        </div><!-- End .span6 -->

                    </div><!-- End .row-fluid -->

            </div><!-- End contentwrapper -->
    	<?php } 
    	if ($oper==1) {
			?>	    	
            <div class="contentwrapper"><!--Content wrapper-->

                <div class="heading">

                    <?php include "info.php";?>

                </div><!-- End .heading-->

                <!-- Build page from here: -->
                   <div class="row-fluid">

                        <div class="span12">

                            <div class="box">

                                <div class="title">

                                    <div class="title">

                                    <h4>
                                        <span class="icon16 entypo-icon-upload"></span>
                                        <span>Nueva Factura</span>
                                    </h4>
                                    
									</div>
                                <div class="content" style=" min-height: 120px;">
                                   
                          
                                        <div class="span12">
                                            <div class="row-fluid">
                                                <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Fecha Factura</label>
                                                <div class="span2 controls" style="margin-left:0;padding-left:0;width:10%;">   
												<input id="dp_fecha_venta" name="fecha" type="text" value="<?php echo date('d/m/Y')?>" size="10" maxlength="10" style="width:75%;" />
                                                </div>
												
												
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;" >Guia</label>
													<div class="span2 controls" style="margin-left:0;padding-left:0;width:10%;">   
														<input id="guia" name="guia" class="mayuscula" type="text" value="" maxlength="10" style="width:75%;" />
													</div>
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">Factura</label>
														
                                                <div class="span2 controls" style="height: 24px;width:10%;"> 
																			
												<input id="factura" name="factura" onkeyup="format(this)" onblur="if(this.value!= '' ){GeneraFacturaArrdo(this.value)};"  class="mayuscula" type="text" value="<?php echo $factura;?>" maxlength="10" style="width:75%;" />
													
                                                </div>
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">Cotizaci&oacute;n</label>
                                                <div class="span2 controls" style="height: 24px;width:10%;">   
                                                   <input id="cotizacion" name="cotizacion" type="text" value="" maxlength="10" style="width:75%;" onblur="val_numeros(this);" />
                                                </div>
												<label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">O. Compra</label>
													<div class="span2 controls" style="height: 24px;width:10%;">   
													   <input id="ordencomp" name="ordencomp" type="text" value="" maxlength="10" style="width:75%;" onblur="val_numeros(this);" />
													</div>
                                            </div>
                                     
                               
									
									<div id="load_datacl">  
                                   <div class="row-fluid">
														<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Rut Cliente</label>
															<div class="span2 controls" style="margin-left:0;padding-left:0;"> 
															<input id="clienteRut" name="clienteRut"  placeholder="ej. 18211738-2" onblur="cargaDatosCliente();" class="mayuscula" type="text" value="<?php echo $rut;?>" maxlength="10" style="width:55%;" />
															<!--<a class="btn btn-mini tipL marginR10 marginB10 right" title="Buscar Cliente" data-toggle="modal" href="#client_search" >
															<img src="images/search_p.png">
                                                             </a>
															 -->
															 <input type="image" src="images/search_p.png" border="0" class="btn tipR" style="padding:2px; "  id="search_cliente" title="Buscar Cliente" aria-describedby="ui-tooltip-5" width="10" height="15">
																<input type="image" src="images/plus.png" border="0" class="btn tipR" style="padding:2px; "  id="search_cliente" title="Agregar Cliente" aria-describedby="ui-tooltip-5" width="10" height="15">
																
															</div>
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Nombre</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="RazonSocialnombre" name="RazonSocialnombre" class="mayuscula" type="text" value="<?php echo $razon_social;?>" style="width:80%;" />

															</div>
															
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Direccion</label>
																<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																 <input id="Direccion" name="Direccion" class="mayuscula" type="text" value="<?php echo $direccion;?>" maxlength="10" style="width:80%;" />
																</div>
													</div>
													
													<div class="row-fluid">
													
														<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Correo</label>
														<div class="span2 controls" style="margin-left:0;padding-left:0;"> 
															<input id="correo" name="correo" class="mayuscula" type="text" value="<?php echo $email;?>" maxlength="10" style="width:80%;" />
														</div>
														
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Teléfono</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="clienteFono"  name="clienteFono" class="mayuscula" type="text" value="<?php echo $telefonos;?>" maxlength="10" style="width: 37%;" />                                                              
															</div>

													  <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">G. Comercial</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="giro_comercial" name="giro_comercial" class="mayuscula" type="text" value="<?php echo $giro_comercial;?>" maxlength="10" style="width: 80%;" />
															</div>
														</div>
																																										
													<div class="row-fluid">
													   <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Aclaraciones</label>
													   <div class="span7 controls " style="margin-left:0;padding-left:0;">  												   
															<input id="observaciones" style="width: 71%;"type="text" name="observaciones" >
														</div>
														</div>
													</div>
													</div>
													</div>
													
												
                                       
                                    
                                
                                    
                                    
                                    <!--<iframe name="ifrm1" id="ifrm1" src="blank1.html" width="100%" height="340" scrolling="no" frameborder="0">Sorry, your browser doesn't support iframes.</iframe>-->
                                        <!-- PANTALLA DE VENTA -->
						<div class="content" style=" min-height: 800px;">  
						
						
										<div class="contentwrapper"><!--Content wrapper-->

                                        <!-- Build page from here: -->
										 <div class="row-fluid">
									
									
										
										
											<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Codigo Producto<img style="margin-left:2%;" src="images/Product-Search.png" width="25"></label>
												
												<div class="span3" style="margin-left:0;padding-left:0;">
													
													<input type="text" id="codigopfact" name="codigopfact"  style="width:90%;" />
													
												</div>
												
												<label class="form-label span1" for="checkboxes" style="font-weight:bold;margin-left:2%;width:8%;">Cantidad</label>
												<div class="span1" style="margin-left:0;padding-left:0;">
													<input type="number" value='1' min='1' id="cantidadpfact" name="cantidadpfact" style="width:50%;" />
												</div>
												
												<div class="span3 controls" style="margin-left:0;padding-left:0;width:22%;">
													<button class="btn btn-primary" type="button"   id="" onclick="LoadProductsFactClick()" align="" style="">Agregar Producto</button>
															
												</div>
												
												<div class="span3 controls" style="margin-left:0;padding-left:0;">
													
													<a class="btn btn-success tipL marginR10 marginB10 right" style="width:60%;" title="Agregar Nuevo Producto" id="busqueda">Buscar Producto

                                                   </a>		
												</div>
												
												

											
									</div>
										
										
                                                <div class="row-fluid">

                                                    <div class="span12">

                                                        <div class="box">

                                                            <div class="title">
                                                                <h4>
                                                                    <span class="icon16 brocco-icon-list"></span>
                                                   
																	
																	<a class="btn btn-warning btn-mini tipL marginR10 marginB10 right" title="Agregar Nuevo Producto">Ingresar Guía Despacho

                                                                    </a>
                                                                    
                                                                </h4>
                                                            </div>
                                                             <div class="content" style="background-color:#fff;">
														   <div id="resultado2" style="height:250px;">
																<table class="table table-striped table-bordered">
																	<thead>
																			<tr>
																			<th>Item</th>
																			<th>Codigo</th>
																			<th>Detalle Producto</th>
																			<th>Cantidad</th>
																			<th>Precio</th>																		
																			<th>(%)Descuento</th>																		
																			<th>Fecha Incio</th>																		
																			<th>Fecha Final</th>																		
																			<th>Dias</th>																		
																			<th>Subtotal</th>																																																																
																			<th>Acciones</th>
																			
																			</tr>
																			
																	</thead>
																	  <tbody id="resultado">
                                         
                                        
																	  </tbody>
															</table>
														</div>
														</div>
                      
		<div class="content" style="padding-bottom:0;height:10px;margin-top:0;padding-top:0;">   </div>								
		<div class="content" style="padding-bottom:0;height:12%;margin-top:0;padding-top:0;">           
                 <div class="row-fluid">
                
                    <div class="span12">					
						<div class="span6" style="" >

                            <div class="box">

                                <div class="title">

                                    <h4>
                                        <span><img src="images/payment.png" width="30" height="30"></span>
                                        <span>Medio de Pago</span>
                                    </h4>
                                   
                                </div>
                                <div class="content" style="height:225px;">
                                   <div class="row-fluid">

                                       <div class="span10" style="margin-left:35px;" >
                           <table class="responsive table table-striped table-bordered table-condensed" >
                                <thead>
                                  
                                </thead>
                                <tbody>
                                 <tr>
                                     <td colspan="2">
													<select class="nostyle" name="medio_pago" id="medio_pago"  style="width: 80%;">
                                                                    
                                                      <?php
																$query = "SELECT * from condicion_pago where estado=0 order by id";
																$result = mysqli_query($con,$query);
																while ($row = mysqli_fetch_array($result))
																{
																	if ($pago==$row["id"]) {
																		echo "<OPTION value=".$row["id"]." selected>".$row["condicion"]."</OPTION>\n";
																	} else {
																		echo "<OPTION value=".$row["id"].">".$row["condicion"]."</OPTION>\n";
																	}
																}
																mysqli_free_result($result);
															?>
                                                     </select>
									</td>
								
									<td style="font-weight:bold;color:blue;">
									$<input type="text" id="efectivo" style="width:50%;" onkeyup="format(this);"></input></td>
									
                             
                                  </tr>
                                </tbody>
                            </table>
							
							<table class="responsive table table-striped table-bordered table-condensed" style="width: 70%;" id="DetCheques">
                                <thead>
                                  
                                </thead>
                                <tbody>
                                    <tr>
                                     <td colspan="2"><select class="nostyle" name="plazos" id="plazos"  style="width: 50%;">
                                                                    
                                                               <?php
																$query = "SELECT * from plazos order by id";
																$result = mysqli_query($con,$query);
																while ($row = mysqli_fetch_array($result))
																{
																	if ($pago==$row["id"]) {
																		echo "<OPTION value=".$row["id"]." selected>".$row["plazos"]."</OPTION>\n";
																	} else {
																		echo "<OPTION value=".$row["id"].">".$row["plazos"]."</OPTION>\n";
																	}
																}
																mysqli_free_result($result);
															?>
                                                                </select></td>
                                     
                                  </tr>
                                  <tr>
                                        <td id="aldia" colspan="2">Al día Nº <input style="width:50px;" type="text" name="txtChequedia" id="txtChequedia" value="<?php echo $serieAlDia; ?>" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoAlDia" onkeyup="format(this);" id="txtMontoAlDia" value="<?php echo $montoAlDia; ?>" /></td>
                                     
                                  </tr>
									<tr>
                                     <td id="30dias" colspan="2">A 30 dias Nº <input style="width:50px;" type="text" name="txtCheque30Dias" value="<?php echo $serie30 ?>" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA30" onkeyup="format(this);" id="txtMontoA30" value="<?php echo $monto30; ?>" /></td>
                                     
                                  </tr>
                                    <tr>
                                        <td id="60dias" colspan="2">A 60 dias Nº <input style="width:50px;" type="text" name="txtCheque60dias" value="" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA60" onkeyup="format(this);" id="txtMontoA60" value="" /></td>
                                     
                                  </tr>
                                   <tr>
                                        <td id="90dias" colspan="2">A 90 dias Nº <input style="width:50px;" type="text" name="txtCheque90dias" value="" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA90" onkeyup="format(this);" id="txtMontoA90" value="" /></td>
                                     
                                  </tr>
                                </tbody>
                            </table>

                        </div><!-- End .span6 -->


                    </div><!-- End .row-fluid -->

                                </div>

                            </div><!-- End .box -->

                        </div><!-- End .span4 -->
                        
                      	<div class="span6" style="float:">

								<div class="box">

                                <div class="title">

                                    <h4>
                                        <span><img src="images/money_icon.png" width="30" height="30"></span>
                                        <span>Total Factura</span>
                                    </h4>
                                   
                                </div>
                                <div class="content">
                                   <div class="row-fluid">

                                       <div class="span10" style="margin-left:15%;" >
										   <table class="responsive table table-striped table-bordered table-condensed" style="width:80%;">
											<thead>
											  
											</thead>
											<tbody>
											<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">(%)Descuento</td>
												 <td><input type="text" style="width:30%;" id="desctotal" onblur=""></td>
											</tr>
											 <tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">Total Neto</td>
												 <td><div id="actualizaTotal" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($total_factura,0,",","."); ?></div></td>
											  </tr>
												<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">IVA</td>
												 <td><div id="iva" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($total_factura,0,",","."); ?></div></td>
											  </tr>
												<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">Total</td>
												 <td><div id="bruto" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($total_factura,0,",","."); ?></div></td>
												</tr>
												
											
												 <tr>
												 
												 <td colspan="2" style="text-align:center;color: black;font-family:arial;font-weight:bold;font-size:20px;">Vuelto</td>
												 <td><div id="vuelto" style="color: green;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format(0,0,",","."); ?></div></td>
											  </tr>
											</tbody>
                            </table>
							
							

                        </div><!-- End .span6 -->
					<div class="row-fluid">
								
						<div class="span12">
							<label class="checkbox">
								<input style="display:none;" class="nostyle" type="checkbox" id="useDefaultPrinter" checked/>
								</label>
								<!--<div id="loadPrinters">
								
								<input type="button" onclick="javascript:jsWebClientPrint.getPrinters();" value="Load installed printers..." />
												
							
								</div>
								<div id="installedPrinters" style="visibility:hidden">
							
								<label for="installedPrinterName">Seleccionar una impresora Instalada:</label>
								<select name="installedPrinterName" id="installedPrinterName"></select>
								</div>-->
										
								
												
													
												<script type="text/javascript">
													var wcppGetPrintersDelay_ms = 5000; //5 sec

													function wcpGetPrintersOnSuccess(){
														// Display client installed printers
														if(arguments[0].length > 0){
															var p=arguments[0].split("|");
															var options = '';
															for (var i = 0; i < p.length; i++) {
																options += '<option>' + p[i] + '</option>';
															}
															$('#installedPrinters').css('visibility','visible');
															$('#installedPrinterName').html(options);
															$('#installedPrinterName').focus();
															$('#loadPrinters').hide();                                                        
														}else{
															alert("No printers are installed in your system.");
														}
													}

													function wcpGetPrintersOnFailure() {
														// Do something if printers cannot be got from the client
														alert("No printers are installed in your system.");
													}
												</script>
												
												<!-- Add Reference to jQuery at Google CDN -->


												<?php
												//Specify the ABSOLUTE URL to the php file that will create the ClientPrintJob object
												//In this case, this same page
												echo WebClientPrint::createScript('http://localhost/oxigeno/facturas.php');
						
							
									if($_SESSION['desRolUsuario']== "ADMINISTRADOR")
												{
												?>
						<!--<button class="btn btn center" id="confirmsale3" style="padding:10px;border:1px solid black;width:45%;margin-left:15%;float:left;" onclick="PrintFacturaDoc()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Electrónica</button>-->                                 
						
						<button class="btn btn-success center" id="confirmsale1" style="padding:10px;border:1px solid black;width:25%;margin-left:15%;float:left;" onclick="validaConfirmaFacturaArrdo()"><span class=""></span>Confirmar Factura</button> 
						                                
                       <button class="btn btn-warning center" id="confirmsale2" style="padding:10px;border:1px solid black;width:25%;margin-left:3%;float:left;" onclick="validaConfirmSaveFacturaArrdo();"><span class=""></span>Guardar Factura</button>

						<?php
												}
												
								if($_SESSION['desRolUsuario']== "VENTAS"){
						 ?>
						     <button class="btn btn-warning center" id="confirmsale2" style="padding:10px;border:1px solid black;width:25%;margin-left:15%;float:left;" onclick="validaConfirmSaveFacturaArrdo();"><span class=""></span>Guardar Factura</button>
							<?php
								}
							?>
							<!--<button class="btn btn center" id="confirmsale1" style="padding:10px;border:1px solid black;width:25%;margin-left:15%;float:left;" onclick="validaConfirmaFactura()"><span class=""></span>Confirmar Factura</button>-->                                 
							<button class="btn btn-danger center" id="confirmsale4" style="padding:10px;border:1px solid black;width:25%;margin-left:3%;float:left;" onclick="cancelar()"><span class=""></span>Cancelar</button>                                 
							<?php
							if($_SESSION['desRolUsuario']== "ADMINISTRADOR"){
										?>
													
	<button class="btn btn center" id="imprimirfactf" disabled style="padding:10px;border:1px solid black;width:40%;margin-left:15%;float:left;margin-top:2%;"  onclick="guardar()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Física</button> 
										                                
										<?php
										}
										?>                                
						</div>
					</div>
					<div class="row-fluid" style="margin-top:2%;">
								
									<div class="span12">
								
						<!--<button class="btn btn center" id="confirmsale3" style="padding:10px;border:1px solid black;width:45%;margin-left:15%;float:left;" onclick="PrintFacturaDoc()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Electrónica</button>                                 
					    <button class="btn btn center" id="" style="padding:10px;border:1px solid black;width:40%;margin-left:15%;float:left;" onclick="guardar()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Física</button>-->                                 
                        
					</div>
					</div>
							
                    </div><!-- End .row-fluid -->
                                </div>

                            </div><!-- End .box -->

								</div><!-- End .span4 -->                  
							</div>
					</div> 

                           

                        </div><!-- End .span12 -->
	    	
                    </div><!-- End .row-fluid -->

            </div><!-- End contentwrapper -->
			<input type="hidden" name="f_inicio" value="<?php echo $f_inicio;?>" />
			<input type="hidden" name="f_termino" value="<?php echo $f_termino;?>" />
			<input type="hidden" name="f_cliente" value="<?php echo $f_cliente;?>" />
			<input type="hidden" name="f_bodega" value="<?php echo $f_bodega;?>" />
    	<?php }
    	if ($oper==3) {
			$query3 = "SELECT A.*, DATE_FORMAT(A.fecha, '%d/%m/%Y') as 'FechaFactura', B.razon_social, B.rut,B.giro_comercial,B.telefonos,B.email,B.direccion from factura_arrdo A LEFT JOIN clientes B ON A.cliente_id=B.id Where A.id=".trim($id).";";
			$result = mysqli_query($con,$query3);
			while ($row = mysqli_fetch_array($result))
			{
				$id_com=$row["id"];
				if (is_null($row["FechaFactura"])) {
					$fecha = "";
				} else {
					$fecha = trim($row["FechaFactura"]);
				}
				if (is_null($row["factura"])) {
					$factura = "";
				} else {
					$factura = trim($row["factura"]);
				}
				if (is_null($row["guia"])) {
					$guia = "";
				} else {
					$guia = trim($row["guia"]);
				}
				if (is_null($row["o_compra"])) {
					$o_compra = "";
				} else {
					$o_compra = trim($row["o_compra"]);
				}
				if (is_null($row["iva"])) {
					$iva = "0";
				} else {
					$iva = trim($row["iva"]);
				}
				if (is_null($row["neto"])) {
					$neto = "0";
				} else {
					$neto = trim($row["neto"]);
				}
				if (is_null($row["monto_total"])) {
					$monto_total = "0";
				} else {
					$monto_total = trim($row["monto_total"]);
				}
				
				if (is_null($row["rut"])) {
					$rut = "0";
				} else {
					$rut = trim($row["rut"]);
				}
				if (is_null($row["razon_social"])) {
					$razon_social = "";
				} else {
					$razon_social = trim($row["razon_social"]);
				}
				if (is_null($row["direccion"])) {
					$direccion = "";
				} else {
					$direccion = trim($row["direccion"]);
				}
				if (is_null($row["telefonos"])) {
					$telefonos = "";
				} else {
					$telefonos = trim($row["telefonos"]);
				}
				if (is_null($row["giro_comercial"])) {
					$giro_comercial = "";
				} else {
					$giro_comercial = trim($row["giro_comercial"]);
				}
				if (is_null($row["email"])) {
					$email = "";
				} else {
					$email = trim($row["email"]);
				}
				
			}
			mysqli_free_result($result);
			?>	    	
            <div class="contentwrapper"><!--Content wrapper-->

                <div class="heading">

                    <?php include "info.php";?>

                </div><!-- End .heading-->

                <!-- Build page from here: -->
                   <div class="row-fluid">

                        <div class="span12">

                            <div class="box">

                                <div class="title">

                                    <h4>
                                        <span class="icon16 entypo-icon-upload"></span>
										<span>Editar Factura Arriendo</span>
                                    </h4>
                                    
                                </div>
                                <div class="content" style=" min-height: 120px;">
                                   
                          
                                        <div class="span12">
                                            <div class="row-fluid">
                                                <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Fecha Factura</label>
                                                <div class="span2 controls" style="margin-left:0;padding-left:0;width:10%;">   
												<input id="dp_fecha_venta" name="fecha" type="text" value="<?php echo date('d/m/Y')?>" size="10" maxlength="10" style="width:75%;" />
                                                </div>
												
												
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;" >Guia</label>
													<div class="span2 controls" style="margin-left:0;padding-left:0;width:10%;">   
														<input id="guia" name="guia" class="mayuscula" type="text" value="<?php echo $guia;?>" maxlength="10" style="width:75%;" />
													</div>
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">Factura</label>
														
                                                <div class="span2 controls" style="height: 24px;width:10%;"> 
																			
												<input id="factura" name="factura" onkeyup="format(this)" readonly  class="mayuscula" type="text" value="<?php echo $factura;?>" maxlength="10" style="width:75%;" />
													
                                                </div>
                                                <label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">Cotizaci&oacute;n</label>
                                                <div class="span2 controls" style="height: 24px;width:10%;">   
                                                   <input id="cotizacion" name="cotizacion" type="text" value="" maxlength="10" style="width:75%;" onblur="val_numeros(this);" />
                                                </div>
												<label class="form-label span1" for="dato" style="font-weight:bold;margin-left:1%;">O. Compra</label>
													<div class="span2 controls" style="height: 24px;width:10%;">   
													   <input id="ordencomp" name="ordencomp" type="text" value="<?php echo $o_compra;?>" maxlength="10" style="width:75%;" onblur="val_numeros(this);" />
													</div>
                                            </div>
                                     
                               
									
									<div id="load_datacl">  
                                   <div class="row-fluid">
														<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Rut Cliente</label>
															<div class="span2 controls" style="margin-left:0;padding-left:0;"> 
															<input id="clienteRut" name="clienteRut"  placeholder="ej. 18211738-2" onblur="cargaDatosCliente();" class="mayuscula" type="text" value="<?php echo $rut;?>" maxlength="10" style="width:55%;" />
															<!--<a class="btn btn-mini tipL marginR10 marginB10 right" title="Buscar Cliente" data-toggle="modal" href="#client_search" >
															<img src="images/search_p.png">
                                                             </a>
															 -->
															 <input type="image" src="images/search_p.png" border="0" class="btn tipR" style="padding:2px; "  id="search_cliente" title="Buscar Cliente" aria-describedby="ui-tooltip-5" width="10" height="15">
																<input type="image" src="images/plus.png" border="0" class="btn tipR" style="padding:2px; "  id="search_cliente" title="Agregar Cliente" aria-describedby="ui-tooltip-5" width="10" height="15">
																
															</div>
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Nombre</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="RazonSocialnombre" name="RazonSocialnombre" class="mayuscula" type="text" value="<?php echo $razon_social;?>" style="width:80%;" />

															</div>
															
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Direccion</label>
																<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																 <input id="Direccion" name="Direccion" class="mayuscula" type="text" value="<?php echo $direccion;?>" maxlength="10" style="width:80%;" />
																</div>
													</div>
													
													<div class="row-fluid">
													
														<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Correo</label>
														<div class="span2 controls" style="margin-left:0;padding-left:0;"> 
															<input id="correo" name="correo" class="mayuscula" type="text" value="<?php echo $email;?>" maxlength="10" style="width:80%;" />
														</div>
														
															<label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Telefono</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="clienteFono"  name="clienteFono" class="mayuscula" type="text" value="<?php echo $telefonos;?>" maxlength="10" style="width: 37%;" />                                                              
															</div>

													  <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">G. Comercial</label>
															<div class="span3 controls" style="margin-left:0;padding-left:0;"> 
																<input id="giro_comercial" name="giro_comercial" class="mayuscula" type="text" value="<?php echo $giro_comercial;?>" maxlength="10" style="width: 80%;" />
															</div>
														</div>
																																										
													<div class="row-fluid">
													   <label class="form-label span2" for="normal" style="width:11%;font-weight:bold;">Aclaraciones</label>
													   <div class="span7 controls " style="margin-left:0;padding-left:0;">  												   
															<input id="observaciones" style="width: 71%;"type="text" name="observaciones" >
														</div>
														</div>
													</div>
													</div>
													</div>
													
												
                                       
                                    
                                
                                    
                                    
                                    <!--<iframe name="ifrm1" id="ifrm1" src="blank1.html" width="100%" height="340" scrolling="no" frameborder="0">Sorry, your browser doesn't support iframes.</iframe>-->
                                        <!-- PANTALLA DE VENTA -->
						<div class="content" style=" min-height: 800px;">  
						
						
										<div class="contentwrapper"><!--Content wrapper-->

                                        <!-- Build page from here: -->
										 <div class="row-fluid">
									
									
										
										
											<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Codigo Producto<img style="margin-left:2%;" src="images/Product-Search.png" width="25"></label>
												
												<div class="span3" style="margin-left:0;padding-left:0;">
													
													<input type="text" id="codigopfact" name="codigopfact"  style="width:90%;" />
													
												</div>
												
												<label class="form-label span1" for="checkboxes" style="font-weight:bold;margin-left:2%;width:8%;">Cantidad</label>
												<div class="span1" style="margin-left:0;padding-left:0;">
													<input type="number" value='1' min='1' id="cantidadpfact" name="cantidadpfact" style="width:50%;" />
												</div>
												
												<div class="span3 controls" style="margin-left:0;padding-left:0;width:22%;">
													<button class="btn btn-primary" type="button"   id="" onclick="LoadProductsFactClickArrdo()" align="" style="">Agregar Producto</button>
															
												</div>
												
												<div class="span3 controls" style="margin-left:0;padding-left:0;">
													
													<a class="btn btn-success tipL marginR10 marginB10 right" style="width:60%;" title="Agregar Nuevo Producto" id="busqueda">Buscar Producto

                                                   </a>		
												</div>
												
												

											
									</div>
										
										
                                                <div class="row-fluid">

                                                    <div class="span12">

                                                        <div class="box">

                                                            <div class="title">
                                                                <h4>
                                                                    <span class="icon16 brocco-icon-list"></span>

																	<a class="btn btn-warning btn-mini tipL marginR10 marginB10 right" title="Agregar Nuevo Producto">Ingresar Guía Despacho

                                                                    </a>
                                                                    
                                                                </h4>
                                                            </div>
                                                             <div class="content" style="background-color:#fff;">
														   <div id="resultado2" style="height:250px;">
																<table class="table table-striped table-bordered">
																	<thead>
																			<tr>
																			<th>Item</th>
																			<th>Codigo</th>
																			<th>Detalle Producto</th>
																			<th>Cantidad</th>
																			<th>Precio</th>																		
																			<th>(%)Descuento</th>																		
																			<th>Fecha Inicio</th>																		
																			<th>Fecha Final</th>																		
																			<th>Dias</th>																		
																			<th>Subtotal</th>																																																																
																			<th>Acciones</th>
																			
																			</tr>
																			
																	</thead>
																	  <tbody id="resultado" style="" >
																	<?php

$sql=("SELECT a.factura_id as idboleta,a.producto_id as idproduct,a.fecha_inicio,a.fecha_final, a.dias, b.codigo_externo as codigo,b.especificaciones as descripcion, a.descuento,a.cantidad, c.stock,
b.psale_arrdo as precio_prod,a.precio as subtotal,a.enviado FROM factura_det_arrdo a join productos b on a.producto_id = b.id join stock c on b.id = c.producto_id where a.factura_id = ".$factura." and
 c.bodega_id= ".$_SESSION['bodegaidsale']." group by b.id ;");
$result = mysqli_query($con,$sql);
//muestra los datos consultados
//haremos uso de tabla para tabular los resultados


?>


<?php
$contador = 0;
while($row = mysqli_fetch_array($result)){
$contador++;
$totalbyprod = $row['precio_prod'] * $row['cantidad'];

	echo "	<tr>";
	echo " 		<td>".$contador."</td>";			
	echo " 		<td>".$row['codigo']."</td>";
	echo " 		<td>".$row['descripcion']."</td>";
	echo " 		<td><input type='number' style='width:40%;' min='1' max='".$row['stock']."' value=".$row['cantidad']." id='cant".$contador."' onblur='UpdateCantFacturaArrdo(this.value,".$row['idproduct'].",".$row['stock'].",".$contador.")'></td>";
	//echo " 		<td>".$row['cantidad']."</td>";
	echo " 		<td>".number_format($row['precio_prod'],0,',','.')."</td>";
	echo " 		<td><input type='text' style='width:25%;' value=".$row['descuento']." id='descuentofactura' onblur='UpdateDiscountFacturaArrdo(this.value,".$row['idproduct'].")'></td>";
	echo " 		<td><input type='date' style='width:70%;'  value=".$row['fecha_inicio']." id='fecha_inic_arrdo' onchange='ActualizaFechaInicio(this.value,".$row['idproduct'].")'></td>";
	echo " 		<td><input type='date' style='width:70%;' value=".$row['fecha_final']." id='fecha_fin_arrdo' onchange='ActualizaFechaFinal(this.value,".$row['idproduct'].")' ></td>";
	echo " 		<td>".number_format($row['dias'],0,',','.')."</td>";
	echo " 		<td>".number_format($row['subtotal'],0,',','.')."</td>";
	
		/*if ($row['enviado']!=0) { 
	          echo '<td><input type="checkbox" id="situacion" name="situacion" checked="checked" class="ibutton3" /></td>';
	          } else { 
			  echo         '<td><input type="checkbox" id="situacion" name="situacion" class="ibutton3" /></td>';
	     }*/
	

	echo " 		<td><input type='image' onclick='eliminafacturaArrdo(this.value)'  value=".$row['idproduct']." src='images/delete.png' height='20' width='20'></td>";
	echo "	</tr>";
}



?>
                                        
																		</tbody>
															</table>
														</div>
														</div>
                      
		<div class="content" style="padding-bottom:0;height:10px;margin-top:0;padding-top:0;">   </div>								
		<div class="content" style="padding-bottom:0;height:12%;margin-top:0;padding-top:0;">           
                 <div class="row-fluid">
                
                    <div class="span12">					
						<div class="span6" style="" >

                            <div class="box">

                                <div class="title">

                                    <h4>
                                        <span><img src="images/payment.png" width="30" height="30"></span>
                                        <span>Medio de Pago</span>
                                    </h4>
                                   
                                </div>
                                <div class="content" style="height:225px;">
                                   <div class="row-fluid">

                                       <div class="span10" style="margin-left:35px;" >
                           <table class="responsive table table-striped table-bordered table-condensed" >
                                <thead>
                                  
                                </thead>
                                <tbody>
                                 <tr>
                                     <td colspan="2">
													<select class="nostyle" name="medio_pago" id="medio_pago"  style="width: 80%;">
                                                                    
                                                      <?php
																$query = "SELECT * from condicion_pago where estado=0 order by id";
																$result = mysqli_query($con,$query);
																while ($row = mysqli_fetch_array($result))
																{
																	if ($pago==$row["id"]) {
																		echo "<OPTION value=".$row["id"]." selected>".$row["condicion"]."</OPTION>\n";
																	} else {
																		echo "<OPTION value=".$row["id"].">".$row["condicion"]."</OPTION>\n";
																	}
																}
																mysqli_free_result($result);
															?>
                                                     </select>
									</td>
								
									<td style="font-weight:bold;color:blue;">
									$<input type="text" id="efectivo" style="width:50%;" onkeyup="format(this);"></input></td>
									
                             
                                  </tr>
                                </tbody>
                            </table>
							
							<table class="responsive table table-striped table-bordered table-condensed" style="width: 70%;" id="DetCheques">
                                <thead>
                                  
                                </thead>
                                <tbody>
                                    <tr>
                                     <td colspan="2"><select class="nostyle" name="plazos" id="plazos"  style="width: 50%;">
                                                                    
                                                                  	<?php
																$query = "SELECT * from plazos order by id";
																$result = mysqli_query($con,$query);
																while ($row = mysqli_fetch_array($result))
																{
																	if ($pago==$row["id"]) {
																		echo "<OPTION value=".$row["id"]." selected>".$row["plazos"]."</OPTION>\n";
																	} else {
																		echo "<OPTION value=".$row["id"].">".$row["plazos"]."</OPTION>\n";
																	}
																}
																mysqli_free_result($result);
															?>
                                                                </select>
									</td>
                                     
                                  </tr>
                                  <tr>
                                        <td id="aldia" colspan="2">Al día Nº <input style="width:50px;" type="text" name="txtChequedia" id="txtChequedia" value="<?php echo $serieAlDia; ?>" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoAlDia" onkeyup="format(this);" id="txtMontoAlDia" value="<?php echo $montoAlDia; ?>" /></td>
                                     
                                  </tr>
								  <tr>
                                     <td id="30dias" colspan="2">A 30 dias Nº <input style="width:50px;" type="text" name="txtCheque30Dias" value="<?php echo $serie30 ?>" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA30" onkeyup="format(this);" id="txtMontoA30" value="<?php echo $monto30; ?>" /></td>
                                     
                                  </tr>
                                  <tr>
                                        <td id="60dias" colspan="2">A 60 dias Nº <input style="width:50px;" type="text" name="txtCheque60dias" value="" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA60" onkeyup="format(this);" id="txtMontoA60" value="" /></td>
                                     
                                  </tr>
                                   <tr>
                                        <td id="90dias" colspan="2">A 90 dias Nº <input style="width:50px;" type="text" name="txtCheque90dias" value="" />&nbsp; Monto $<input style="width:50px;" type="text" name="txtMontoA90" onkeyup="format(this);" id="txtMontoA90" value="" /></td>
                                     
                                  </tr>
                                </tbody>
                            </table>

                        </div><!-- End .span6 -->


                    </div><!-- End .row-fluid -->

                                </div>

                            </div><!-- End .box -->

                        </div><!-- End .span4 -->
                        
                      	<div class="span6" style="float:">

								<div class="box">

                                <div class="title">

                                    <h4>
                                        <span><img src="images/money_icon.png" width="30" height="30"></span>
                                        <span>Total Factura</span>
                                    </h4>
                                   
                                </div>
                                <div class="content">
                                   <div class="row-fluid">

                                       <div class="span10" style="margin-left:15%;" >
										   <table class="responsive table table-striped table-bordered table-condensed" style="width:80%;">
											<thead>
											  
											</thead>
											<tbody>
											<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">(%)Descuento</td>
												 <td><input type="text" style="width:30%;" id="desctotal" onblur=""></td>
											</tr>
											 <tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">Total Neto</td>
												 <td><div id="actualizaTotal" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($neto,0,",","."); ?></div></td>
											  </tr>
												<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">IVA</td>
												 <td><div id="iva" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($iva,0,",","."); ?></div></td>
											  </tr>
												<tr>
												 
												 <td colspan="2"  style="text-align:center;color: BLACK;font-family:arial;font-weight:bold;font-size:20px;">Total</td>
												 <td><div id="bruto" style="color: RED;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format($monto_total,0,",","."); ?></div></td>
												</tr>
												
											
												 <tr>
												 
												 <td colspan="2" style="text-align:center;color: black;font-family:arial;font-weight:bold;font-size:20px;">Vuelto</td>
												 <td><div id="vuelto" style="color: green;font-family:arial;font-weight:bold;font-size:20px;"><?php echo "$".number_format(0,0,",","."); ?></div></td>
												</tr>
											</tbody>
                            </table>
							
							

                        </div><!-- End .span6 -->
					<div class="row-fluid">
								
						<div class="span12">
							<label class="checkbox">
								<input style="display:none;" class="nostyle" type="checkbox" id="useDefaultPrinter" checked/>
								</label>
								<!--<div id="loadPrinters">
								
								<input type="button" onclick="javascript:jsWebClientPrint.getPrinters();" value="Load installed printers..." />
												
							
								</div>
								<div id="installedPrinters" style="visibility:hidden">
							
								<label for="installedPrinterName">Seleccionar una impresora Instalada:</label>
								<select name="installedPrinterName" id="installedPrinterName"></select>
								</div>-->
										
								
												
													
												<script type="text/javascript">
													var wcppGetPrintersDelay_ms = 5000; //5 sec

													function wcpGetPrintersOnSuccess(){
														// Display client installed printers
														if(arguments[0].length > 0){
															var p=arguments[0].split("|");
															var options = '';
															for (var i = 0; i < p.length; i++) {
																options += '<option>' + p[i] + '</option>';
															}
															$('#installedPrinters').css('visibility','visible');
															$('#installedPrinterName').html(options);
															$('#installedPrinterName').focus();
															$('#loadPrinters').hide();                                                        
														}else{
															alert("No printers are installed in your system.");
														}
													}

													function wcpGetPrintersOnFailure() {
														// Do something if printers cannot be got from the client
														alert("No printers are installed in your system.");
													}
												</script>
												
												<!-- Add Reference to jQuery at Google CDN -->


												<?php
												//Specify the ABSOLUTE URL to the php file that will create the ClientPrintJob object
												//In this case, this same page
												echo WebClientPrint::createScript('http://localhost/oxigeno/facturas.php');
												
												
												
												if($_SESSION['desRolUsuario']== "VENTAS")
												{
												?>
										<button class="btn btn-warning center" id="confirmsale2" style="padding:10px;border:1px solid black;width:30%;margin-left:15%;float:left;" onclick="validaConfirmSaveFacturaArrdo();"><span class=""></span>Guardar Factura</button>
										<?php
												}
												
												
										if($_SESSION['desRolUsuario']== "ADMINISTRADOR"){
										?>
													
	
										<button class="btn btn-success center" id="confirmsale1" style="padding:10px;border:1px solid black;width:30%;margin-left:15%;float:left;" onclick="validaConfirmaFacturaArrdo()"><span class=""></span>Confirmar Factura</button>                                 
										<?php
										}
										?>
							
							<button class="btn btn-danger center" id="confirmsale2" style="padding:10px;border:1px solid black;width:30%;margin-left:3%;float:left;" onclick="cancelar()"><span class=""></span>Cancelar</button>                                 
							<!--<button class="btn btn-warning center" id="confirmsale2" style="padding:10px;border:1px solid black;width:25%;margin-left:3%;float:left;" onclick="location.reload();"><span class=""></span>Guardar Factura</button>-->                                 
						</div>
					</div>
					<div class="row-fluid" style="margin-top:2%;">
								
									<div class="span12">
									<?php
									if($_SESSION['desRolUsuario']== "ADMINISTRADOR")
												{
												?>
						<!--<button class="btn btn center" id="confirmsale3" style="padding:10px;border:1px solid black;width:45%;margin-left:15%;float:left;" onclick="PrintFacturaDoc()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Electrónica</button>-->                                 
						<button class="btn btn center" id="imprimirfactf" disabled style="padding:10px;border:1px solid black;width:40%;margin-left:15%;float:left;"  onclick="guardar()"><span class="icon16 entypo-icon-printer"></span>Imprimir Factura Física</button>                                 
                        <?php
												}
						 ?>
					</div>
					</div>
							
                    </div><!-- End .row-fluid -->
                                </div>

                            </div><!-- End .box -->

								</div><!-- End .span4 -->                  
							</div>
					</div> 

                           

                        </div><!-- End .span12 -->
	    	
                    </div><!-- End .row-fluid -->

            </div><!-- End contentwrapper -->
			<input type="hidden" name="f_inicio" value="<?php echo $f_inicio;?>" />
			<input type="hidden" name="f_termino" value="<?php echo $f_termino;?>" />
			<input type="hidden" name="f_cliente" value="<?php echo $f_cliente;?>" />
			<input type="hidden" name="f_bodega" value="<?php echo $f_bodega;?>" />
    	<?php }
    	?>
        </div><!-- End #content -->
    </div><!-- End #wrapper -->
	<input type="hidden" name="oper" value="<?php echo $oper;?>" />
	<input type="hidden" name="id" value="<?php echo $id;?>" />
	<input type="hidden" name="status" value="0" />
	<input type="hidden" name="page" value="<?php echo $page;?>">
	<input type="hidden" name="orden" value="<?php echo $orden;?>">
	<input type="hidden" name="bodega_original" value="<?php echo $bodega_original;?>">
	<input type="hidden" name="max_file_size" value="300000">
	<input type="hidden" name="maximo" value="300000">
	<input type="hidden" name="lbl_maximo" value="[3MBytes]">
    </form>
	
<div id="popup10" style="display: none;">
									<div class="content-popup10">
										<div class="close10"><a href="#" id="close10"><img src="images/close.png"/></a></div>
										<h2>Buscar Productos</h2>  
									<br>
									 <div class="modal-body">
									 <div class="form-row row-fluid">
                                        <div class="span12">
                                            <div class="row-fluid">
												<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Bodega</label>
                                                <div class="span4 controls" style="height: 24px;">   
<!--                                                    <select name="bodega1" id="bodega1" style="width: 200px; min-width: 200px;">-->
                                                    <select class="nostyle"  name="bodega1" id="bodega1" style="" onchange="if(this.value!=0){LoadProductSale(this.value)};">
													
														<?php
															$query = "SELECT * from bodegas where id = ".$_SESSION['bodegaidsale']." order by id";
															$result = mysqli_query($con,$query);
															while ($row = mysqli_fetch_array($result))
															{													
																	echo "<OPTION value=".$row["id"]." selected>".$row["descripcion"]."</OPTION>\n";																
															}
															mysqli_free_result($result);
														?>
                                                    </select>
                                                </div>
												<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Categoria</label>
                                                <div class="span4 controls" style="height: 24px;">   
<!--                                                    <select name="bodega1" id="bodega1" style="width: 200px; min-width: 200px;">-->
                                                    <select class="nostyle"  name="categoria_f" id="categoria_f" style="" onchange="showProductCateg(this.value)">
														<option value="0">Seleccione Categoria</option>
														<?php
															$query = "SELECT * from categorias order by descripcion";
															$result = mysqli_query($con,$query);
															while ($row = mysqli_fetch_array($result))
															{													
																	echo "<OPTION value=".$row["id"].">".$row["descripcion"]."</OPTION>\n";																
															}
															mysqli_free_result($result);
														?>
                                                    </select>
                                                </div>
												<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Marca</label>
                                                <div class="span4 controls" style="height: 24px;">   
<!--                                                    <select name="bodega1" id="bodega1" style="width: 200px; min-width: 200px;">-->
                                                    <select class="nostyle"  name="marca_f" id="marca_f" style="" onchange="showProductMarca(this.value)">
													<option value="0">Seleccione Categoria</option>
														<?php
															$query = "SELECT * from marcas order by descripcion";
															$result = mysqli_query($con,$query);
															while ($row = mysqli_fetch_array($result))
															{													
																	echo "<OPTION value=".$row["id"].">".$row["descripcion"]."</OPTION>\n";																
															}
															mysqli_free_result($result);
														?>
                                                    </select>
                                                </div>
												
												<label class="form-label span2" for="checkboxes" style="font-weight:bold;">Buscar</label>
                                                <div class="span4 controls" style="height: 24px;">   
													<input type="text" placeholder="Filtro General" onkeyup="showProductSale(this.value);" >
                                                </div> 
                                               
                                            </div>
                                        </div> 
                                    </div>
									 
									 
									 
										<div class="row-fluid" >

											<div class="span12" >
	                               
                                    <table id="datatable1" class="table table-striped table-bordered" width="100%">
                                          <thead>
																		<tr>
                                                                          <th style="text-align: center; width: ">#</th>
                                                                          <th style="text-align: left;">&nbsp;Nombre&nbsp;&nbsp;&nbsp;</th>
                                                                          <th style="text-align: left;">&nbsp;Codigo Barra&nbsp;&nbsp;&nbsp;</th>
                                                                          <th style="text-align: left;">&nbsp;Categoria&nbsp;&nbsp;&nbsp;</th>
                                                                          <th style="text-align: left; width: ">&nbsp;Stock Total&nbsp;&nbsp;&nbsp;</th>
                                                                          <th style="text-align: left;">&nbsp;Bodega&nbsp;&nbsp;&nbsp;</th>
                                                                          <th style="text-align: center;">Precio Venta</th>
                                                                          <th style="text-align: left;">&nbsp;Cantidad&nbsp;&nbsp;&nbsp;</th>
                                                                          <th >Acciones</th>

                                                                        </tr>
										 </thead>
										<tbody id="productsales">
										<div>
                                        <?php
								
                                                                         $query = "SELECT A.*, C.descripcion AS 'DES_CATEGORIA', D.descripcion AS 'DES_MARCA', s.stock AS stock, b.id AS id_bodega, b.descripcion AS bodega  FROM productos A LEFT JOIN categorias C ON A.categoria_id=C.ID LEFT JOIN marcas D ON A.marca_id=D.ID LEFT JOIN stock s ON A.id=s.producto_id LEFT JOIN bodegas b ON s.bodega_id=b.id where s.bodega_id = ".$_SESSION['bodegaidsale']." and a.tipo_producto=1 GROUP BY A.id";
										
																	$result = mysqli_query($con,$query);
																	while ($row = mysqli_fetch_array($result))
																	{  
																		$contador=$contador+1;
																		?>
																		 <tr>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: center;"><?php echo $contador;?></td>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;">&nbsp;<?php echo $row["especificaciones"];?></td>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;">&nbsp;<?php echo $row["codigo_externo"];?></td>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;">&nbsp;<?php echo $row["DES_CATEGORIA"];?></td>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;"><div id="muestrastock"><?php echo $row["stock"];?></div></td>      
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;">&nbsp;<?php echo $row["bodega"];?></td>
                                                                                <td style="text-align: right;"><?php echo number_format($row["psale_arrdo"],0,",",".");?>&nbsp;</td>
                                                                                <td class="tipB" title="<?php echo $row["especificaciones"];?>" style="text-align: left;">
																					<input type="number" value='1' min='1' id="cant<?php echo $contador;?>" name="cant1" style="width:30px;" />
																				</td> 
                                                                                <td>
                                                                                    <div class="controls center">
																						<button id="muestratodos"  value="<?php echo $row["codigo_externo"];?>"  onclick="registraProdFacturaArrdo(this.value,<?php echo $contador;?>,<?php echo $row['stock'];?>)" >Agregar</button>
                                                                                    </div>
                                                                                </td>
                                                    
                                                                            
                                                                         </tr>
																		<?php      
																		}
																		mysqli_free_result($result);
																		?>
																		
																		</tbody>
								
																	</table>
																</div>																						
														</div>										
												</div>	
											</div>
										</div>	
									</div>	
			
			
								<div id="popup2" style="display: none;">
									<div class="content-popup2">
										<div class="close2"><a href="#" id="close2"><img src="images/close.png"/></a></div>
										<h2>Buscar Cliente</h2>  
									<br>
									 <div class="modal-body">
										<div class="row-fluid" >

											<div class="span12" >
	                               
                                    <table id="datatable" class="table table-striped table-bordered" width="100%">
                                          <thead>
                                          <tr>
												<th  width="">#</th>
												<th  width="">Rut</th>
												<th  width="">Nombre</th>
												<th width="">Direccion</th>
												<th width="">G.Comercial</th>
												<th width="">Telefono</th>
												<th height="">Correo</th>                 
												<th width="">Acciones</th>
                                          </tr>
                                        </thead>
                                        <tbody>
                                        <?php
							
										$query="select id,rut,razon_social,direccion,giro_comercial,telefonos,email from clientes";										
										$result = mysqli_query($con,$query);
										while ($row = mysqli_fetch_array($result))
										{  
                         
											?>
	                                          <tr>
	                                          
	                                            <td style="text-align: left;"><?php echo $row["id"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["rut"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["razon_social"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["direccion"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["giro_comercial"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["telefonos"];?></td>
	                                            <td style="text-align: left;"><?php echo $row["email"];?></td>
	                       
	                       	         			<td>
	                                                <div class="controls center">
														<button href="#" title="Editar Conductor" class="btn btn-success" id="busq_cl" value="<?php echo $row['rut'];?>" onClick="cargaDatosClientePopUp(this.value)">Seleccionar</button>
	                                                  
	                                                </div>
	                                            </td>
												 
	                                          </tr>
	                                    <?php      
										}
										mysqli_free_result($result);
										?>
                                        </tbody>
<!--                                        <tfoot>
                                            <tr>
                                                    <th></th>
                                                    <th style="text-align: center;" ></th>
                                                    <th></th>
                                                    <th></th>
                                                    <th></th>
                                                    <th></th>
                                            </tr>
                                    </tfoot>-->
                                    </table>
                                </div>
													
																						
													</div>										
											</div>	
										</div>
									</div>
								<script type="text/javascript">
									$('#datatable').dataTable( {
									 "sPaginationType": "full_numbers"
									 
								   } ).columnFilter({ 	 /* sPlaceHolder:"head:after", */
										aoColumns: [ 	null,
																{ type: "date-range" },
																null,
																null,
																null,
																null
															   
													
																	
											]

									}); 
		

								</script>









			
			
			
	
	
    </body>
</html>
<?php } ?>