<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image('../'.$GLOBALS['logo_empresa'],10,5,33,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
	
	$this->SetFont('Arial','B',9);
$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);
$this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->SetX(37);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode(strtoupper($GLOBALS['señor'])),0,0,'c');
$this->SetX(140);
$this->Ln(5);
$this->SetX(37);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode($GLOBALS['rut_empresa']),0,0,'c');
$this->SetFont('Arial','B',9);
$this->SetX(145);

$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,'ORDEN DE COMPRA',0,0,'c');
$this->SetFont('Arial','',9);
$this->Ln(5);
$this->SetX(37);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode(strtoupper($GLOBALS['direccion_empresa'])),0,0,'c');
$this->SetX(130);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','B',9);
$this->Cell(80,7,utf8_decode("N°  ").right("00000".trim($GLOBALS['nroBoleta']),10)."",0,1,'C');
$this->SetFont('Arial','',9);
$this->Ln(5);
$this->SetXY(37,25);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode(strtoupper($GLOBALS['comuna_empresa'])),0,0,'c');
$this->SetX(145);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);
$this->Cell(80,7,'Fecha Orden:'.$GLOBALS['fechaBoleta'],0,0,'c');
$this->SetFont('Arial','',9);
$this->Ln(5);
$this->SetX(37);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode(strtoupper($GLOBALS['giro_empresa'])),0,0,'c');
$this->SetX(150);
$this->Cell(20,7,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->SetFont('Arial','',8);
$this->Cell(80,7,'CLP Pesos Chilenos',0,0,'c');






$this->Ln(20);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Nombre/Razón Social:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['rsocialcliente']),'',0,'c');
$this->SetX(125);
$this->SetTextColor(0, 0, 0);
$this->Cell(15,8,utf8_decode('Contacto:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['contactoCliente']),'',0,'c');

$this->Ln(6);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('R.U.T:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['rutCliente']),'',0,'c');
$this->SetX(125);
$this->SetTextColor(0, 0, 0);
$this->Cell(15,8,utf8_decode('Teléfono:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fonocliente']),'',0,'c');

$this->Ln(6);
$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(30,8,utf8_decode('Giro Comercial:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['girocliente']),'',0,'c');
/*$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Fax:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fonocliente']),'',0,'c');*/

$this->Rect(10,50,190,20);
$this->SetX(125);
//$this->Ln(6);

$this->SetFont('Arial','',7);
$this->SetTextColor(0, 0, 0);
$this->Cell(15,8,utf8_decode('Dirección:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['direccioncliente']),'',0,'c');
/*
$this->SetX(140);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('País:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['fonocliente']),'',0,'c');*/

$this->Ln(15);


}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
    
    // Arial italic 8
	$this->SetY(-50);
    $this->SetFont('Arial','B',8);
    // Page number
	$this->SetX(10);

	$this->Cell(70,6,utf8_decode(''),0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'SUBTOTAL','B',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'B',0,'R');
	$this->SetFont('Arial','B',8);

	$this->Ln(6);
	
	$this->SetX(12);
	$this->Cell(25,6,'OBSERVACIONES:','B',0,'L');
	
	$this->SetX(40);
	$this->SetFont('Arial','',8);
	$this->Cell(70,6,$GLOBALS['observacion'],0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'DESCUENTO','T',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,'','T',0,'R');
	$this->Ln(6);
	$this->Cell(15,6,'',0,0,'1');
	$this->Cell(70,6,'',0,0,'1');
	/*$this->SetX(140);
	$this->Cell(30,6,'PRECIO NETO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['tneto'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(15,6,'',0,0,'1');
	$this->Cell(70,6,'',0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'IVA','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['tiva'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'',0,0,'1');
	$this->Cell(70,6,'',0,0,'1');*/
	$this->SetX(140);
	$this->Cell(30,6,'TOTAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['ttotal'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Rect(10,245,190,35);
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>