<?php
require('../fpdf/fpdf.php');
require_once("../include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        //$this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	//$this->Image('../'.$GLOBALS['logo_empresa'],10,5,33,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    //$this->Ln(10);
$this->SetFont('Arial','B',9);
//$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);
$this->SetFont('Arial','B',8);
$this->SetTextColor(0, 0, 0);
$this->Ln(0);
$this->SetFont('Arial','B',8);
$this->SetTextColor(0, 0, 0);
//$this->SetX(25);

$this->Cell(190,5,utf8_decode('ASISTENCIA TECNICA  -  RYUTECH'),0,0,'C');
$this->SetX(155);
$this->SetFont('Arial','B',14);
$this->Cell(45,6,utf8_decode('N° '.$GLOBALS['nroBoleta']),0,0,'C');
//$this->SetTextColor(0, 0, 0);
//$this->SetXY(59,278);
$this->Ln(0);
//$this->SetX(25);
//$this->Cell(20,5,utf8_decode(''),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Ln(1);
$this->SetFont('Arial','B',7);
$this->MultiCell(28,3,utf8_decode('1. Solicitud de cobro.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('A. Si Recibido el equipo este se desarma y se revisa para determinar la efectividad  y /o magnitud de la falla  que indica el cliente.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('B. Si el cliente solicita presupuesto, se le comunicara a este telefónicamente y por escrito la falla que presenta. Si el presupuesto no es aceptado, 
se procederá a un cobro mínimo por revisión,  cuyo valor cubre (todos) los gastos estipulados en el (inciso) número 1.1 anterior. Para todo efecto, el presupuesto de reparación tiene una validez de 5 días.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('C. Toda atención sujeta a cobro debe ser cancelada en forma inmediata, esto se puede realizar en: efectivo, tarjeta de crédito, tarjeta de débito o transferencia bancaria.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('D. La factura, boleta, o guía de despacho del servicio, será emitida (en el instante) cuando se retire el equipo.'),0,'L',false);


$this->Ln(0);
$this->SetFont('Arial','B',7);
$this->MultiCell(43,3,utf8_decode('2. Políticas de Garantía RYUTECH.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('A. La reparación será sin costo para el cliente en el evento en que la falla corresponda a un defecto cuyo origen este cubierto por la garantía. La reparación será cobrada si la falla o desperfecto que presente el equipo fuere de responsabilidad del cliente, como por ejemplo la intervención o manipulación del mismo, golpes, abolladuras, derramamiento de líquido, problemas de softwares, etc.'),0,'L',false);
$this->MultiCell(190,3,utf8_decode('B. Todos los trabajos realizados por RYUTECH cuentan con de 3 meses de Garantía; excepto las reparaciones de placa que cuentan con un de 1 Mes de la misma.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('C. La empresa solo responderá por servicios, partes y piezas adquiridas en el local con su boleta o factura correspondiente, documento que el cliente deberá presentar al momento de hacer valida su garantía.'),0,'L',false);

$this->MultiCell(190,3,utf8_decode('D. La Garantía solo se atribuirá a la reparación realizada o al insumo vendido, excluyendo cualquier otro defecto posterior al retiro del equipo, por eso es obligación del cliente revisar el mismo al momento de la entrega no habiendo objeción posterior.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('E. El equipo, cuando corresponda, será Evaluado por RYUTECH en un plazo de 24 hs para efectos de verificar si aplica cobertura de la garantía. '),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('F. Los productos y/o servicios recepcionados como garantía tienen un plazo de 1 semana para reparados.'),0,'L',false);
$this->SetTextColor(0, 0, 0);
$this->Ln(0);
$this->SetFont('Arial','B',7);
$this->MultiCell(36,3,utf8_decode('3. Exclusiones de Garantía.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('A. En el caso de equipos recepcionados con humedad y/o que fueron sumergidos completa o parcialmente en algún tipo de liquido y son dejados para su limpieza y baño químico, la empresa no se hace responsable por ningún tipo de fallas en partes, piezas o software que pudiesen ocurrir al momento de su reparación y posterior a esta. Esto debido a que el comportamiento del equipo que se encuentra en estas condiciones es totalmente impredecible.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('B. Si el sello de Garantía en el equipo se ve adulterado, quebrantado o violado automáticamente pierde la garantía y cualquier responsabilidad de la empresa con el cliente y/o equipo.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('C. Modificación del software original del producto.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('D. Uso Impropio, excesos o caídas de voltaje eléctrico que impliquen uso en condiciones anormales.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('E. Intervención del equipo por personal no autorizado de RYUTECH.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('F. Daños causados por golpes, caídas, transporte y bodegaje inadecuado o trato incorrecto, como también los daños a causa de temblor, terremoto, maremoto, inundaciones, anegaciones, relámpagos, humedad, ambientes de polvo excesivos, trizaduras, exposición excesiva al sol etc.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('G. Los productos usados o refaccionados (REPARACIONES DE PANTALLAS O CAMBIO DE GLASS.)'),0,'L',false);

$this->Ln(0);
$this->SetFont('Arial','B',7);
$this->MultiCell(29,3,utf8_decode('4. Responsabilidades.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('A. La empresa solo se hace responsable por la reparación o servicio detallado, pudiendo agregar nuevos ítem y/o variar el costo del servicio previa notificación y aceptación al cliente. '),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('B. La empresa no se hace responsable por accesorios dejados por los clientes, ya sean: carcasas, fundas, laminas protectoras, tarjeta sim, tarjeta de memoria, cables de datos, manos libre, cajas, bolsas o cualquier otro accesorio que el cliente deje en conjunto con el o los equipos.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('C. El cliente libera a la Empresa toda responsabilidad de cualquier falla no descrita por el cliente o no identificada al momento de la recepción por el personal. El acepta entender el termino desgaste de material, referente al desgaste normal (por tiempo y uso) de partes y piezas en los equipos, pudiéndonos encontrar con estas en mal estado.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('D. El cliente libera de toda responsabilidad a la empresa de reparaciones realizadas con anterioridad por terceras personas, debido a la mala calidad de trabajos que han realizado con anterioridad.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('E. El cliente libera de toda responsabilidad a la empresa de cualquier tipo de falla, en equipos que son recepcionados sin encender o no se encuentren operativos, ya sea porque están sin carga, porque tiene algún problema de software, porque no funciona el táctil y/o pantalla.'),0,'L',false);

$this->MultiCell(190,3,utf8_decode('F. Es obligación del cliente "Respaldar Toda La Información" que estime conveniente, liberando a la empresa de toda responsabilidad en la perdida de datos. La empresa no presta servicio para respaldo de Datos.'),0,'L',false);

$this->MultiCell(190,3,utf8_decode('G. En el momento de Retiro del Equipo en Tienda es responsabilidad del Cliente pedir las Partes y/o Piezas sustituidas por Ryutech , caso contrario se otorga a Ryutech el derecho de deshacerse de las mismas'),0,'L',false);
$this->MultiCell(190,3,utf8_decode('H. El equipo será entregado al portador de la copia de Asistencia Tecnica o a la persona que especialmente el cliente designe. El cliente libera a la empresa de toda responsabilidad por este concepto.'),0,'L',false);
$this->MultiCell(190,3,utf8_decode('I. Al momento de retirar el equipo el cliente deberá firmar un recibo que acredite la recepción de este a su entera satisfacción con la falla debidamente reparada'),0,'L',false);
$this->MultiCell(190,3,utf8_decode('J. Queda convenido y expresamente aceptado por el cliente que la empresa no responderá por la mercadería objeto de este contrato, en los casos de daño o perdida  por causas fortuitas o de causa mayor no imputable a la empresa.'),0,'L',false);

$this->Ln(0);
$this->SetFont('Arial','B',7);
$this->MultiCell(18,3,utf8_decode('5. Bodegaje.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('A. Se entenderán abandonadas en favor del proveedor las especies que le sean entregadas en reparación, cuando no sean retiradas en el plazo de un año contado desde la fecha en que se haya otorgado y suscrito el correspondiente documento de recepción del trabajo (según ley número 19.496 art.42).'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('B. Una vez efectuada la reparación o el rechazo de esta por el cliente, este deberá retirar su equipo en un plazo no superior a 15 días hábiles contados desde la fecha de compromiso de entrega. Transcurrido el plazo de 15 días hábiles antes indicado, Ryutech  estará facultada para cobrar al cliente la suma de 350 (trescientos cincuenta) por cada día de retraso por concepto de bodegaje, cantidad que deberá ser pagada en su totalidad al momento del retiro de su equipo.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('C. Transcurridos 60 días corridos desde la reparación efectuada, Ryutech no se responsabiliza por el deterioro que pueda sufrir el equipo por estar almacenado.'),0,'L',false);
//$this->Ln(3.5);
$this->MultiCell(190,3,utf8_decode('D. No se realizara devolución del dinero por deseo propio o arrepentimiento de la compra, la empresa no otorga garantía voluntaria de retracto'),0,'L',false);


$this->Ln(0);
$this->SetFont('Arial','B',7);
$this->MultiCell(34,3,utf8_decode('6. Cliente Fuera de Plaza.'),'B','L',false);
$this->SetFont('Arial','',5.9);
$this->MultiCell(190,3,utf8_decode('La empresa no se hace responsable por las averías, pérdidas, daños, robos o hurtos, que puedan producirse en el transcurso del viaje, desde las oficinas de la empresa hasta el domicilio del cliente.'),0,'L',false);


$this->Ln(2);
$this->SetFont('Arial','B',7);
$this->Cell(35,3,utf8_decode('A - PRESUPUESTO'),0,0,'L');

//$check = "4";
$this->SetFont('ZapfDingbats','', 10);
//$encabezado3[$i] = $check;
if($GLOBALS['estado_orden']==1){
	$this->Cell(5, 3, "4", 1, 0, 'C');
}else{
	$this->Cell(5, 3, "", 1, 0, 'C');
}
$this->Ln(4);
$this->SetFont('Arial','B',7);
$this->Cell(35,3,utf8_decode('B - REVISION GARANTIA'),0,0,'L');
$this->SetFont('ZapfDingbats','', 10);

if($GLOBALS['estado_orden']==2){
	$this->Cell(5, 3, "4", 1, 0, 'C');
}else{
	$this->Cell(5, 3, "", 1, 0, 'C');
}

$this->SetFont('Arial','B',7);
$this->SetX(55);
$this->Cell(25,3,utf8_decode('CUBRE GARANTIA'),0,0,'L');
$this->Cell(5,3,utf8_decode('SI'),0,0,'C');
$this->SetFont('ZapfDingbats','', 10);

if($GLOBALS['garantia']==0){
	$this->Cell(5, 3, "", 1, 0, 'C');
}else{
	$this->Cell(5, 3, "4", 1, 0, 'C');
}
$this->SetFont('Arial','B',7);
$this->Cell(5,3,utf8_decode('NO'),0,0,'C');
$this->SetFont('ZapfDingbats','', 10);
if($GLOBALS['garantia']==0){
	$this->Cell(5, 3, "4", 1, 0, 'C');
}else{
	$this->Cell(5, 3, "", 1, 0, 'C');
}
$this->SetFont('Arial','B',7);
$this->SetX(120);
$this->Cell(35,3,utf8_decode('RECEPCIONADO POR: '),0,0,'L');
$this->SetFont('Arial','',7);
$this->Cell(45,3,utf8_decode($GLOBALS['tecnico']),'B',0,'L');
$this->Ln(4);
$this->SetFont('Arial','B',7);
$this->Cell(35,3,utf8_decode('C - COMPRA DE EQUIPO'),0,0,'L');
$this->SetFont('ZapfDingbats','', 10);
if($GLOBALS['estado_orden']==3){
	$this->Cell(5, 3, "4", 1, 0, 'C');
}else{
	$this->Cell(5, 3, "", 1, 0, 'C');
}

$this->Ln(5);
$this->SetFont('Arial','B',9);
$this->Cell(12,4,utf8_decode('Marca:'),0,0,'L');
$this->SetFont('Arial','',9);
$this->Cell(34,4,utf8_decode($GLOBALS['marca']),'B',0,'L');
$this->SetFont('Arial','B',9);
$this->Cell(14,4,utf8_decode('Modelo:'),0,0,'L');
$this->SetFont('Arial','',9);
$this->Cell(34,4,utf8_decode($GLOBALS['modelo']),'B',0,'L');
$this->SetFont('Arial','B',9);
$this->Cell(12,4,utf8_decode('Color:'),0,0,'L');
$this->SetFont('Arial','',9);
$this->Cell(34,4,utf8_decode(''),'B',0,'L');
$this->SetFont('Arial','B',9);
$this->Cell(12,4,utf8_decode('IMEI:'),0,0,'L');
$this->SetFont('Arial','',9);
$this->Cell(38,4,utf8_decode($GLOBALS['imei']),'B',0,'L');
if($GLOBALS['con_documento'] == 0){
$this->Ln(6);
$this->SetFont('Arial','B',8);
$this->MultiCell(50,4,utf8_decode('7 - Check List (Ingreso del Equipo).'),'B','L',false);
$this->Ln(2);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['network'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Red'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['volumedown'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Vomulen'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['touchscreen'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Pantalla Touch'),0,0,'L');

$this->SetX(130);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['videomic'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Mic Video'),0,0,'L');

$this->SetX(170);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['loadbattery'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Ciclos de Batería'),0,0,'L');
$this->Ln(4);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['bluetooth'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Bluetooth'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['ringsilent'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Switch Volumen'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['lcdpixels'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('LCD pixels'),0,0,'L');

$this->SetX(130);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['frontcamera'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Cámara Frontal'),0,0,'L');

$this->Ln(4);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['geolocation'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Geolocalización'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['homebtn'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Botón de Inicio'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['vibro'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Vibración'),0,0,'L');

$this->SetX(130);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['backcamera'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Cámara Trasera'),0,0,'L');

$this->Ln(4);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['accelerometer'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Acelerómetro'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['powerbtn'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Botón de Encendido'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['speaker'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Parlante'),0,0,'L');

$this->SetX(130);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['flash'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Flash'),0,0,'L');

$this->Ln(4);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['proxmity'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Sensor de Proximidad'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['touchid'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Touchid'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['loudspeaker'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Auricular'),0,0,'L');

$this->SetX(130);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['autofocus'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Autofocus'),0,0,'L');

$this->Ln(4);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['volumeup'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Volumen +'),0,0,'L');
$this->SetX(50);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['multitouch'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Multitouch'),0,0,'L');
$this->SetX(90);
$this->SetFont('ZapfDingbats','', 10);
$this->Cell(5, 3, $GLOBALS['headspeaker'], 1, 0, 'C');
$this->SetFont('Arial','',8);
$this->Cell(25,3,utf8_decode('Mic Principal'),0,0,'L');
}else{
	$this->Ln(32);
}


//$this->Rect(120,229,80,27);
//$this->SetXY(80,80);
//$this->Cell(60, 10, '', 1, 0, 'C');

//$this->Ln(15);
//$this->SetXY(0,80);
$this->Ln(5);

}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
	$this->SetY(-60);
    $this->SetFont('Arial','B',8);
    // Page number
	$this->SetXY(120,230);

	$this->Cell(70,6,'EL SINTOMA INDICADO POR EL CLIENTE ES:',0,0,'1');
	 $this->SetFont('Arial','',8);
	$this->Ln(6);
	$this->SetXY(120,235);
	$this->MultiCell(80,4,utf8_decode($GLOBALS['observaciones_falla']),0,'L',false);
	$this->SetFont('Arial','',10);
	$this->Ln(6);
	$this->SetXY(120,260);
	$this->Cell(20,4,'Fecha:',0,0,'1');
	$this->Cell(60,4,$GLOBALS['fechaBoleta'],'B',0,'1');
	$this->Ln(6);
	$this->SetXY(120,265);
	$this->Cell(20,4,'Nombre:',0,0,'1');
	$this->Cell(60,4,$GLOBALS['nombreCliente'],'B',0,'1');
	$this->Ln(6);
	$this->SetXY(120,270);
	$this->Cell(20,4,utf8_decode('Rut/N°PAS:'),0,0,'1');
	if($GLOBALS['nro_pasaporte']!=""){		
		$this->Cell(60,4,$GLOBALS['nro_pasaporte'],'B',0,'1');
	}else{
		$this->Cell(60,4,$GLOBALS['rutCliente'],'B',0,'1');
	}
	$this->Ln(6);
	$this->SetXY(120,275);
	$this->Cell(20,4,'Firma:',0,0,'1');
	$this->Cell(60,4,'','B',0,'1');
	
	$this->SetFont('Arial','B',10);
	$this->Ln(6);
	$this->SetXY(59,278);
	$this->Cell(36,6,'PRECIO TOTAL:',0,0,'1');
	$this->Cell(22,6,number_format($GLOBALS['montot'], 0, ",", "."),1,0,'C');
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	//$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetXY(170,203);
	$this->SetFont('Arial','',8);
	if($GLOBALS['ciclos_bateria']>0){
		$this->Cell(36,6,$GLOBALS['ciclos_bateria'].' ciclos',0,0,'1');
	}
	$this->SetFont('Arial','B',8);
	$this->Rect(170,204,30,7);
	$this->Rect(155,10,45,7);
	
	$this->Rect(120,229,80,27);
	$this->Image('../'.$GLOBALS['logo_empresa'],10,275,30,25);
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>