<?php
#
class FacTronicaLoginSii{
	###############################
	# METODO OBTENER SEMILLA
	###############################
	public function ObtenerSemilla(){
		#
		global  $FACTRONICA;
		#  
		if($FACTRONICA["PRODUCCION"]=="1"){
			$serverURL = 'https://palena.sii.cl/DTEWS/';   
		}else{
			$serverURL = 'https://maullin.sii.cl/DTEWS/';     
		}
		#  
		$serverScript = "CrSeed.jws";  
		#  
		$metodoALlamar = 'getSeed';  
		//  
		$cliente = new nusoap_client("$serverURL/$serverScript?wsdl", 'wsdl');
		//  
		$error = $cliente->getError();
		if ($error) {
			$FACTRONICA["SEMILLA"]="ERROR";
			return;
		}
		#
		$result = $cliente->call(
		 "$metodoALlamar", 
		 array('parametro' => ''),  
		 "uri:$serverURL/$serverScript", 
		 "uri:$serverURL/$serverScript/$metodoALlamar"  
		);
		//  
		if ($cliente->fault) {
			$FACTRONICA["SEMILLA"]="ERROR";
			return;	
		# 
		} else {
			$error = $cliente->getError();
			if ($error) {
				$FACTRONICA["SEMILLA"]="ERROR";
				return;
			} else {
				#
				$FACTRONICA["SEMILLA"]=$result;	
			}
		}
		# OBTENER SOLAMENTE EL VALOR DE LA SEMILLA
		$i=0;  
		$dom = new DOMDocument;
		$dom->loadXML($result);
		$elementos=$dom->getElementsByTagName('SEMILLA');
		foreach ($elementos as $elemento) {
			$x[$i]=$elemento->nodeValue;
			$FACTRONICA["SEMILLA"]=$x[$i];
			$i++;
		}
	} 
	###############################
	# METODO OBTENER TOKEN
	###############################
	public function ObtenerToken(){
		global $FACTRONICA;
		###############################
		# FIRMAR SEMILLA
		###############################
		$file_out='<getToken><item><Semilla>'.$FACTRONICA["SEMILLA"].'</Semilla></item></getToken>';
		#
		$ar=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["SEMILLAPORFIRMAR"],"w") or die("ERROR xx");
		fputs($ar,$file_out);
		fclose($ar);
		# Calcular la digestion del archivo
		$digesta=ObtenerDigestion($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["SEMILLAPORFIRMAR"]);
		# plantilla 
		$firmador='<SignedInfo xmlns="http://www.w3.org/2000/09/xmldsig#"><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"></CanonicalizationMethod><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"></SignatureMethod><Reference URI=""><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"></Transform></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"></DigestMethod><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo>';
		# guardar la plantilla signature con la digesta del documento
		$archivo=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["DIGESTADOR"],"w") or die("ERROR");
		fputs($archivo,$firmador);
		fclose($archivo);
		# calcular la $firma binaria
		openssl_sign($firmador, $firma_bin, $FACTRONICA["PrivKey"], OPENSSL_ALGO_SHA1);
		# convertir la $firma binaria a base64
		$SignatureValueDocumento=base64_encode($firma_bin);
		# armar el signature con la digesta y con 
		$signature_docto='<Signature xmlns="http://www.w3.org/2000/09/xmldsig#"><SignedInfo><CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/><SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/><Reference URI=""><Transforms><Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/></Transforms><DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/><DigestValue>'.$digesta.'</DigestValue></Reference></SignedInfo><SignatureValue>'.$SignatureValueDocumento.'</SignatureValue><KeyInfo><KeyValue><RSAKeyValue><Modulus>'.$FACTRONICA["Modulus"].'</Modulus><Exponent>'.$FACTRONICA["Exponent"].'</Exponent></RSAKeyValue></KeyValue><X509Data><X509Certificate>'.$FACTRONICA["X509Certificate"].'</X509Certificate></X509Data></KeyInfo></Signature>';
		# DOCUMENTO FIRMADO
		$semilla_firmada='<?xml version="1.0" encoding="ISO-8859-1"?><getToken><item><Semilla>'.$FACTRONICA["SEMILLA"].'</Semilla></item>'.$signature_docto.'</getToken>';
		# guardar el elemento set para calcular su digesta
		$archivo=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["SEMILLAFIRMADA"],"w") or die("ERROR");
		fputs($archivo,$semilla_firmada);
		fclose($archivo);

		########################################
		# ENVIAR SEMILLA Y OBTENER TOKEN
		########################################
		if($FACTRONICA["PRODUCCION"]=="1"){
			$serverURL = 'https://palena.sii.cl/DTEWS/';    
		}else{
			$serverURL = 'https://maullin.sii.cl/DTEWS/';    
		}
		# NOMBRE DEL SCRIPT
		$serverScript = "GetTokenFromSeed.jws";
		# METODO A LLAMAR
		$metodoALlamar = 'getToken'; 
		# Crear un cliente de NuSOAP para el WebService
		$cliente = new nusoap_client("$serverURL/$serverScript?wsdl", 'wsdl');
		# Se pudo conectar?
		$error = $cliente->getError();
		#
		if ($error) {
			$FACTRONICA["TOKEN"]="ERROR DE CONEXION ";
			return;		
		}
		# ARCHIVO XML A ENVIAR
		$archivo_xml = file_get_contents($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["SEMILLAFIRMADA"]);
		#  EJECUTAR LA LLAMADA A LA URL DEL SII ENVIANDO EL XML CON LA SEMILLA FIRMADA
		$result = $cliente->call(
		 "$metodoALlamar", // Funcion a llamar
		 array($archivo_xml), // Parametros pasados a la funcion
		 "uri:$serverURL/$serverScript", // namespace
		 "uri:$serverURL/$serverScript/$metodoALlamar" // SOAPAction
		);
		if ($cliente->fault) {
			$FACTRONICA["TOKEN"]="ERROR";
			return;		
		} else {
			#
			$error = $cliente->getError();
			#
			if ($error) {
				$FACTRONICA["TOKEN"]="ERROR";
				return;
			} 
		}
		#	 
		$ar=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["XSDTOKEN"],"w") or die("ERRORTOKEN4");
		fputs($ar,$result);
		fclose($ar);
		#
		$i=0;	  
		$dom = new DOMDocument;
		$xml=file_get_contents($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["XSDTOKEN"]);
		$dom->loadXML($xml);
		$elementos=$dom->getElementsByTagName('TOKEN');
		foreach ($elementos as $elemento) {
			$xtoken[$i]=$elemento->nodeValue; 
			$FACTRONICA["TOKEN"]=$xtoken[$i];
			$i++;
		} 
	}
	##################################################
	# METODO CONSULTAR FECHA RECEPCION DTE EN EL SII #
	##################################################
	#
	public function consultarFechaRecepcionSii(){
		#
		global $FACTRONICA;
		#
		/*
		$FACTRONICA["rutEmisor"]="10377898";
		$FACTRONICA["dvEmisor"]="0";
		$FACTRONICA["tipoDoc"]="33";
		$FACTRONICA["folio"]="3093";
		*/
		# URL DEL SERVIDOR
		if($FACTRONICA["PRODUCCION"]=="1"){
			$serverURL = 'https://ws1.sii.cl/WSREGISTRORECLAMODTE';   
		}else{
			$serverURL = 'https://ws2.sii.cl/WSREGISTRORECLAMODTECERT'; 
		}
		# 
		$serverScript = "registroreclamodteservice";  
		# METODO A LLAMAR
		$metodoALlamar = 'consultarFechaRecepcionSii';  
  		$cliente = new nusoap_client("$serverURL/$serverScript?wsdl", 'wsdl');
		$cliente->setCookie("TOKEN",$FACTRONICA["TOKEN"]);
		$err = $cliente->getError();
		if ($err) {
			echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
			echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
			exit();
		}
		$params = array(
		'rutEmisor' => $FACTRONICA["rutEmisor"],
		'dvEmisor'         => $FACTRONICA["dvEmisor"],
		'tipoDoc'         => $FACTRONICA["tipoDoc"],
		'folio'          => $FACTRONICA["folio"] 
		);
		$result = $cliente->call(
		 "$metodoALlamar", // Funcion a llamar
		$params, // Parametros pasados a la funcion
		 "uri:$serverURL/$serverScript", // namespace
		 "uri:$serverURL/$serverScript/$metodoALlamar" // SOAPAction,
		);
		if ($cliente->fault) {
			//echo '<h2>Fault (Expect - The request contains an invalid SOAP body)</h2><pre>'; 
			//print_r($result); 
			//echo '</pre>';
		} else {
			$err = $cliente->getError();
			if ($err) {
				//echo '<h2>Error</h2><pre>' . $err . '</pre>';
			} else {
				//echo 'FECHA RECEPCIÓN DOCUMENTO: '; 
				//return print_r($result); 
				$FACTRONICA["SEMILLA"] = $result;
				//echo '</h2>';
			}
		}
		
		//echo '<h2>Request</h2><pre>' . htmlspecialchars($cliente->request, ENT_QUOTES) . '</pre>';
		//echo '<h2>Response</h2><pre>' . htmlspecialchars($cliente->response, ENT_QUOTES) . '</pre>';
		//echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
		#
		//$ar=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["RESPUESTA"],"w") or die("ERROR:215");
		//fputs($ar,$result);
		//fclose($ar);
	} 
	##################################################
	# ACEPTAR / RECLAMAR DTE EN EL SII 
	##################################################
	#
	public function ingresarAceptacionReclamoDoc(){
		// acciones
		// ACD = ACEPTA
		// RCD = RECLAMA
		// ERM
		// RFP
		// RFT
		#
		global  $FACTRONICA;
		
		
		
		# URL DEL SERVIDOR
		if($FACTRONICA["PRODUCCION"]=="1"){
			$serverURL = 'https://ws1.sii.cl/WSREGISTRORECLAMODTE';   
		}else{
			$serverURL = 'https://ws2.sii.cl/WSREGISTRORECLAMODTECERT'; 
		}
		# 
		$serverScript = "registroreclamodteservice";  
		# METODO A LLAMAR
		$metodoALlamar = 'ingresarAceptacionReclamoDoc';  
  		$cliente = new nusoap_client("$serverURL/$serverScript?wsdl", 'wsdl');
		$cliente->setCookie("TOKEN",$FACTRONICA["TOKEN"]);
		$err = $cliente->getError();
		if ($err) {
			echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
			echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
			exit();
		}
		$params = array(
		'rutEmisor'=> $FACTRONICA["rutEmisor"],
		'dvEmisor'=> $FACTRONICA["dvEmisor"],
		'tipoDoc'=> $FACTRONICA["tipoDoc"],
		'folio'=> $FACTRONICA["folio"],
		'accionDoc'=> $FACTRONICA["accionDoc"]
		);
		$result = $cliente->call(
		 "$metodoALlamar", // Funcion a llamar
		$params, // Parametros pasados a la funcion
		 "uri:$serverURL/$serverScript", // namespace
		 "uri:$serverURL/$serverScript/$metodoALlamar" // SOAPAction,
		);
		if ($cliente->fault) {
			//echo '<h2>Fault (Expect - The request contains an invalid SOAP body)</h2><pre>'; 
			print_r($result); 
			//echo '</pre>';
		} else {
			$err = $cliente->getError();
			if ($err) {
				//echo '<h2>Error</h2><pre>' . $err . '</pre>';
			} else {
				//echo '<h2>Result</h2><pre>'; 
				$arr = $result; 
				///echo $arr;
				foreach($arr as $key=>$value){
					
					//echo $key . "=>" . $value . "<br>";
					 //echo strtoupper($value);
					 if($key == "codResp"){
						$FACTRONICA["codresp"] = $value;
					 }
					 if($key == "descResp"){
						$FACTRONICA["descresp"] = $value;
					 }
					//}
				}
			}
		}
		//echo '<h2>Request</h2><pre>' . htmlspecialchars($cliente->request, ENT_QUOTES) . '</pre>';
		//echo '<h2>Response</h2><pre>' . htmlspecialchars($cliente->response, ENT_QUOTES) . '</pre>';
		//echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
		#
		/*
		$ar=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["RESPUESTA"],"w") or die("ERROR:215");
		fputs($ar,$result);
		fclose($ar);	
		*/
		// creating object of SimpleXMLElement
		$xml_data = new SimpleXMLElement('<?xml version="1.0"?><data></data>');
		// function call to convert array to xml
		array_to_xml($result,$xml_data);
		//saving generated xml file; 
		$result = $xml_data->asXML($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["RESPUESTA"]);		
	}  	
	##################################################
	# LISTAR HISTORIAL EVENTOS SII
	##################################################
	#
	public function listarEventosHistDoc(){
		#
		global  $FACTRONICA;
		/*
		$FACTRONICA["rutEmisor"]="10377898";
		$FACTRONICA["dvEmisor"]="0";
		$FACTRONICA["tipoDoc"]="33";
		$FACTRONICA["folio"]="3093";
		*/
		# URL DEL SERVIDOR
		if($FACTRONICA["PRODUCCION"]=="1"){
			$serverURL = 'https://ws1.sii.cl/WSREGISTRORECLAMODTE';   
		}else{
			$serverURL = 'https://ws2.sii.cl/WSREGISTRORECLAMODTECERT'; 
		}
		# 
		$serverScript = "registroreclamodteservice";  
		# METODO A LLAMAR
		$metodoALlamar = 'listarEventosHistDoc';  
  		$cliente = new nusoap_client("$serverURL/$serverScript?wsdl", 'wsdl');
		$cliente->setCookie("TOKEN",$FACTRONICA["TOKEN"]);
		$err = $cliente->getError();
		if ($err) {
			echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
			echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
			exit();
		}
		$params = array(
		'rutEmisor' => $FACTRONICA["rutEmisor"],
		'dvEmisor'         => $FACTRONICA["dvEmisor"],
		'tipoDoc'         => $FACTRONICA["tipoDoc"],
		'folio'          => $FACTRONICA["folio"] 
		);
		$result = $cliente->call(
		 "$metodoALlamar", // Funcion a llamar
		$params, // Parametros pasados a la funcion
		 "uri:$serverURL/$serverScript", // namespace
		 "uri:$serverURL/$serverScript/$metodoALlamar" // SOAPAction,
		);
		if ($cliente->fault) {
			//echo '<h2>Fault (Expect - The request contains an invalid SOAP body)</h2><pre>'; 
			//print_r($result); 
			//echo '</pre>';
		} else {
			$err = $cliente->getError();
			if ($err) {
				//echo '<h2>Error</h2><pre>' . $err . '</pre>';
			} else {
				//echo '<h2>Result</h2><pre>'; 
				//print_r($result); 
				//echo '</pre>';
			}
		}
		//echo '<h2>Request</h2><pre>' . htmlspecialchars($cliente->request, ENT_QUOTES) . '</pre>';
		//echo '<h2>Response</h2><pre>' . htmlspecialchars($cliente->response, ENT_QUOTES) . '</pre>';
		//echo '<h2>Debug</h2><pre>' . htmlspecialchars($cliente->getDebug(), ENT_QUOTES) . '</pre>';
		
		/*		
		Array
		(
		[codResp] => 15
		[descResp] => Listado de eventos del documento
		[listaEventosDoc] => Array
			(
			[codEvento] => ACD
			[descEvento] => Acepta Contenido del Documento
			[rutResponsable] => 76606716
			[dvResponsable] => 6
			[fechaEvento] => 03-09-2017 19:48:31
			)

		)
		*/
		//echo count($result["listaEventosDoc"]);
		$c1=$result["codResp"];
		$c2=$result["descResp"];
		$c3=$result["listaEventosDoc"]["codEvento"];
		$c4=$result["listaEventosDoc"]["descEvento"];
		$c5=$result["listaEventosDoc"]["rutResponsable"];
		$c6=$result["listaEventosDoc"]["dvResponsable"];
		$c7=$result["listaEventosDoc"]["fechaEvento"];
		//echo sizeof($result["listaEventosDoc"]);
		$respuesta="$c1|$c2|$c3|$c4|$c5|$c6|$c7";
		if(count($result["listaEventosDoc"])!=5){
		for($i = 0; $i <=sizeof($result["listaEventosDoc"]) - 1; $i++){
		?>
		<tr>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"][$i]["codEvento"];?></td>
			<td style='text-align: center;'><?php echo utf8_encode($result["listaEventosDoc"][$i]["descEvento"]);?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"][$i]["rutResponsable"];?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"][$i]["dvResponsable"];?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"][$i]["fechaEvento"];?></td>
			
		</tr>
		<?php
		}
		}else{
			?>
		<td style='text-align: center;'><?php echo $result["listaEventosDoc"]["codEvento"];?></td>
			<td style='text-align: center;'><?php echo utf8_encode($result["listaEventosDoc"]["descEvento"]);?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"]["rutResponsable"];?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"]["dvResponsable"];?></td>
			<td style='text-align: center;'><?php echo $result["listaEventosDoc"]["fechaEvento"];?></td>	
		<?php
		}
 
		// creating object of SimpleXMLElement
		$xml_data = new SimpleXMLElement('<?xml version="1.0"?><data></data>');
		// function call to convert array to xml
		array_to_xml($result,$xml_data);
		//saving generated xml file; 
		$result = $xml_data->asXML($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["RESPUESTA"]);
		 
		#
		/*
		$ar=fopen($FACTRONICA["DIRTEMP"]."/".$FACTRONICA["RESPUESTA"],"w") or die("ERROR:215");
		fputs($ar,$respuesta);
		fclose($ar);
		*/
	} 		
}


// function defination to convert array to xml
function array_to_xml( $data, &$xml_data ) {
    foreach( $data as $key => $value ) {
        if( is_numeric($key) ){
            $key = 'item'.$key; //dealing with <0/>..<n/> issues
        }
        if( is_array($value) ) {
            $subnode = $xml_data->addChild($key);
            array_to_xml($value, $subnode);
        } else {
            $xml_data->addChild("$key",htmlspecialchars("$value"));
        }
     }
}
?>