<?php
function paginate_function($item_per_page, $current_page,$function, $total_records, $total_pages)
{
	
    $pagination = '';
    if($total_pages > 0 && $total_pages != 1 && $current_page <= $total_pages){ 
        $pagination .= '<ul class="paginacion" id="pagination-digg">';
        
        $right_links    = $current_page + 3; 
        $previous       = $current_page - 1; 
        $next           = $current_page + 1; 
        $first_link     = true; 
        
        if($current_page > 1){
			$previous_link = ($previous==0)?1:$previous;
            $pagination .= '<li class="first"><a style="cursor:pointer;" onClick="'.$function.'(1)" title="First">Primera</a></li>';
            $pagination .= '<li><a style="cursor:pointer;" onClick="'.$function.'('.$previous_link.')" title="Previous">Anterior</a></li>';
                for($i = ($current_page-2); $i < $current_page; $i++){ 
                    if($i > 0){
                        $pagination .= '<li><a style="cursor:pointer;" onClick="'.$function.'('.$i.')" title="Page'.$i.'">'.$i.'</a></li>';
                    }
                }   
            $first_link = false;
        }
        
        if($first_link){ 
            $pagination .= '<li class="first active"><a style="cursor:pointer;" onClick="'.$function.'('.$current_page.')">'.$current_page.'</a></li>';
        }elseif($current_page == $total_pages){ 
            $pagination .= '<li class="last active"><a style="cursor:pointer;" onClick="'.$function.'('.$current_page.')" >'.$current_page.'</a></li>';
        }else{ 
            $pagination .= '<li class="active"><a style="cursor:pointer;" onClick="'.$function.'('.$current_page.')">'.$current_page.'</a></li>';
        }
                
        for($i = $current_page+1; $i < $right_links ; $i++){ 
            if($i<=$total_pages){
                $pagination .= '<li><a style="cursor:pointer;" onClick="'.$function.'('.$i.')" title="Page '.$i.'">'.$i.'</a></li>';
            }
        }
        if($current_page < $total_pages){ 
				$next_link = ($i > $total_pages)? $total_pages : $i-2;
                $pagination .= '<li><a style="cursor:pointer;" onClick="'.$function.'('.$next_link.')" title="Next">Siguiente</a></li>';
                $pagination .= '<li class="last"><a style="cursor:pointer;" onClick="'.$function.'('.$total_pages.')" title="Last">Ultima</a></li>';
        }
        
        $pagination .= '</ul>'; 
    }
    return $pagination; 
}

function calculaPMP($producto) {
	$suma_cantidad=0;
	$suma_costo=0;
	$suma_cantidad2=0;
	$suma_costo2=0;
	$pmp=0;
	// Compra Directa
	$query = "select sum(b.cantidad) as 'suma_cantidad', sum(cantidad*costo) as 'suma_costo' from compras a left join compras_det b on a.id=b.compra_id Where a.estado=0 and producto_id=".trim($producto).";";
	$result = mysqli_query($con,$query);
	while ($row = @mysqli_fetch_array($result))
	{
		if (!is_null($row["suma_cantidad"])) {
			$suma_cantidad = $row["suma_cantidad"];
			if (!is_null($row["suma_costo"])) {
				$suma_costo = $row["suma_costo"];
			}
		}
	}
	mysqli_free_result($result);
	// Compra Consignaciones
	$query = "select sum(b.cantidad) as 'suma_cantidad', sum(cantidad*costo) as 'suma_costo' from compras_consig a left join compras_consig_det b on a.id=b.compra_consig_id Where a.estado=0 and producto_id=".trim($producto).";";
	$result = mysqli_query($con,$query);
	while ($row = @mysqli_fetch_array($result))
	{
		if (!is_null($row["suma_cantidad"])) {
			$suma_cantidad2 = $row["suma_cantidad"];
			if (!is_null($row["suma_costo"])) {
				$suma_costo2 = $row["suma_costo"];
			}
		}
	}
	
	//
	$suma_can = ($suma_cantidad + $suma_cantidad2);
	$suma_cos = ($suma_costo + $suma_costo2);
	if ($suma_can > 0) {
		$pmp = round($suma_cos / $suma_can);
	}
	return $pmp;
        
        mysqli_free_result($result);
}

function calculaPMP_Consig($producto) {
	$suma_cantidad=0;
	$suma_costo=0;
	$pmp=0;
	// Consignaciones
	$query = "select sum(b.cantidad) as 'suma_cantidad', sum(cantidad*costo) as 'suma_costo' from consignaciones a left join consignaciones_det b on a.id=b.consignacion_id Where b.producto_id=".trim($producto).";";
	$result = mysqli_query($con,$query);
	while ($row = @mysqli_fetch_array($result))
	{
		if (!is_null($row["suma_cantidad"])) {
			$suma_cantidad = $row["suma_cantidad"];
			if (!is_null($row["suma_costo"])) {
				$suma_costo = $row["suma_costo"];
			}
		}
	}
	@mysqli_free_result($result);
	//
	if ($suma_cantidad > 0) {
		$pmp = round($suma_costo / $suma_cantidad);
	}
	return $pmp;
}




function obtienePrecioVenta($producto) {
	$fg=0;
	$fd=0;
	$ad=false;
	$marca=0;
	$categoria=0;
	$pmp=0;
	$pmp2=0;
	$pv=0;
	$dolar_base=0;
	$dolar_comparacion=0;
	// Extrae Datos Producto
	$query = "select * from productos Where id=".trim($producto).";";
	$result = mysqli_query($con,$query);
	while ($row = @mysqli_fetch_array($result))
	{
		if ($row["factor_gral_pv"] > 0) {
			$fg=$row["factor_gral_pv"];
			if ($row["aplica_factor_dolar"] == 1) {
				$ad=true;
			}
		}
		$categoria = $row["categoria_id"];
		$marca = $row["marca_id"];
		$pmp = $row["pmp"];
		$pmp2 = $row["pmp_consig"];
	}
	@mysqli_free_result($result);
	//
	if ($fg==0) {
		// Revisa condiciones de venta en Marca
		$query = "select * from marcas Where id=".trim($marca).";";
		$result = mysqli_query($con,$query);
		while ($row = @mysqli_fetch_array($result))
		{
			if ($row["factor_gral_pv"] > 0) {
				$fg=$row["factor_gral_pv"];
				if ($ad==false) {
					if ($row["aplica_factor_dolar"] == 1) {
						$ad=true;
					}
				}
			}
		}
		@mysqli_free_result($result);
	}
	//
	if ($fg==0) {
		// Revisa condiciones de venta en Categoria
		$query = "select * from categorias Where id=".trim($categoria).";";
		$result = mysqli_query($con,$query);
		while ($row = @mysqli_fetch_array($result))
		{
			if ($row["factor_gral_pv"] > 0) {
				$fg=$row["factor_gral_pv"];
				if ($ad==false) {
					if ($row["aplica_factor_dolar"] == 1) {
						$ad=true;
					}
				}
			}
		}
		@mysqli_free_result($result);
	}
	//
	if ($fg==0) {
		// Revisa condiciones de venta Generales
		$query = "select * from factores Where nemo='FGPV';";
		$result = mysqli_query($con,$query);
		while ($row = @mysqli_fetch_array($result))
		{
			if ($row["valor"] > 0) {
				$fg=$row["valor"];
			}
		}
		@mysqli_free_result($result);
	}
	//
	if ($ad==true) {
		// calcula factor variacion dolar		
		$query = "select * from factores Where nemo='FDB';";
		$result = mysqli_query($con,$query);
		while ($row = @mysqli_fetch_array($result))
		{
			if ($row["valor"] > 0) {
				$dolar_base=$row["valor"];
			}
		}
		@mysqli_free_result($result);
		// rescata ultimo valor dolar informado
		$query = "select * from tipo_cambio order by fecha desc;";
		$result = mysqli_query($con,$query);
		while ($row = @mysqli_fetch_array($result))
		{
			if ($row["valor"] > 0) {
				$dolar_comparacion=$row["valor"];
			}
		}
		@mysqli_free_result($result);
		//
		if ($dolar_base > 0 && $dolar_comparacion > 0) {
			if ($dolar_base < $dolar_comparacion) {
				$fd = (100-( ($dolar_base*100) / $dolar_comparacion ));
			}	
		}
	}
	if ($fg > 0) {
		if ($pmp > 0) {
			$pv = ($pmp + ( ($fg * $pmp) / 100 ));
		} else {
			if ($pmp2 > 0) {
				$pv = ($pmp2 + ( ($fg * $pmp2) / 100 ));
			}
		}
		if ($ad==true) {
			if ($fd > 0 && $pv > 0) {
				$pv = ($pv + ( ($fd * $pv) / 100 ));
			}
		}	
	}
	return $pv;
}

function mysql_date($date) { 
$year = substr($date,6,4); // 01-12-2007
$month = substr($date,3,2); $day = substr($date,0,2); 
$date = $year."-".$month."-".$day; 
return ($date); 
}


function insert_libro_diario_factura($pago,$decpago,$idcliente, $total,$neto, $iva, $rut, $factura){
	if($pago == 1){
		$montos = array($total,$neto,$iva);
		$list1 = array(11, 113, 78);
		$list2 = array(11, 4);
		$glosa1= 'Se realiza venta  factura N°' .$factura.'. Correspondiente al cliente Rut: '.$rut.'';
		$glosa2= 'Cliente Rut: '.$rut.' Cancela Factura N° '.$factura.' en '.$decpago.'';
	}else if($pago == 2){
		$list1 = array(11, 113, 78);
		$list2 = array(11, 7);
		$glosa1= 'Se realiza venta  factura N°' .$factura.'. Correspondiente al cliente Rut: '.$rut.'';
		$glosa2= 'Cliente Rut: '.$rut.' Cancela Factura N° '.$factura.' en '.$decpago.'';
	}
	$longitud1 = count($list1);
	$longitud2 = count($list2);
	
	//Glosa 1
	$sql = "insert into glosa values(null,'$glosa1',curdate())";
	$res = mysqli_query($con,$sql);
	$IdGlosa1 = mysqli_insert_id($con);
	
	mysqli_free_result($res);
	$debe_haber = '';
	for($i=0; $i < $longitud1; $i++){
		if($i==0){
			$debe_haber =$list1[$i].",".$montos[$i].','.'0';
		}else{
			$debe_haber = $list1[$i].",0,".$montos[$i];
		}
		
		$query = "insert into libro_diario values(null,$idcliente,curdate(),$IdGlosa1 ,".$debe_haber.")";
		$result = mysqli_query($con,$query);
		
	}
	mysqli_free_result($result);
	
	//Glosa 2
	$sql = "insert into glosa values(null,'$glosa2',curdate())";
	$res = mysqli_query($con,$sql);
	$IdGlosa2 = mysqli_insert_id($con);
	
	mysqli_free_result($res);
	
	for($i=0; $i < $longitud2; $i++){
		if($i==0){
			$debe_haber1 = $list2[$i].",".$montos[0].','.'0';
		}else{
			$debe_haber1 = $list2[$i].",0,".$montos[0];
		}
		
		$query = "insert into libro_diario values(null,$idcliente,curdate(),$IdGlosa2 ,".$debe_haber1.")";
		$result = mysqli_query($con,$query);
		
		
	}
	mysqli_free_result($result);
}


function wordlimit($string, $length = 50, $ellipsis = "...")
{
	$words = explode(' ', $string);
	if (count($words) > $length)
	{
		return implode(' ', array_slice($words, 0, $length)) ." ". $ellipsis;
	}
	else
	{
		return $string;
	}
}
?>