/*
Script creado por Calcular.cl 
Prohibida su reproducción total o parcial sin el consentimiento
de calcular.cl
*/

function reverseNumber(input) {
  return [].map.call(input, function(x) {
    return x;
  }).reverse().join(''); 
}
      
function plainNumber(number) {
  return number.split('.').join('');
}
      
function splitInDots(input) {
  var value = input.value,
  plain = plainNumber(value),
  reversed = reverseNumber(plain),
  reversedWithDots = reversed.match(/.{1,3}/g).join('.'),
  normal = reverseNumber(reversedWithDots);
  //console.log(plain,reversed, reversedWithDots, normal);
  input.value = normal;
}
      
function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}
      
function numberWithCommas(x) {
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

const _MS_PER_DAY = 1000 * 60 * 60 * 24;

// a and b are javascript Date objects
function dateDiffInDays(a, b) {
  // Discard the time and time-zone information.
  const utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
  const utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

  return Math.floor((utc2 - utc1) / _MS_PER_DAY);
}

function dias_aviso(){
  /////////////////
  // fecha finiquito
  /////////////////
  if(document.formulario.fecha_finiquito.value == '' || document.formulario.fecha_finiquito.value == null){
    fecha_finiquito = null;
  }
  else{
    fecha_finiquito = moment(document.formulario.fecha_finiquito.value, "YYYY-MM-DD");  
  }

  /////////////////
  // fecha de aviso de despido
  /////////////////
  if(document.formulario.fecha_aviso.value == '' || document.formulario.fecha_aviso.value == null){
    fecha_aviso = null;
  }
  else{
    fecha_aviso = moment(document.formulario.fecha_aviso.value, "YYYY-MM-DD"); 
  }

  if(fecha_aviso != '' && fecha_finiquito != '' && fecha_aviso != null && fecha_finiquito != null){
    document.formulario.dia_aviso.value = fecha_finiquito.diff(fecha_aviso,'days');
  }
}

function add_months(){
  if(document.formulario.tipoContratoSelect.value == "fijo"){
    document.getElementById("form_variable").style.display = "none";
  }
  else{
    document.getElementById("form_variable").style.display = "initial";
  }
}

function addWeekdays(date, days) {
  date = moment(date,'YYYY-MM-DD'); // use a clone
  while (days > 0) {
    date = date.add(1, 'days');
    // decrease "days" only if it's a weekday.
    /*
    if (date.isoWeekday() !== 6 && date.isoWeekday() !== 7) {
      days -= 1;
    }
    */

    if (date.isoWeekday() !== 6 && date.isoWeekday() !== 7 && $.inArray(date.format('YYYY-MM-DD'), feriadosData) == -1) {
      days -= 1;
    }
    

  }
  return date;
}

function startCalc(){
  interval = setInterval("calc()",1);
}

function calc(){

  /////////////////
  // CAUSAL
  /////////////////
  if(document.formulario.causal.value == '' || document.formulario.causal.value == null){
    causal = 0;
  }
  else{
    causal = document.formulario.causal.value;  
  }

  /////////////////
  // fecha inicio contrato
  /////////////////
  if(document.formulario.fecha_inicio.value == '' || document.formulario.fecha_inicio.value == null){
    fecha_inicio = null;
  }
  else{
    fecha_inicio = moment(document.formulario.fecha_inicio.value, 'YYYY-MM-DD'); 
  }

  /////////////////
  // fecha aviso
  /////////////////
  if(document.formulario.fecha_aviso.value == '' || document.formulario.fecha_aviso.value == null){
    fecha_aviso = null;
  }
  else{
    fecha_aviso = moment(document.formulario.fecha_aviso.value, 'YYYY-MM-DD');  
  }

  /////////////////
  // fecha finiquito
  /////////////////
  if(document.formulario.fecha_finiquito.value == '' || document.formulario.fecha_finiquito.value == null){
    fecha_finiquito = null;
  }
  else{
    fecha_finiquito = moment(document.formulario.fecha_finiquito.value, 'YYYY-MM-DD');  
  }

  /////////////////
  // TIPO DE SUELDO FIJO/VARIABLE
  /////////////////
  tipoContratoSelect = document.formulario.tipoContratoSelect.value; 

  /////////////////
  // SUELDO BASE
  /////////////////
  if(document.formulario.sueldoBase.value == '' || document.formulario.sueldoBase.value == null){
    sueldoBase = 0;
  }
  else{
    sueldoBase = parseInt((document.formulario.sueldoBase.value).split('.').join("")); // .split('.').join("") quita los puntos
  }

  /////////////////
  // COMISION 1
  /////////////////
  if(document.formulario.comisiones1.value == '' || document.formulario.comisiones1.value == null){
    comisiones1 = 0;
  }
  else{
    comisiones1 = parseInt((document.formulario.comisiones1.value).split('.').join("")); // .split('.').join("") quita los puntos
  }

  /////////////////
  // COMISION 2
  /////////////////
  if(document.formulario.comisiones2.value == '' || document.formulario.comisiones2.value == null){
    comisiones2 = 0;
  }
  else{
    comisiones2 = parseInt((document.formulario.comisiones2.value).split('.').join("")); // .split('.').join("") quita los puntos
  }

  /////////////////
  // COMISION 3
  /////////////////
  if(document.formulario.comisiones3.value == '' || document.formulario.comisiones3.value == null){
    comisiones3 = 0;
  }
  else{
    comisiones3 = parseInt((document.formulario.comisiones3.value).split('.').join("")); // .split('.').join("") quita los puntos
  }
  
  ///////////////////
  // GRATIFICACION
  //////////////////
  if(tipoContratoSelect == "fijo"){ // gratificacion con sueldo base
    // gratificación: grat o 25% de base, el q sea menor.
    comisionesx = 0;
    if(document.formulario.gratificacionCheck.checked){
      if(grat>(sueldoBase)*0.25){ 
        gratificacion = Math.round((sueldoBase)*0.25);
        document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
      }
      else{
        gratificacion = Math.round(grat);
        document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
      }
    }
    else{
      gratificacion = 0;
      document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
    } // fin gratificación
  }
  else{ // gratificacion con los 3 ultimos variables
    comisionesx = (comisiones1 + comisiones2 + comisiones3)/3;
    // gratificación: grat o 25% de base, el q sea menor.
    if(document.formulario.gratificacionCheck.checked){
      if(grat>(sueldoBase+comisionesx)*0.25){ 
        gratificacion = Math.round((sueldoBase+comisionesx)*0.25);
        document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
      }
      else{
        gratificacion = Math.round(grat);
        document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
      }
    }
    else{
      gratificacion = 0;
      document.formulario.gratificacion.value = numberWithCommas(Math.round(gratificacion));
    } // fin gratificación
  } 
  
  //////////////////
  // COLACION
  /////////////////
  if(document.formulario.colacion.value == '' || document.formulario.colacion.value == null){colacion = 0;}else{
    colacion = parseInt((document.formulario.colacion.value).split('.').join(""));
  }
  /////////////////
  // MOVILIZACION
  ////////////////
  if(document.formulario.movilizacion.value == '' || document.formulario.movilizacion.value == null){movilizacion = 0;}else{
    movilizacion = parseInt((document.formulario.movilizacion.value).split('.').join(""));
  }

  /////////////////
  // CANTIDAD ANOS DE SERVICIO
  /////////////////
  if(fecha_inicio == '' || fecha_finiquito == '' || fecha_inicio == null || fecha_finiquito == null){
    anos_servicio_precise ={years:0, months:0, days:0};
    document.formulario.anos_servicio.value = 0;
  }
  else{
    //anos_servicio = Math.round(dateDiffInDays(fecha_inicio,fecha_finiquito)/365);
    //anos_servicio = dateDiffInDays(fecha_inicio,fecha_finiquito)/365;
    anos_servicio_precise = moment.preciseDiff(moment(fecha_inicio,'YYYY-MM-DD'), moment(fecha_finiquito,'YYYY-MM-DD'),true);
    document.formulario.anos_servicio.value = anos_servicio_precise.years+" año(s) "+anos_servicio_precise.months+" mese(s) "+anos_servicio_precise.days+" día(s) ";
  }

  /////////////////
  // VACACIONES TOTALES
  /////////////////
  if(fecha_inicio == '' || fecha_finiquito == '' || fecha_inicio == null || fecha_finiquito == null){
      vacaciones_totales = 0;
  }
  else{
      x = moment.preciseDiff(moment(fecha_inicio,'YYYY-MM-DD'), moment(fecha_finiquito,'YYYY-MM-DD'),true);
      vacaciones_totales = x.years*15 + x.months*1.25 + x.days*(1.25/30);
      document.formulario.vacaciones_totales.value = vacaciones_totales.toFixed(2);
  }

  /////////////////
  // VACACIONES CONSUMIDAS
  /////////////////
  if(document.formulario.vacaciones_consumidas.value == '' || document.formulario.vacaciones_consumidas.value == null){vacaciones_consumidas = 0;}else{
    vacaciones_consumidas = parseInt((document.formulario.vacaciones_consumidas.value).split('.').join(""));
  }

  /////////////////
  // VACACIONES PENDIENTES
  /////////////////
  vacaciones_pendientes = (vacaciones_totales - vacaciones_consumidas).toFixed(2);
  document.formulario.vacaciones_pendientes.value = numberWithCommas(vacaciones_pendientes);

  /////////////////
  // REMUNERACION PENDIENTE
  /////////////////
  if(document.formulario.remuneracion_pendientes.value == '' || document.formulario.remuneracion_pendientes.value == null){
    remuneracion_pendientes = 0;
  }
  else{
    remuneracion_pendientes = parseInt((document.formulario.remuneracion_pendientes.value).split('.').join("")); // .split('.').join("") quita los puntos
  }

  /////////////////
  // INDEMNIZAVION AVISO PREVIO
  /////////////////
  // causal 159-1, 159-2 y 159-3 no aplica indemnizacion de aviso previo
  if(causal != "159-1" && causal != "159-2" && causal != "159-3"){
    // revisar diferencia de fecha para indemnizacion por 30 dias
    if(document.formulario.dia_aviso.value <= 30){
      indemnizacion_aviso_previo = sueldoBase+comisionesx+gratificacion+colacion+movilizacion;
      if(indemnizacion_aviso_previo > 90*uf){
        indemnizacion_aviso_previo = 90*uf;
      }
      document.formulario.indemnizacion_aviso_previo.value = numberWithCommas(parseInt(indemnizacion_aviso_previo));
    }else{ 
      indemnizacion_aviso_previo = 0
      document.formulario.indemnizacion_aviso_previo.value = indemnizacion_aviso_previo;
    }
  }
  else{
    indemnizacion_aviso_previo = 0
    document.formulario.indemnizacion_aviso_previo.value = indemnizacion_aviso_previo;
  }

  /////////////////
  // INDEMNIZACION POR AÑOS DE SERVICIO
  /////////////////
  // (solo si causal es 161-1 o 161-2)
  if(causal == "161-1" || causal == "161-2"){ 
    if(anos_servicio_precise.years>=1){ // minimo 1 año de trabajo para poder obtener el beneficio de indemnización

      indemnizacion_anos_base = sueldoBase+gratificacion+comisionesx;

      if(anos_servicio_precise.months>=6){
        anos_servicio = anos_servicio_precise.years + 1;
      }
      else{
        anos_servicio = anos_servicio_precise.years;
      }

      if(indemnizacion_anos_base > 90*uf){
        indemnizacion_anos_base = 90*uf;
      }

      //si fecha_inicio después de 14 agosto 1981 (1981-08-14) entonces check si mas de 11 años
      if (moment(fecha_inicio).isAfter("1981-08-14")) {
        if(anos_servicio > 11){
          anos_servicio_fix = 11;
          indemnizacion_anos_servicio = anos_servicio_fix*indemnizacion_anos_base;
        }
        else{
          indemnizacion_anos_servicio = anos_servicio*indemnizacion_anos_base;
        }
      }
      else{
        indemnizacion_anos_servicio = anos_servicio*indemnizacion_anos_base;
      }
    }
    else{
      indemnizacion_anos_servicio = 0;
    }
  }
  else{
    indemnizacion_anos_servicio = 0;
  }
  document.formulario.indemnizacion_anos_servicio.value = numberWithCommas(parseInt((indemnizacion_anos_servicio)));


  /////////////////
  // FERIADO PROPORCIONAL
  /////////////////


  if(fecha_inicio == '' || fecha_finiquito == '' || fecha_inicio == null || fecha_finiquito == null){
      vacaciones_pendientes_fix = 0;
  }
  else{
    fecha_finiquito_mas_dias_pendientes = moment(addWeekdays(fecha_finiquito, Math.ceil(vacaciones_pendientes)),'YYYY-MM-DD');
    vacaciones_pendientes_fix = fecha_finiquito_mas_dias_pendientes.diff(fecha_finiquito,'days');

  }

  monto_diario = (sueldoBase + comisionesx)/30;  
  document.formulario.feriado_proporcional_dias.value = vacaciones_pendientes_fix;
  vacaciones_proporcionales = vacaciones_pendientes_fix*monto_diario;
  document.formulario.feriado_proporcional.value = numberWithCommas(parseInt(vacaciones_proporcionales));

  /////////////////
  // FINIQUITO
  /////////////////
  finiquito = indemnizacion_aviso_previo+indemnizacion_anos_servicio+vacaciones_proporcionales+remuneracion_pendientes;
  document.formulario.finiquito.value = numberWithCommas(Math.round(finiquito));

}

function stopCalc(){
  clearInterval(interval);
}

$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip(); 
   
    $('#utm').attr('placeholder', '$'+numberWithCommas(utm.toString().replace(".",",")) ); 
    $('#uf').attr('placeholder', '$'+numberWithCommas(uf.toString().replace(".",",")) );
    $('#imm').attr('placeholder', '$'+numberWithCommas(imm.toString().replace(".",",")) );  
});

$('a.tooltipx').webuiPopover({width:300, animation:'pop'});

$.datepicker.regional['es'] = {
 closeText: 'Cerrar',
 prevText: '< Ant',
 nextText: 'Sig >',
 currentText: 'Hoy',
 monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
 monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
 dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
 dayNamesShort: ['Dom','Lun','Mar','Mié','Juv','Vie','Sáb'],
 dayNamesMin: ['Do','Lu','Ma','Mi','Ju','Vi','Sá'],
 weekHeader: 'Sm',
 dateFormat: 'dd/mm/yy',
 firstDay: 1,
 isRTL: false,
 showMonthAfterYear: false,
 yearSuffix: ''
 };
 $.datepicker.setDefaults($.datepicker.regional['es']);
 

$( function() {
    $( ".datepicker" ).datepicker({
      changeMonth: true,
      changeYear: true,
      dateFormat: 'yy-mm-dd'
    });

  } );
