<?php
require('fpdf/fpdf.php');
require_once("include/header.php");


class PDF_MC_Table extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function Row1($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=25;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'C';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
	
	
    //Go to the next line
    $this->Ln($h);
	/*if($i > 4 ){
			$this->AddPage();
	}*/
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

function Header()
{
    // Logo
    //$this->Image('images/logo5.png',10,6,30);

	$this->Image($GLOBALS['logo_empresa'],10,5,25,0,'');
    // Arial bold 15
    //$this->SetFont('Arial','B',15);
    // Move to the right
    //$this->Cell(80);
    // Title
   // $this->Cell(30,10,'Title',1,0,'C');
    // Line break
    $this->Ln(20);
	
	$this->SetFont('Arial','B',9);
$this->SetTextColor(234, 8, 8);
//$this->Image('images/logo/imagen_group.jpg',85,5,30,0,'');
//$this->Image('images/cotizacion_detalles_pago.jpg',150,43,50,0,'');
//$this->Ln(10);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,7,utf8_decode('Señor(es):'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,utf8_decode($GLOBALS['rsocialcliente']),0,0,'c');
$this->SetX(138);
$this->Cell(20,8,utf8_decode('Fecha: '.$GLOBALS['fechaBoleta']),0,0,'0');
$this->Ln(4.7);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('R.U.T:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode($GLOBALS['rcliente']),'',0,'c');
$this->SetX(138);
$this->Cell(20,8,utf8_decode('Condiciones de Venta: '.$GLOBALS['condicion']),0,0,'0');
$this->Ln(4.7);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Giro:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['girocliente']),'',0,'c');
$this->SetX(138);
$this->Cell(20,8,utf8_decode('Plazo de Entrega: '.$GLOBALS['plazo']),0,0,'0');
$this->Ln(4.7);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Dirección:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['direccioncliente']),'',0,'c');
/*
$this->SetX(142);
$this->Cell(25,8,utf8_decode('Observaciones: '.$GLOBALS['observaciones']),0,0,'0');*/


$this->Ln(4.7);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Teléfono:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['fonocliente']),'',0,'c');

$this->Ln(4.7);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Correo:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['correocliente']),'',0,'c');



$this->Ln(4.7);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Solicitante:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode($GLOBALS['solicitante']),'',0,'c');

$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,'','',0,'c');
$this->Rect(10,30,128,35);
 
  $this->Rect(138,30,62,35);
  
  
  $this->Ln(8);
  $this->SetFont('Arial','B',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,7,utf8_decode('EXTENDER ORDEN DE COMPRA A LA ORDEN DE:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(80,7,'',0,0,'c');
  $this->SetFont('Arial','',9);
 $this->Ln(6);
$this->SetTextColor(0, 0, 0);
$this->Cell(25,8,utf8_decode(strtoupper($GLOBALS['señor'])),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,'','',0,'c');
$this->Ln(6);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('R.U.T:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(35,8,utf8_decode(strtoupper($GLOBALS['rut_empresa'])),'',0,'c');

$this->Ln(6);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Giro:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode(strtoupper($GLOBALS['giro_empresa'])),'',0,'c');

$this->Ln(6);
$this->SetFont('Arial','',9);
$this->SetTextColor(0, 0, 0);
$this->Cell(20,8,utf8_decode('Dirección:'),0,0,'0');
$this->SetTextColor(0, 0, 0);
$this->Cell(95,8,utf8_decode(strtoupper($GLOBALS['direccion_empresa'])),'',0,'c');
 $this->Rect(10,65,128,32);
$this->Ln(10);
$this->SetX(85);
$this->SetFont('Arial','B',14);
$this->Cell(25,8,utf8_decode('COTIZACION:'),0,0,'0');
$this->SetX(157);
$this->SetFont('Arial','B',14);
$this->Cell(60,7,utf8_decode("N°  ").right("00000".trim($GLOBALS['nroBoleta']),10)."",'',1,'C');
//Numero Documento


$this->Ln(5);


}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
    
    // Arial italic 8
	$this->SetY(-50);
    $this->SetFont('Arial','B',9);
    // Page number
	//$this->SetX(10);
	$this->SetX(12);
	$this->Cell(26,6,utf8_decode('Observaciones: '),'B',0,'1');
	 $this->SetFont('Arial','',8);
	$this->Cell(100,6,utf8_decode($GLOBALS['observaciones']),0,0,'1');
	$this->SetFont('Arial','B',8);
	$this->SetX(140);
	$this->Cell(30,6,'SUBTOTAL','B',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'B',0,'R');
	$this->SetFont('Arial','',8);
	$this->Ln(8);
	$this->Cell(15,6,'Web:',0,0,'1');
	$this->Cell(70,6,'www.sillasalmayorchile.cl',0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'DESCUENTO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,'','',0,'R');
	$this->Ln(6);
	$this->Cell(15,6,'Correo:',0,0,'1');
	$this->Cell(70,6,'mmoreno@sillasalmayorchile.cl/npadilla@sillasalmayorchile.cl',0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'PRECIO NETO','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['netot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(15,6,'Fono:',0,0,'1');
	$this->Cell(70,6,'+56 2 2500 0994 / +56 9 77182231',0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'IVA','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['ivat'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Cell(30,6,'',0,0,'1');
	$this->Cell(70,6,'',0,0,'1');
	$this->SetX(140);
	$this->Cell(30,6,'PRECIO FINAL','',0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,number_format($GLOBALS['montot'], 0, ",", "."),'',0,'R');
	$this->Ln(6);
	$this->Rect(10,245,190,35);
	/*$this->SetX(130);
	$this->Cell(30,6,'OBSERVACIONES',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['med_pago'],1,0,'R');
	$this->Ln(6);
	$this->SetX(130);
	$this->Cell(30,6,'MEDIO DE PAGO',1,0,'1');
	$this->SetFont('Arial','',8);
	$this->Cell(30,6,$GLOBALS['observaciones'],1,0,'R');*/
	$this->SetY(-15);
	$this->SetFont('Arial','I',8);
    $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
	//$this->Image('images/cotizacion_foot.jpg',10,275,190,20,'');
	//$this->Image('images/cotizacion_detalles_pago.jpg',150,240,50,0,'');
}
}
?>