<?php

function basico($numero) {
				$valor = array ('uno','dos','tres','cuatro','cinco','seis','siete','ocho',
				'nueve','diez','once','doce','trece','catorce','quince','dieciseis','diecisiete','dieciocho','diecinueve','veinte','veintiuno','veintidos','veintitres','veinticuatro','veinticinco',
				'veintiseis','veintisiete','veintiocho','veintinueve');
				return $valor[$numero - 1];
			}

			function decenas($n) {
				$decenas = array (30=>'treinta',40=>'cuarenta',50=>'cincuenta',60=>'sesenta',
				70=>'setenta',80=>'ochenta',90=>'noventa');
				if( $n <= 29) return basico($n);
				$x = $n % 10;
				if ( $x == 0 ) {
					return $decenas[$n]; 
				} else return $decenas[$n - $x].' y '. basico($x);
			}

			function centenas($n) {
				$cientos = array (100 =>'cien',200 =>'doscientos',300=>'trecientos',
				400=>'cuatrocientos', 500=>'quinientos',600=>'seiscientos',
				700=>'setecientos',800=>'ochocientos', 900 =>'novecientos');
				if( $n >= 100) {
					if ( $n % 100 == 0 ) {
						return $cientos[$n]; 
					} else {
						$u = (int) substr($n,0,1);
						$d = (int) substr($n,1,2);
						return (($u == 1)?'ciento':$cientos[$u*100]).' '.decenas($d);
					}
				} else return decenas($n);
			}

			function miles($n) {
				if($n > 999) {
					if( $n == 1000) {return 'mil';}
					else {
						$l = strlen($n);
						$c = (int)substr($n,0,$l-3);
						$x = (int)substr($n,-3);
						if($c == 1) {$cadena = 'mil '.centenas($x);}
						else if($x != 0) {$cadena = centenas($c).' mil '.centenas($x);}
						else $cadena = centenas($c). ' mil';
						return $cadena;
					}
				} else return centenas($n);
			}

			function millones($n) {
				if($n == 1000000) {return 'un millon';}
				else {
					$l = strlen($n);
					$c = (int)substr($n,0,$l-6);
					$x = (int)substr($n,-6);
					if($c == 1) {
						$cadena = ' millon ';
					} else {
						$cadena = ' millones ';
					}
					return miles($c).$cadena.(($x > 0)?miles($x):'');
				}
			}
			function convertir($n) {
				switch (true) {
				case ( $n >= 1 && $n <= 29)  : return basico($n); break;
				case ( $n >= 30 && $n < 100) : return decenas($n); break;
				case ( $n >= 100 && $n < 1000) : return centenas($n); break;
				case ($n >= 1000 && $n <= 999999): return miles($n); break;
				case ($n >= 1000000): return millones($n);
				}
			}

require_once("./include/header.php");
require_once('fpdf/fpdf.php');
//require_once('barcode.inc.php');
session_start();
$con = opendblocal();



$sqlenc = "select * from encabezado";
$resenc = mysqli_query($con,$sqlenc);
while($rw1 = mysqli_fetch_array($resenc)){
	$logo_empresa = $rw1['logo'];
	$señor = $rw1['senior'];
	$rut_empresa = $rw1['rut'];
	$giro_empresa = $rw1['giro_comercial'];
	$direccion_empresa = $rw1['direccion'];
	$comuna_empresa = $rw1['comuna'];
	$ciudad_empresa = $rw1['ciudad'];
	$contacto_empresa = $rw1['email'];
}






class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}

function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}

function Header()
{	
    $this->SetFont('Arial','B',22);
    $this->Cell(1);
    $this->Cell(0,10,'BOLETA DE VENTA',0,0,'R');
    
}

function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',8);

	
}
}

//<<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO BOLETA POS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['bolet_numdoc'])){
        $idboleta = base64_decode($_REQUEST['bolet_numdoc']);
        $sqlNumBoleta = "SELECT boleta FROM tmp_pos WHERE id=".$idboleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', B.rut, B.razon_social FROM tmp_pos A LEFT JOIN clientes B ON A.cliente_id=B.id WHERE A.id=".trim($idboleta).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$id = $row["id"];
		$fechaBoleta=$row["FechaBoleta"];
		$nroBoleta=$row["boleta"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: ".$rut_empresa,'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("BOLETA ELECTRÓNICA"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);

	$pdf->Ln(4);

	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 80, 50, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones,b.psale_c_iva as precio_venta, b.codigo_externo from tmp_det_pos a join productos b on a.producto_id=b.id where boleta_id = ".$idboleta.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}


	
$pdf->Ln(16);



$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'VALOR TOTAL','TLB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($suma+$iva, 0, ",", "."),'TRB',0,'R');

$pdf->Output();
}

//<<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO BOLETA POS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['bolet_num'])){
        $idboleta = base64_decode($_REQUEST['bolet_num']);
        $sqlNumBoleta = "SELECT boleta FROM boletas_pos WHERE id=".$idboleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', B.rut, B.razon_social FROM boletas_pos A LEFT JOIN clientes B ON A.cliente_id=B.id WHERE A.id=".trim($idboleta).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$id = $row["id"];
		$fechaBoleta=$row["FechaBoleta"];
		$nroBoleta=$row["boleta"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: ".$rut_empresa,'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("BOLETA ELECTRÓNICA"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);

	$pdf->Ln(4);

	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 80, 50, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones,b.psale_c_iva as precio_venta, b.codigo_externo from boleta_det_pos a join productos b on a.producto_id=b.id where boleta_id = ".$idboleta.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}


	
$pdf->Ln(16);



$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'VALOR TOTAL','TLB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($suma+$iva, 0, ",", "."),'TRB',0,'R');

$pdf->Output();
}


//<<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO NOTA VENTA >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['nv_num'])){
	$idboleta = base64_decode($_REQUEST['nv_num']);
	$sqlNumBoleta = "SELECT a.*,b.nombre,DATE_FORMAT( a.fecha, '%d/%m/%Y') as fechaventa FROM nota_venta_pos a join usuarios b  WHERE a.id=".$idboleta.";";
	
	$result1 = mysqli_query($con,$sqlNumBoleta);
	while($rw = mysqli_fetch_array($result1)){
		$notaventa = $rw['boleta'];
		$usuario = $rw['nombre'];
		$fecha = $rw['fechaventa'];
		$hora = $rw['hora'];
	}
	
	
	$dato = mysql_fetch_row($result1);
	
	
	$pdf = new FPDF('P','cm',array(10,14));
	$pdf->AddPage();
	$pdf->SetFont('Arial','B',14);

	$pdf->Cell(0,1,'Vendedor: '.$usuario,'',0,'0');
		$pdf->Ln(1);
		$pdf->SetFont('Arial','B',20);
		$pdf->Cell(1,1,utf8_decode('N°').$notaventa,0,'0');
	//$pdf->Cell(0,1.5,'Caja: 1','',0,0);
	
$pdf->SetFont('Arial','B',14);
	
	$pdf->Ln(2);
	$pdf->Cell(1,1,'Fecha: '.$fecha.'     Hora: '.$hora,0,'0');
	

	$pdf->Output();
}




//<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO FACTURA >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['fact_num'])){
        $id_boleta = base64_decode($_REQUEST['fact_num']);
        $sqlNumBoleta = "SELECT factura FROM factura WHERE factura=".$id_boleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
	
	
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', B.rut, B.razon_social FROM factura A LEFT JOIN clientes B ON A.cliente_id=B.id WHERE A.factura=".trim($id_boleta).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$fechaBoleta=$row["FechaBoleta"];
		$montot = $row['monto_total'];
		$netot = $row['neto'];
		$desct = $row['descuento'];
		$ivat = $row['iva'];
		$nroBoleta=$row["factura"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		
list($dia,$mes,$anio) = explode('/',$fechaBoleta);
			
			$nyear = substr($anio, -2);
			
		switch($mes) 
		{
		case "01":
			$var = "Enero";
			break;
		case "02":
			$var = "Febrero";
			break;
		case "03":
			$var = "Marzo";
			break;
		case "04":
			$var = "Abril";
			break;
		case "05":
			$var = "Mayo";
			break;
		case "06":
			$var = "Junio";
			break;
		case "07":
			$var = "Julio";
			break;
		case "08":
			$var = "Agosto";
			break;
		case "09":
			$var = "Septiembre";
			break;
		case "10":
			$var = "Octubre";
			break;
		case "11":
			$var = "Noviembre";
			break;
		case "12":
			$var = "Diciembre";
			break;
		
			
		}

		
$query1 = "select A.*,B.nombre as codcomuna from clientes A left join comuna B on A.comuna = B.codigo where rut= '".$rutCliente."'";
$result1 = mysqli_query($con,$query1);
while($row1 = mysqli_fetch_array($result1)){
	$rsocialcliente = $row1['razon_social'];
	$rcliente = $row1['rut'];
	$direccioncliente = $row1['direccion'];
	$comunacliente = $row1['codcomuna'];
	$girocliente = $row1['giro_comercial'];
	$fonocliente = $row1['telefonos'];
}


$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($señor),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,"R.U.T: ".$rut_empresa,'RLT',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,'','RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,utf8_decode('FACTURA ELECTRÓNICA'),'RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($direccion_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,'','RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($id_boleta),10)."",'RLB',1,'C');




$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($contacto_empresa),0,1,'c');
$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetX(200);

$pdf->Cell(60,15,utf8_decode('SANTIAGO:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,$dia,'B',0,'C');
$pdf->SetX(320);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(140,15,$var,'B',0,'C');
$pdf->SetX(500);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,$anio,'B',0,'c');


$pdf->Ln(30);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($rsocialcliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('R.U.T:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($rcliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Dirección:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($direccioncliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Comuna:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($comunacliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Giro:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($girocliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Fono:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($fonocliente),'B',0,'c');

$pdf->Ln(35);

	$pdf->Ln(4);
	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	
	$w = array(20, 50, 230,45, 80, 50, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "SELECT A.*, C.descripcion AS 'DES_CATEGORIA', D.descripcion AS 'DES_MARCA', b.cantidad, b.precio,b.descuento,v.factura AS num_boleta,b.id AS boleta_det_id, 
	(A.pmp+(A.factor_gral_pv*A.pmp)/100) AS precio_venta FROM productos A LEFT JOIN categorias C ON A.categoria_id=C.ID LEFT JOIN marcas D ON A.marca_id=D.ID LEFT JOIN 
	stock s ON A.id=s.producto_id LEFT JOIN factura_det b ON A.id=b.producto_id LEFT JOIN factura v ON b.factura_id=v.factura WHERE v.factura=".$id_boleta." GROUP BY b.producto_id;";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;                  
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode($row["especificaciones"]), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                     
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}

	$pdf->Ln(10);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'MONTO NETO','LT',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($netot, 0, ",", "."),'RT',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'DESCUENTO','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($desct, 0, ",", ".").'%','R',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'IVA 19%','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($ivat, 0, ",", "."),'R',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($montot, 0, ",", "."),'RB',0,'R');
	

$pdf->Output();
}

//<<<<<<<<<<<<<<<<<<<<DOCUMENTO ORDEN DE COMPRA >>>>>>>>>>>>>>>>>>

if(isset($_REQUEST['ord_num'])){
        $orden = base64_decode($_REQUEST['ord_num']);
        $sqlNumBoleta = "SELECT compra FROM compras1 WHERE compra=".$orden.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaCompra', B.rut, B.razon_social, B.contacto FROM compras1 A LEFT JOIN proveedores B ON A.id_proveedor=B.id WHERE A.compra=".trim($orden).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$fechaBoleta=$row["FechaCompra"];
		$factura=$row["factura"];
		$estado=$row["estado"]; 
		$nroBoleta=$row["compra"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observacion=$row["condiciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}
if($estado == 0){
	$estado_ = "Por Aprobar";
}else{
	$estado_ = "Aprobada";
}


$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: ".$rut_empresa,'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("ORDEN DE COMPRA"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);
$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$hora,0,1,'L');
$pdf->Ln(4);
$pdf->SetFont('Arial','B',7);

$pdf->Cell(220,12,'CONDICIONES:'."",1,0,'L');
$pdf->Cell(100,12,'Factura:  '.$factura,1,0,'L');
$pdf->Cell(145,12,'Guia De Despacho:  ',1,0,'L');
$pdf->SetFont('Arial','',7);
$pdf->Cell(30,12,'Estado:','LTB',0,'C');
$pdf->SetFont('Arial','B',7);
$pdf->SetTextColor(234, 8, 8);
$pdf->Cell(60,12,$estado_,'TRB',0,'C');
$pdf->Ln(20);
$pdf->SetTextColor(0, 0, 0);

	$pdf->Ln(4);

	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Total", "Bodega");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 60, 50, 100);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones, c.descripcion as bodega, b.codigo_externo from compras_detalle1 a join productos b on a.producto_id=b.id join bodegas c on a.bodega_id = c.id where compra_id = ".$orden.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                   
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["costo_unit"], 0, ",", "."), 'LRB',0, 'C');
				
			$pdf->Cell($w[5], $yH, number_format($row["costo_total"], 0, ",", "."), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, strtoupper($row["bodega"]), 'LRB', 0, 'C');		                                   
			$tneto += $row['costo_total'];
			$tiva  = round($tneto*19/100);
			$ttotal = $tneto + $tiva; 
						
			$pdf->Ln();
		}
	}

	$pdf->Ln(10);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'SUBTOTAL                $','LT',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($tneto, 0, ",", "."),'RT',0,'R');	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'IVA                             $','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($tiva, 0, ",", "."),'R',0,'R');
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'VALOR TOTAL          $','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($ttotal, 0, ",", "."),'RB',0,'R');
	/*
	$pdf->Image('images/codigoboleta.png',40,500,120,0,'');
	$pdf->SetY(565);
	$pdf->Cell(150,10,utf8_decode("Timbre Electrónico SII"),'',2,'C');
		$pdf->Cell(150,10,"www.sii.cl",'',2,'C');*/
	
	$pdf->Ln(40);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(100,20,'OBSERVACION:','B',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,$observacion,'B',0,'R');

//
$pdf->Output();
}



//<<<<<<<<<<<<<<<<<<<<DOCUMENTO GUIA DE DESPACHO >>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['guia_num'])){
        $guia = base64_decode($_REQUEST['guia_num']);
         $sqlNumGuia = "SELECT guia FROM guia WHERE guia=".$guia.";";
        $result1 = mysqli_query($con,$sqlNumGuia);
        $fila1 = mysqli_fetch_array($result1);
  
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', B.rut, B.razon_social FROM guia A LEFT JOIN clientes B ON A.cliente_id=B.id WHERE A.guia=".trim($guia).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$fechaBoleta=$row["FechaBoleta"];
		$nroGuia=$row["guia"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}


list($dia,$mes,$anio) = explode('/',$fechaBoleta);
			
			$nyear = substr($anio, -2);
			
		switch($mes) 
		{
		case "01":
			$var = "Enero";
			break;
		case "02":
			$var = "Febrero";
			break;
		case "03":
			$var = "Marzo";
			break;
		case "04":
			$var = "Abril";
			break;
		case "05":
			$var = "Mayo";
			break;
		case "06":
			$var = "Junio";
			break;
		case "07":
			$var = "Julio";
			break;
		case "08":
			$var = "Agosto";
			break;
		case "09":
			$var = "Septiembre";
			break;
		case "10":
			$var = "Octubre";
			break;
		case "11":
			$var = "Noviembre";
			break;
		case "12":
			$var = "Diciembre";
			break;
		
			
		}

		
$query1 = "select A.*,B.nombre as codcomuna from clientes A left join comuna B on A.comuna = B.codigo where rut= '".$rutCliente."'";
$result1 = mysqli_query($con,$query1);
while($row1 = mysqli_fetch_array($result1)){
	$rsocialcliente = $row1['razon_social'];
	$rcliente = $row1['rut'];
	$direccioncliente = $row1['direccion'];
	$comunacliente = $row1['codcomuna'];
	$girocliente = $row1['giro_comercial'];
	$fonocliente = $row1['telefonos'];
}


$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($señor),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,"R.U.T: ".$rut_empresa,'RLT',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,'','RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,utf8_decode('GUIA DE DESPACHO'),'RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($direccion_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,15,'','RL',1,'C');

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetX(380);

//Numero Documento
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroGuia),10)."",'RLB',1,'C');




$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(250,15,utf8_decode($contacto_empresa),0,1,'c');
$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetX(200);

$pdf->Cell(60,15,utf8_decode('SANTIAGO:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,$dia,'B',0,'C');
$pdf->SetX(320);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(140,15,$var,'B',0,'C');
$pdf->SetX(500);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,$anio,'B',0,'c');


$pdf->Ln(30);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($rsocialcliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('R.U.T:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($rcliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Dirección:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($direccioncliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Comuna:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($comunacliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Giro:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($girocliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Fono:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($fonocliente),'B',0,'c');

$pdf->Ln(30);
$pdf->SetFont('Arial','B',7);

$pdf->Cell(220,12,'SIRVASE RECIBIR CONFORME LA SIGUIENTE MERCADERIA'."",1,0,'L');
$pdf->Ln(15);


	$pdf->Ln(4);
	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	
	$w = array(20, 50, 280,45, 80, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "SELECT A.*, C.descripcion AS 'DES_CATEGORIA', D.descripcion AS 'DES_MARCA', b.cantidad, b.precio,b.descuento,v.guia AS num_boleta,b.id AS boleta_det_id,v.iva,v.neto,v.monto_total, 
	(A.pmp+(A.factor_gral_pv*A.pmp)/100) AS precio_venta FROM productos A LEFT JOIN categorias C ON A.categoria_id=C.ID LEFT JOIN marcas D ON A.marca_id=D.ID LEFT JOIN 
	stock s ON A.id=s.producto_id LEFT JOIN guia_det b ON A.id=b.producto_id LEFT JOIN guia v ON b.guia_id=v.guia WHERE v.guia=".$guia." GROUP BY b.producto_id;
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;                  
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode($row["especificaciones"]), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
		
			$pdf->Cell($w[5], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                     
			$tneto = $row['neto'];
			$tiva  = $row['iva'];
			$ttotal = $row['monto_total'];
						
			$pdf->Ln();
		}
	}

	$pdf->Ln(10);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'MONTO NETO','LT',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($tneto, 0, ",", "."),'RT',0,'R');
	
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'IVA 19%','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($tiva, 0, ",", "."),'R',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($ttotal, 0, ",", "."),'RB',0,'R');
	

$pdf->Output();
}

//<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO TRASPASOS >>>>>>>>>>>>>>>>>>>>>

if(isset($_REQUEST['trasp_num'])){
        $traspaso = base64_decode($_REQUEST['trasp_num']);
        $sqlNumBoleta = "SELECT traspaso FROM traspaso WHERE traspaso=".$traspaso.";";
        $result4 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result4);	
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";

$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS fechatraspaso, C.nombre as nombreuser FROM traspaso A 
			join usuarios C on A.usuario = C.id WHERE A.traspaso =".$traspaso.";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$fechaTrasp=$row["fechatraspaso"];
		$bodega1=$row["bodega1_id"];
		$bodega2=$row["bodega2_id"];
		$autorizador=$row["nombreuser"];
		$observacion= $row["descripcion"];
	}

}
$query1 = "select descripcion from bodegas where id = $bodega1";	
$result1 = mysqli_query($con,$query1);	
while ($row1 = mysqli_fetch_array($result1))
	{
		$bod1 = $row1['descripcion'];
	}
	
$query2 = "select descripcion from bodegas where id = $bodega2";	
$result2 = mysqli_query($con,$query2);	
while ($row2 = mysqli_fetch_array($result2))
	{
		$bod2 = $row2['descripcion'];
	}


$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);

$pdf->Cell(200,12,"",'TRL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("TRASPASO"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($traspaso),5)."",'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'LRB',1,'L');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);

$pdf->Ln(10);
$pdf->Cell(300,13,utf8_decode("Fecha: ".$fechaTrasp.""),'LRBT',1,'L');
$pdf->Cell(300,13,utf8_decode("Autorizado Por: ".$autorizador.""),'LRB',1,'L');
$pdf->Cell(300,13,utf8_decode("Bodega Origen: ".$bod1.""),'LRB',1,'L');
$pdf->Cell(300,13,utf8_decode("Bodega Destino: ".$bod2.""),'LRB',1,'L');

$pdf->Ln(10);

	$pdf->Ln(10);
	
	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 130, 345,65);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "SELECT A.*, b.cantidad, v.traspaso AS num_boleta,b.id AS boleta_det_id FROM productos A JOIN traspaso_det b ON A.id=b.producto_id JOIN 
	traspaso v ON b.traspaso_id=v.traspaso WHERE v.traspaso =".$traspaso." GROUP BY b.id;";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                   
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode($row["especificaciones"]), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');					                              
			$suma=$suma+$row["precio"];						
			$pdf->Ln();
		}
	}

	$pdf->Ln(40);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(100,20,'OBSERVACION:','B',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,$observacion,'B',0,'R');
	
$pdf->Output();
}



//Anular Boletas
//Anular Boletas
if(isset($_REQUEST['bolet_num_null'])){
	
	
	    $idboleta = base64_decode($_REQUEST['bolet_num_null']);
        $sqlNumBoleta = "SELECT notacredito FROM nota_credito WHERE id=".$idboleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
	
	
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaNota', B.rut,C.descripcion as tipooper, B.razon_social FROM nota_credito A LEFT JOIN clientes B ON A.cliente_id=B.id join tipo_operacion C on A.operacion = C.id WHERE A.id=".trim($idboleta).";";
$observaciones="";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$id = $row["id"];
		$fechanotacr=$row["FechaNota"];
		$tipodoc=$row["tipo_doc"];
		$netot=$row["neto"];
		$ivat=$row["iva"];
		$montot=$row["monto_total"];
		if($row["operacion"]==1){
			$operacion='Anulación de Documento';
		}else if($row["operacion"]==2){
			$operacion='Devolución de Productos';
		}else{
			$operacion='';
		}
		$horanotacr=$row["hora"];
		$id_notacr=$row["notacredito"];
		$nroBoleta=$row["num_doc"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: 76.317.144-2",'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("NOTA DE CRÉDITO"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N° ").right("00000".trim($id_notacr),5)." - ".utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);
// Referencia Empresa
$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',7);
$pdf->Cell(60,12,utf8_decode('Fecha Emisión: '),0,0,'L');


$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$fechanotacr,0,1,'LR');

$pdf->SetFont('Arial','B',7);
$pdf->Cell(60,12,utf8_decode('Hora Emisión: '),0,0,'L');

$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$horanotacr,0,1,'LR');



$pdf->SetFont('Arial','',7);
$pdf->Cell(220,12,$hora,0,1,'L');
$pdf->Ln(4);

$pdf->SetFont('Arial','B',9);
$pdf->Cell(90,12,utf8_decode('Tipo de Operación: '),0,0,'L');
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','B',9);
$pdf->Cell(220,12,utf8_decode($operacion),0,1,'L');

$pdf->Ln(4);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('Arial','B',7);
if($tipodoc == 'B'){
	$pdf->Cell(60,12,utf8_decode('Documento Que Modifica Boleta N°: ').right("00000".trim($nroBoleta),10)."",0,0,'L');
}else if($tipodoc == 'F'){
	$pdf->Cell(60,12,utf8_decode('Documento Que Modifica Factura N°: ').right("00000".trim($nroBoleta),10)."",0,0,'L');
}else if($tipodoc == 'I'){
	$pdf->Cell(60,12,utf8_decode('Documento Que Modifica Boleta Interna N°: ').right("00000".trim($nroBoleta),10)."",0,0,'L');
}
	
	

$pdf->SetFont('Arial','',7);

$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(10);
	$pdf->Ln(4);

	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 80, 50, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones,b.psale as precio_venta, b.codigo_externo from nota_credito_det a join productos b on a.producto_id=b.id where notacredito_id = ".$idboleta.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}

$pdf->Ln(10);	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'MONTO NETO','LT',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($netot, 0, ",", "."),'RT',0,'R');
	
	$pdf->Ln(16);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'IVA 19%','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($ivat, 0, ",", "."),'R',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($montot, 0, ",", "."),'RB',0,'R');

$pdf->Output();
	
	
	
}



//<<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO COTIZACION >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['cot_num'])){
        $idboleta = $_REQUEST['cot_num'];
        $sqlNumBoleta = "SELECT cotizacion FROM cotizacion WHERE id=".$idboleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    	
		$fec_hoy = FechaActual_Server();
		$hor_hoy = HoraActual_Server();
		$fec1 = f_retorna_fecha_mysql( $fecIni );
		$fec2 = f_retorna_fecha_mysql( $fecTer );

$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', B.rut,C.nombre as user, B.razon_social FROM cotizacion A LEFT JOIN 
clientes B ON A.cliente_id=B.id join usuarios C on A.usuario = C.id WHERE A.id=".trim($idboleta).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$id = $row["id"];
		$fechaBoleta=$row["FechaBoleta"];
		$nroBoleta=$row["cotizacion"];
		$netot=$row["neto"];
		$ivat=$row["iva"];
		$montot=$row["monto_total"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		$usuario=$row["user"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		

 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);


$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);

$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: ".$rut_empresa,'RLT',1,'C');

$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("COTIZACIÓN"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);

$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->SetFont('Arial','B',9);
$pdf->Cell(100,15,utf8_decode('Fecha Cotización:'),0,0,'0');
$pdf->SetFont('Arial','',9);
$pdf->Cell(110,15,$fechaBoleta,0,1,'c');

$pdf->SetFont('Arial','B',9);
$pdf->Cell(100,15,'Usuario:',0,0,'0');
$pdf->SetFont('Arial','',9);
$pdf->Cell(110,15,utf8_decode($usuario),0,1,'c');

	$pdf->Ln(4);

	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", utf8_decode("% Descuento"), "Total", "Imagen");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 70, 230,75, 50, 50,60,20);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.imagen_prod,b.especificaciones,b.psale_c_iva as precio_venta, b.codigo_externo from cotizacion_det a join productos b on a.producto_id=b.id where cotizacion_id = ".$idboleta.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		$image_height = 20;
		$image_width = 20;
		while ($row = mysqli_fetch_array($result))
		{
			$i++;
			$precioprod = round($row["precio"]/$row["cantidad"]);
			//$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
			$documento = 'images/productos/'.$row['imagen_prod'];			     	
			$start_x = $pdf->GetX();
			$start_y = $pdf->GetY();
		
			
			  
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($precioprod, 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[5], $yH, number_format($row["descuento"], 0, ",", "."), 'LRB',0, 'C');

			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		
			$pdf->Image($documento, $pdf->GetX(), $pdf->GetY() ,$image_height, $image_width) ;
			$pdf->SetXY( $start_x , $start_y + $image_width + 10);
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}
$sql = "select estado_iva from documentos_iva";
$res = mysqli_query($con,$sql);
while($rw = mysqli_fetch_array($res)){
	$estadoiva = $rw['estado_iva'];
}


	$pdf->Ln(10);
	
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'MONTO NETO','LT',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($netot, 0, ",", "."),'RT',0,'R');
	
	/*
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'DESCUENTO','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($desct, 0, ",", ".").'%','R',0,'R');
	*/
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'IVA 19%','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($ivat, 0, ",", "."),'R',0,'R');
	
	$pdf->Ln(16);
	$pdf->SetFont('Arial','B',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($montot, 0, ",", "."),'RB',0,'R');

	

	
$pdf->Output();

}

//Comprobante de Pago Tesorería
//$pdf=new FPDF('P','mm',array(70,120));

if(isset($_REQUEST['compr_id'])){


/*$id_comprbte = $_REQUEST['compr_id'];
	
$sql = "select a.*,DATE_FORMAT(a.fecha_comprobante,'%d/%m/%Y')AS fecha_comprob,b.emitido_doc_por, b.num_doc as numerodocumento from comprobante_cpp a join cuentas_por_pagar b on a.id_cpp = b.id 
	where a.id = $id_comprbte";
$res = mysqli_query($con,$sql);
while($rw = mysqli_fetch_array($res)){
	$numcomprbte = $rw['num_comprobante'];
	$nrodocumento = $rw['numerodocumento'];
	$fechacomprbte = $rw['fecha_comprob'];
	$emitido = $rw['emitido_doc_por'];
	$numcuota = $rw['num_cuota_cpp'];
	$valor = $rw['valor_comprobante'];
	$observacion = $rw['obs_comprobante'];
}
	
$pdf=new FPDF('P','pt','Letter');

		
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetFont('Arial','B',11);
$pdf->Ln(30);
$pdf->Cell(100,20,utf8_decode('COMPROBANTE 	N° '.$numcomprbte),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('Fecha Comprobante: '.$fechacomprbte),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('N° Documento: '.$nrodocumento),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('Emitido Por: '.$emitido),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('N° Cuota Abonada: '.$numcuota),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('Valor Total Abonado: '.$valor),0,0,'1');
$pdf->Ln(25);
$pdf->SetFont('Arial','',10);
$pdf->Cell(100,20,utf8_decode('Observación: '.$observacion),0,0,'1');

$pdf->Output();
*/

























$id_comprbte = $_REQUEST['compr_id'];

$pdf=new FPDF('P','pt','Letter');

// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$sql = "select a.*,DATE_FORMAT(a.fecha_comprobante,'%d/%m/%Y')AS fecha_comprob,d.condicion as medpago,b.emitido_doc_por, b.num_doc as numerodocumento,c.descripcion as tipodocumentos from comprobante_cpp a join 
cuentas_por_pagar b on a.id_cpp = b.id join tipo_documentos c on b.tipo_doc = c.id join condicion_pago d on a.forma_pago = d.id
	where a.id = $id_comprbte";
$res = mysqli_query($con,$sql);
while($rw = mysqli_fetch_array($res)){
	$numcomprbte = $rw['num_comprobante'];
	$nrodocumento = $rw['numerodocumento'];
	$fechacomprbte = $rw['fecha_comprob'];
	$emitido = $rw['emitido_doc_por'];
	$numcuota = $rw['num_cuota_cpp'];
	$valor = $rw['valor_comprobante'];
	$observacion = $rw['obs_comprobante'];
	$tipodoc = $rw['tipodocumentos'];
	$mediopago = $rw['medpago'];
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Image($logo_empresa,30,10,100,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: 76.317.144-2",'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("COMPROBANTE DE PAGO"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N° ").right("00000".trim($numcomprbte),10),'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);
// Referencia Empresa
$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Emitido Por: '),0,0,'L');


$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$emitido,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('N° Documento: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$nrodocumento,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Tipo Documento: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$tipodoc,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$horanotacr,0,1,'LR');



$pdf->SetFont('Arial','',7);
$pdf->Cell(220,12,$hora,0,1,'L');
$pdf->Ln(4);


$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(10);
	$pdf->Ln(4);

	$encabezado = array("Fecha Comprobante", utf8_decode("N° Cuota abonada"), "Medio De Pago", "Valor Total Comprobante");
	$alineacion = array("C", "C", "C", "C");
			
	$w = array(110, 120, 230,95);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);

				                 
			$pdf->Cell($w[0], $yH, $fechacomprbte, 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $numcuota, 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, $mediopago, 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($valor, 0, ",", "."), 'LRB',0, 'C');
	
						
			$pdf->Ln();
		
	

$pdf->Ln(30);	


	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(60,20,'OBSERVACION:','B',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,$observacion,'B',0,'R');

$pdf->Output();
	
}



//Venta Interna
//<<<<<<<<<<<<<<<<<<<<<<<<<< DOCUMENTO BOLETA POS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if(isset($_REQUEST['vint_id'])){
        $idboleta = base64_decode($_REQUEST['vint_id']);

        $sqlNumBoleta = "SELECT boleta FROM venta_interna_pos WHERE id=".$idboleta.";";
        $result1 = mysqli_query($con,$sqlNumBoleta);
        $fila1 = mysqli_fetch_array($result1);
    
$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";
$query = "SELECT A.*,A.rut as clienterut,A.marca_nombre,A.modelo_nombre,A.nombre as namecliente,A.telefono as telcliente, D.descripcion as desc_marca,E.descripcion as desc_modelo, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta', DATE_FORMAT(A.fecha_entrega,'%d/%m/%Y') AS 'fecha_ent',C.nombre as tecnico FROM venta_interna_pos A 
LEFT JOIN clientes B ON A.cliente_id=B.id LEFT JOIN usuarios C on A.tecnico_id = C.id left join marcas D on A.marca_id = D.id left join modelos E on A.modelo_id = E.id  WHERE A.id=".trim($idboleta).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$id = $row["id"];
		$fechaBoleta=$row["FechaBoleta"];
		$horaBoleta=$row["hora"];
		$fecha_entrega=$row["fecha_ent"];
		$hora_entrega=$row["hora_entrega"];
		$nroBoleta=$row["boleta"];
		$rutCliente=$row["clienterut"];
		$nombreCliente=$row["namecliente"];
		$telefono=$row["telcliente"];
		$observaciones_falla=$row["observaciones_falla"];
		$observaciones_gen=$row["observaciones_generales"];
		$marca_id = $row["desc_marca"];
		$marca_nombre = $row["marca_nombre"];
		$modelo_id = $row["desc_modelo"];
		$modelo_nombre = $row["modelo_nombre"];
		$imei = $row["imei"];
		$memoria = $row["memoria"];
		$bateria = $row["bateria"];
		$cargador = $row["cargador"];
		$chip = $row["chip"];
		$func_pantalla = $row["func_pantalla"];
		$func_tactil = $row["func_tactil"];
		$golpes=$row["golpes"];
		$cam_del = $row["cam_del"];
		$cam_tr = $row["cam_tr"];
		$humedad = $row["humedad"];
		$encendido = $row["encendido"];
		$tecnico = $row["tecnico"];
		$estado = $row['confirmada'];
		$pagada = $row['pagada'];
		$observaciones_finales = $row['observaciones_finales'];
		$tecnico_reparacion = $row['tecnico_reparacion'];
		$valor_total = $row['neto'];
		
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}

if($marca_id == "OTRO"){
	$marca = $marca_nombre;
}else{
	$marca = $marca_id;
}

if($modelo_id == "OTRO"){
	$modelo = $modelo_nombre;
}else{
	$modelo = $modelo_id;
}

if($estado == 2){
	$estado_ = "Pendiente";
}else{
	$estado_ = "Confirmada";
}

if($pagada == 2){
	$estado_pago = "Confirmado";
}else if($pagada == 1){
	$estado_pago = "Pendiente";
}
		
list($dia,$mes,$anio) = explode('/',$fechaBoleta);
			
			$nyear = substr($anio, -2);
			
		switch($mes) 
		{
		case "01":
			$var = "Enero";
			break;
		case "02":
			$var = "Febrero";
			break;
		case "03":
			$var = "Marzo";
			break;
		case "04":
			$var = "Abril";
			break;
		case "05":
			$var = "Mayo";
			break;
		case "06":
			$var = "Junio";
			break;
		case "07":
			$var = "Julio";
			break;
		case "08":
			$var = "Agosto";
			break;
		case "09":
			$var = "Septiembre";
			break;
		case "10":
			$var = "Octubre";
			break;
		case "11":
			$var = "Noviembre";
			break;
		case "12":
			$var = "Diciembre";
			break;
		
			
}
$query1 = "select A.*,B.nombre as codcomuna from clientes A left join comuna B on A.comuna = B.codigo where rut= '".$rutCliente."'";
$result1 = mysqli_query($con,$query1);
while($row1 = mysqli_fetch_array($result1)){
	$rsocialcliente = $row1['razon_social'];
	$rcliente = $row1['rut'];
	$direccioncliente = $row1['direccion'];
	$comunacliente = $row1['codcomuna'];
	$girocliente = $row1['giro_comercial'];
	$fonocliente = $row1['telefonos'];
}

// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);

$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(150);
$pdf->SetFont('Arial','',7);
$pdf->Cell(50,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: ".$rut_empresa,'RLT',1,'C');



$pdf->SetX(150);
$pdf->SetFont('Arial','',7);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(150);

$pdf->SetX(150);
$pdf->SetFont('Arial','',7);
$pdf->Cell(50,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,utf8_decode("ORDEN DE SERVICIO"),'RL',1,'C');
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('Arial','',7);
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(150);
$pdf->SetFont('Arial','',7);
$pdf->Cell(50,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');



$pdf->SetTextColor(234, 8, 8);
$pdf->SetFont('Arial','',12);
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetTextColor(0, 0, 0);

$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(70,15,'Fecha Ingreso:','LTB',0,'0');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,$fechaBoleta,'RTB',0,'0');
$pdf->SetFont('Arial','',7);
$pdf->SetX(150);
$pdf->Cell(50,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->Cell(60,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',7);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');




$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(70,15,'Hora Ingreso:','LTB',0,'0');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,$horaBoleta,'RTB',0,'0');

$pdf->SetX(150);
$pdf->SetFont('Arial','',7);
$pdf->Cell(50,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');


$pdf->Ln(5);

//$pdf->SetX(200);
/*
$pdf->Cell(60,15,utf8_decode('SANTIAGO:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,$dia,'B',0,'C');
$pdf->SetX(320);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(140,15,$var,'B',0,'C');
$pdf->SetX(500);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,utf8_decode('DE'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(30,15,$anio,'B',0,'c');
*/



$pdf->Ln(10);
$pdf->SetFont('Arial','',8);
$pdf->Cell(60,12,'Estado Pago:','LTB',0,'C');
$pdf->SetFont('Arial','B',8);
$pdf->SetTextColor(234, 8, 8);
$pdf->Cell(60,12,$estado_pago,'TRB',0,'C');
$pdf->Ln(12);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('Arial','',8);
$pdf->Cell(60,12,'Estado Entrega:','LTB',0,'C');
$pdf->SetFont('Arial','B',8);
$pdf->SetTextColor(234, 8, 8);
$pdf->Cell(60,12,$estado_,'TRB',0,'C');
$pdf->Ln(15);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Cliente:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(180,15,utf8_decode(strtoupper($nombreCliente)),'B',0,'c');
$pdf->SetX(300);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('RUT:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(90,15,utf8_decode($rutCliente),'B',0,'c');

$pdf->SetX(450);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Fono:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode($telefono),'B',0,'c');


$pdf->Ln(25);
$encabezado1 = array("MARCA", "MODELO", utf8_decode("IMEI"),"MEMORIA", "BATERIA", "CARGADOR", "CHIP");
	$alineacion1 = array("C", "C", "C", "C", "C", "C","C");
			
	$w1 = array(80, 80, 80,80, 80, 80, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado1); $i++) {
		$pdf->Cell($w1[$i], 14, $encabezado1[$i], 1, 0, $alineacion1[$i]);
	}
	
	
	$pdf->Ln(14);
	$encabezado2 = array("", "", "","SI", "NO", "SI", "NO", "SI", "NO", "SI", "NO");
	$alineacion2 = array("C", "C", "C", "C", "C", "C","C", "C","C", "C","C");
	$w2 = array(80, 80, 80, 40,40, 40,40, 40,40,40,40);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado2); $i++) {
		if($i>=3){
		$pdf->Cell($w2[$i], 14, $encabezado2[$i], 1, 0, $alineacion2[$i]);
		}else if($i==0){
			$pdf->Cell($w2[$i], 14, $encabezado2[$i], 'LB', 0, $alineacion2[$i]);
		}else{
		$pdf->Cell($w2[$i], 14, $encabezado2[$i], 'B', 0, $alineacion2[$i]);
		}
	}
	$pdf->Ln(14);
	$encabezado3 = array($marca, $modelo, utf8_decode($imei),"MEMORIA", "", "", "", "", "", "", "");
	$alineacion3 = array("C", "C", "C", "C", "C", "C","C", "C", "C", "C","C");
			
	$w3 = array(80, 80, 80, 40,40, 40,40, 40,40,40,40) ; // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','',7);
	for($i = 0; $i < count($encabezado3); $i++) {
		 if($i==3){
			if($memoria==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			
		 }else if($i==4){
			if($memoria==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			
		 }else if($i==5){
			if($bateria==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else if($i==6){
			if($bateria==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else if($i==7){
			if($cargador==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else if($i==8){
			if($cargador==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else if($i==9){
			if($chip==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else if($i==10){
			if($chip==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado3[$i] = $check;
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
			}
			 
		 }else{
			 $pdf->SetFont('Arial','',7);
			$pdf->Cell($w3[$i], 14, $encabezado3[$i], 1, 0, $alineacion3[$i]);
		 }
	}
	
	
	$pdf->Ln(20);
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(170,20,'FALLA REPORTADA POR EL CLIENTE','',0,'1');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(350,20,utf8_decode($observaciones_falla),'B',0,'1');
	$pdf->Ln(20);
	/*
	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 80, 50, 85);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones,b.psale_c_iva as precio_venta, b.codigo_externo from venta_interna_det_pos a join productos b on a.producto_id=b.id where boleta_id = ".$idboleta.";";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}*/


	
$pdf->Ln(10);



$pdf->SetFont('Arial','B',8);
	$pdf->SetTextColor(53, 104, 45);
	$pdf->SetX(413);
	$pdf->Cell(105,20,'VALOR TOTAL','TLB',0,'1');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,20,number_format($valor_total, 0, ",", "."),'TRB',0,'R');
	$pdf->Ln(25);
	$encabezado4 = array("FUNC PANTALLA", "FUNC TACTIL", utf8_decode("GOLPES"),"CAM DELANTERA", "CAM TRASERA", "HUMEDAD", "PRENDIDO","APAGADO");
	$alineacion4 = array("C", "C", "C", "C", "C", "C","C");
			
	$w4 = array(80, 80, 60,80, 80, 80, 50,50);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetTextColor(0, 0, 0);
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado4); $i++) {
		$pdf->Cell($w4[$i], 14, $encabezado4[$i], 1, 0, $alineacion4[$i]);
	}
	
	
	$pdf->Ln(14);
	$encabezado5 = array("SI", "NO","SI", "NO","", "SI", "NO", "SI", "NO", "SI", "NO", "SI", "NO");
	$alineacion2 = array("C", "C", "C", "C", "C", "C","C", "C","C", "C","C", "C","C");
	$w5 = array(40,40, 40,40, 60,40,40,40,40,40,40,50,50);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado5); $i++) {
	
		$pdf->Cell($w5[$i], 14, $encabezado5[$i], 1, 0, $alineacion2[$i]);
	
	}
	$pdf->Ln(14);
	
	$encabezado6 = array("", "","", "",$golpes, "", "", "", "", "", "", "", "");
	$alineacion6 = array("C", "C", "C", "C", "C", "C","C", "C","C", "C","C", "C","C");
	$w6 = array(40,40, 40,40, 60,40,40,40,40,40,40,50,50);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','',7);
	for($i = 0; $i < count($encabezado6); $i++) {
	
		if($i==0){
			
			if($func_pantalla==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==1){
			
			if($func_pantalla==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==2){
			
			if($func_tactil==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==3){
			
			if($func_tactil==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==5){
			
			if($cam_del==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==6){
			
			if($cam_del==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==7){
			
			if($cam_tr==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==8){
			
			if($cam_tr==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==9){
			
			if($humedad==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==10){
			
			if($humedad==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==11){
			
			if($encendido==1){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else if($i==12){
			
			if($encendido==0){
			$check = "4";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}else{
			$check = "";
			$pdf->SetFont('ZapfDingbats','', 10);
			$encabezado6[$i] = $check;
			$pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
			}
		 }else{
			 $pdf->SetFont('Arial','',7);
			 $pdf->Cell($w6[$i], 14, $encabezado6[$i], 1, 0, $alineacion6[$i]);
		 }
	
	}
	
	
	$pdf->Ln(20);
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(170,20,'OBSERVACIONES GENERALES DEL EQUIPO','',0,'1');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(350,20,utf8_decode($observaciones_gen),'B',0,'1');
	$pdf->Ln(20);
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(170,20,utf8_decode('TÉCNICO QUE REALIZA EL DIAGNOSTICO'),'',0,'1');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(350,20,utf8_decode($tecnico),'',0,'1');
	
	$pdf->Ln(20);
	$pdf->SetTextColor(234, 8, 8);
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(560,15,'REPARACION',1,0,'1');
	$pdf->Ln(15);
	$sql5 = "select nombre from usuarios where id = $tecnico_reparacion";
	$res5 = mysqli_query($con,$sql5);
	while($rw5 = mysqli_fetch_array($res5)){
		$tecnico_r = $rw5['nombre'];
	}
	$pdf->Ln(10);
	//053-104-045
	$pdf->SetTextColor(0, 0, 0);
	$pdf->SetFont('Arial','B',7);

	$pdf->Cell(170,20,utf8_decode('OBSERVACIONES FINALES DE REPARACION'),'',0,'1');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(350,20,utf8_decode($observaciones_finales),'B',0,'1');
	$pdf->Ln(20);
	
	$pdf->SetFont('Arial','B',7);
	$pdf->Cell(170,20,'TECNICO QUE REALIZA EL SERVICIO','',0,'1');
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(350,20,utf8_decode($tecnico_r),'',0,'1');
	$pdf->Ln(20);
	$pdf->SetFont('Arial','B',9);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Cell(80,15,'Fecha Entrega:','LT',0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Cell(80,15,$fecha_entrega,'RT',0,'0');
	$pdf->Ln(15);
	$pdf->SetFont('Arial','B',9);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Cell(80,15,'Hora Entrega:','LTB',0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->SetTextColor(0, 0, 0);
	$pdf->Cell(80,15,$hora_entrega,'RTB',0,'0');
	
	
		$pdf->Ln(25);
		$pdf->SetFont('Arial','',5.7);
		$pdf->Cell(80,1,utf8_decode('1- NO SE DA GARANTÍA POR CAMBIOS DE CRISTALES Y/O GORILA GLASS EN CASO DE QUE QUEDE LA PANTALLA NEGRA O NO FUNCIONE EL TOUCH, NI POR PANTALLA SIN IMAGEN O PIXELADA.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('2- GSM-PHONE NO SE HACE RESPONSABLE DEL IMEI INTERNO DE LOS EQUIPOS QUE NO PERMITAN SER CONFIRMADOS EN EL MOMENTO DEL INGRESO, NI POR EQUIPO QUE NO ENCIENDAN O'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('    CON PROBLEMAS DE SOFTWARE O IMAGEN.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('3- TODO EQUIPO DESPUÉS DE RETIRADO Y QUE PRESENTE RASTROS DE HUMEDAD, GOLPES, MALTRATOS O MANIPULACIÓN INDEBIDA NO TIENE GARANTÍA DE REPARACIÓN Y SE CORRE EL RIESGO'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('    DE QUE EL APARATO SE APAGUE DEFINITIVAMENTE O EMPEORE SU ESTADO AL TRATAR DE REPARARLO.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('4- NO NOS HACEMOS RESPONSABLES POR EQUIPOS INCAUTADOS POR LAS AUTORIDADES COMPETENTES, NI POR EQUIPOS AFECTADOS POR ROBOS, INCENDIOS Y/O DEMÁS SINIESTROS'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('    QUE PUEDAN OCURRIR EN NUESTRO ESTABLECIMIENTO.'),0,0,'0');
		
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('5- TODO SERVICIO Y/O REPUESTO TIENE TREINTA (30) DÍAS DE GARANTÍA Y ES ÚNICAMENTE  SOBRE LA REPARACIÓN EFECTUADA.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('6- EQUIPOS QUE NO SEAN RETIRADOS DESPUÉS DE 15 DÍAS, TENDRÁN UN RECARGO DE 50% DEL VALOR TOTAL DEL SERVICIO FIRMADO Y EL 100% DESPUÉS DE 30 DÍAS.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('7- EL CLIENTE SE HACE RESPONSABLE DE LA PROCEDENCIA DE LOS EQUIPOS.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('8- SI TRAE SU EQUIPO APAGADO Y NO HAY MANERA DE REVISAR QUE ESTÉ FUNCIONANDO, DAMOS GARANTÍA POR EL PRODUCTO O REPUESTO INSTALADO ÚNICAMENTE.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('9- NO NOS HACEMOS RESPONSABLES DE MEMORIAS EXTRAÍBLES O CHIPS DEJADOS EN EL EQUIPO AL MOMENTO DE LA REPARACIÓN.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('10- TODA REVISIÓN TIENE UN COSTO DE $3000 O 10.000 DEPENDE DEL MODELO ES EL COSTO DE LA REVISIÓN.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('11- PARA EL CUBRIMIENTO DE GARANTÍAS EL CLIENTE TIENE QUE DEJAR 24 HORAS EL EQUIPO.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('12- LA GARANTÍA SE EFECTUARA SOLO SI EL CLIENTE PRESENTA ESTA GUÍA.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('13- NO DAMOS GARANTÍA POR PANTALLA EN NEGRO O PIXELADA.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('14- EN CASO DE PERDER LA GUÍA DEBERÁ RETIRAR EL TELÉFONO CON SU RUT.'),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('15- LA EMPRESA NO SE HACE RESPONSABLE POR CELULARES DEJADOS POR 6 MESES O MÁS. '),0,0,'0');
		$pdf->Ln(6.8);
		$pdf->Cell(80,1,utf8_decode('16- QUEDA BAJO RESPONSABILIDAD DEL  CLIENTE RESPALDAR INFORMACION DE ESTE EQUIPO. LA EMPRESA NO SE RESPONSABILIZA POR PENDIENTES DE INFORMACION.'),0,0,'0');
		$pdf->SetFont('Arial','',8);
		$pdf->Ln(20);
		$pdf->SetX(60);
		$pdf->Cell(80,15,utf8_decode('Yo, '.$nombreCliente.' '.$rutCliente.', certifico que estoy conforme con el producto que se me fue entregado. Aceptando las condiciones'),0,0,'0');
		$pdf->Ln(15);
		
		$pdf->SetX(175);
		$pdf->Cell(80,15,utf8_decode('y garantías que fueron expuestas a la hora del ingreso del equipo.'),0,0,'0');
		$pdf->Ln(30);
		$pdf->SetX(260);
		$pdf->Cell(80,15,utf8_decode(''),'B',0,'0');
		$pdf->Ln(20);
		$pdf->SetX(285);
		$pdf->Cell(80,15,utf8_decode('Firma'),0,0,'0');
	
	/*
$boolean_variable = true;
$pdf->SetX(500);
if($boolean_variable == true)
$check = "4"; else $check = "";
$pdf->SetFont('ZapfDingbats','', 10);
$pdf->Cell(15, 15, $check, 1, 0);
*/
$pdf->Output();
}


if(isset($_REQUEST['ordserv_id'])){

$id_orden =  base64_decode($_REQUEST['ordserv_id']);

$pdf=new FPDF('P','pt','Letter');

// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
/*$sql = "select a.*,DATE_FORMAT(a.fecha_comprobante,'%d/%m/%Y')AS fecha_comprob,d.condicion as medpago,b.emitido_doc_por, b.num_doc as numerodocumento,c.descripcion as tipodocumentos from comprobante_cpp a join 
cuentas_por_pagar b on a.id_cpp = b.id join tipo_documentos c on b.tipo_doc = c.id join condicion_pago d on a.forma_pago = d.id
	where a.id = $id_comprbte";*/
$sql = "select A.*,D.condicion as descpago,E.nombre as nameuser, DATE_FORMAT(B.fecha, '%d/%m/%Y') as fecha_abono from venta_interna_pos A join abonos B on A.id = B.id_orden join abonos_det C on B.id = C.id_abono 
join condicion_pago D on C.forma_pago = D.id join usuarios E on A.usuario = E.id  where A.id = $id_orden";
$res = mysqli_query($con,$sql);
while($rw = mysqli_fetch_array($res)){
	$numcomprbte = $rw['boleta'];
	$nrodocumento = $rw['numerodocumento'];
	$fechacomprbte = $rw['fecha_comprob'];
	$rut = $rw['rut'];
	$nombre = $rw['nombre'];
	$telefono = $rw['telefono'];
	$fecha = $rw['fecha_abono'];
	$emitido = $rw['nameuser'];
	
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Image($logo_empresa,30,10,100,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: 76.317.144-2",'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("ORDEN DE SERVICIO"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N° ").right("00000".trim($numcomprbte),10),'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(10);
// Referencia Empresa
$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Emitido Por: '),0,0,'L');


$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$emitido,0,1,'LR');

$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Rut Cliente: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$rut,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Nombre Cliente: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$nombre,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Teléfono Cliente: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$telefono,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$horanotacr,0,1,'LR');



$pdf->SetFont('Arial','',7);
$pdf->Cell(220,12,$hora,0,1,'L');
$pdf->Ln(4);


$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(10);
	$pdf->Ln(4);

	$encabezado = array("Fecha Pago", utf8_decode("N° Cuota abonada"), "Medio De Pago", "Valor Total Comprobante");
	$alineacion = array("C", "C", "C", "C");
			
	$w = array(110, 120, 230,95);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
			$contador = 1;
			$sql1 = "select D.condicion as descpago, DATE_FORMAT(B.fecha, '%d/%m/%Y') as fecha_abono,C.monto as abono from  abonos B join abonos_det C on B.id = C.id_abono 
			join condicion_pago D on C.forma_pago = D.id where B.id_orden = $id_orden ";
			$res1 = mysqli_query($con,$sql1);
			while($rw1 = mysqli_fetch_array($res1)){
				                 
				$pdf->Cell($w[0], $yH, $fecha, 'LRB', 0, 'C');
							
				$pdf->Cell($w[1], $yH, $contador++, 'LRB', 0, 'C');
				 $y1 = $pdf->GetY();
				$pdf->MultiCell($w[2], $yH, $rw1['descpago'], 'LRB','C');
						   
				$y2 = $pdf->GetY();
							$yH = ($y2 - $y1);
				
				$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
				$pdf->Cell($w[3], $yH, number_format($rw1['abono'], 0, ",", "."), 'LRB',0, 'C');
		
							
				$pdf->Ln();
			}
		
	

$pdf->Ln(30);	


	/*$pdf->SetFont('Arial','B',8);
	$pdf->Cell(60,20,'OBSERVACION:','B',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,$observacion,'B',0,'R');
	*/
$pdf->Output();
	
}






if(isset($_REQUEST['dev_id'])){

$id_comprbte =  base64_decode($_REQUEST['dev_id']);

$pdf=new FPDF('P','pt','Letter');

// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$sql = "select A.* from devoluciones A where A.id = ".$id_comprbte."";
$res = mysqli_query($con,$sql);
while($rw = mysqli_fetch_array($res)){
	$numcomprbte = $rw['notacredito'];

}

$query = "SELECT A.*, DATE_FORMAT(A.fecha,'%d/%m/%Y') AS 'FechaBoleta',C.nombre as user, B.rut, B.razon_social FROM devoluciones A LEFT JOIN clientes B ON A.cliente_id=B.id join usuarios C on A.usuario = C.id WHERE A.id=".trim($id_comprbte).";";
$result = mysqli_query($con,$query);
if ($result) {
	while ($row = mysqli_fetch_array($result))
	{
		$fechaBoleta=$row["FechaBoleta"];
		$montot = $row['monto_total'];
		$netot = $row['neto'];
		$desct = $row['descuento'];
		$tipo = $row['tipo_doc'];
		$ivat = $row['iva'];
		$nrodocumento=$row["num_doc"];
		$usern=$row["user"];
		$rutCliente=$row["rut"];
		$nombreCliente=$row["razon_social"];
		$observaciones=$row["observaciones"];
		if (!is_null($row["contacto"])) {
			$contactoCliente=trim(utf8_decode($row["contacto"]));
		}
	}
	mysqli_free_result($result);
}		
$doc = '';

if($tipo == 'F'){
	$doc = 'FACTURA';
}else if($tipo == 'B'){
	$doc = 'BOLETA';
}else if($tipo == 'I')
	$doc = 'BOLETA INTERNA';
list($dia,$mes,$anio) = explode('/',$fechaBoleta);
			
			$nyear = substr($anio, -2);
			
		switch($mes) 
		{
		case "01":
			$var = "Enero";
			break;
		case "02":
			$var = "Febrero";
			break;
		case "03":
			$var = "Marzo";
			break;
		case "04":
			$var = "Abril";
			break;
		case "05":
			$var = "Mayo";
			break;
		case "06":
			$var = "Junio";
			break;
		case "07":
			$var = "Julio";
			break;
		case "08":
			$var = "Agosto";
			break;
		case "09":
			$var = "Septiembre";
			break;
		case "10":
			$var = "Octubre";
			break;
		case "11":
			$var = "Noviembre";
			break;
		case "12":
			$var = "Diciembre";
			break;
		
			
		}

		
$query1 = "select A.*,B.nombre as codcomuna from clientes A left join comuna B on A.comuna = B.codigo where rut= '".$rutCliente."'";
$result1 = mysqli_query($con,$query1);
while($row1 = mysqli_fetch_array($result1)){
	$rsocialcliente = $row1['razon_social'];
	$rcliente = $row1['rut'];
	$direccioncliente = $row1['direccion'];
	$comunacliente = $row1['codcomuna'];
	$girocliente = $row1['giro_comercial'];
	$fonocliente = $row1['telefonos'];
}		
// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(380);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"RUT: 76.317.144-2",'RLT',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("COMPROBANTE DE DEVOLUCIÓN"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N° ").right("00000".trim($numcomprbte),10),'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');

$pdf->Ln(30);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($rsocialcliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('R.U.T:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($rcliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Dirección:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($direccioncliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Comuna:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($comunacliente),'B',0,'c');

$pdf->Ln(20);
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(80,15,utf8_decode('Giro:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(250,15,utf8_decode($girocliente),'B',0,'c');
$pdf->SetX(380);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(50,15,utf8_decode('Fono:'),0,0,'0');
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(150,15,utf8_decode($fonocliente),'B',0,'c');
$pdf->Ln(45);
// Referencia Empresa
$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Emitido Por: '),0,0,'L');


$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$usern,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('N° Documento: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$nrodocumento,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','B',9);
$pdf->Cell(80,12,utf8_decode('Tipo Documento: '),0,0,'L');

$pdf->SetFont('Arial','',9);
$pdf->Cell(160,12,$doc,0,1,'LR');
$pdf->Ln(4);  // SALTO DE LINEA
$pdf->SetFont('Arial','',7);
$pdf->Cell(160,12,$horanotacr,0,1,'LR');



$pdf->SetFont('Arial','',7);
$pdf->Cell(220,12,$hora,0,1,'L');
$pdf->Ln(4);


$pdf->Line(30,$pdf->GetY(),325,$pdf->GetY());
$pdf->Ln(10);
	$encabezado = array("Item", "Codigo", utf8_decode("Descripción."),"Cantidad", "Valor Unitario", "Descuento", "Total");
	$alineacion = array("C", "C", "C", "C", "C", "C","C");
			
	$w = array(20, 50, 230,45, 80, 50, 80);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select a.*,b.especificaciones,b.psale_c_iva as precio_venta, b.codigo_externo from devoluciones_det a join productos b on a.producto_id=b.id where notacredito_id = ".$id_comprbte.";
";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["codigo_externo"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, utf8_decode(trim($row["especificaciones"])), 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row["precio"]/$row["cantidad"], 0, ",", "."), 'LRB',0, 'C');
				$pdf->Cell($w[5], $yH, strtoupper("%".$row["descuento"]), 'LRB', 0, 'C');
			$pdf->Cell($w[6], $yH, number_format($row["precio"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$suma=$suma+$row["precio"];
						
			$pdf->Ln();
		}
	}
						
			$pdf->Ln();
		
	

$pdf->Ln(30);	


	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(60,20,'OBSERVACION:','B',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,$observacion,'B',0,'R');

$pdf->Output();
	
}




if(isset($_REQUEST['liquidacionid'])){

function redondeado ($numero, $decimales) { 
	$factor = pow(10, $decimales); 
	return (round($numero*$factor)/$factor); }
	$IdPeriodo = $_SESSION['idPeriodo'];
	$pdf=new FPDF('P','pt','Letter');
	$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";

	$pdf->AddPage();
	$pdf->SetFont('Arial','B',9);
	$pdf->Image($logo_empresa,30,10,40,0,'');

	$ques = "SELECT * from periodos WHERE IdPeriodo = '".$IdPeriodo."'";
	$res = mysqli_query($con,$ques);
	if ($rows = mysqli_fetch_array($res)){
		$mPer = $rows['MesPeriodo'];
		$aPer = $rows['AnoPeriodo'];
	}

	switch($mPer) 
	{
	case 1:
		$mesperiodo = "Enero";
		break;
	case 2:
		$mesperiodo = "Febrero";
		break;
	case 3:
		$mesperiodo = "Marzo";
		break;
	case 4:
		$mesperiodo = "Abril";
		break;
	case 5:
		$mesperiodo = "Mayo";
		break;
	case 6:
		$mesperiodo = "Junio";
		break;
	case 7:
		$mesperiodo = "Julio";
		break;
	case 8:
		$mesperiodo = "Agosto";
		break;
	case 9:
		$mesperiodo = "Septiembre";
		break;
	case 10:
		$mesperiodo = "Octubre";
		break;
	case 11:
		$mesperiodo = "Noviembre";
		break;
	case 12:
		$mesperiodo = "Diciembre";
		break;
		
		
	}

	$idtr = $_REQUEST['liquidacionid'];
	$sql = "select A.*, B.nombre, B.ApellidoPaterno, B.ApellidoMaterno, B.rut, DATE_FORMAT(B.fecha_ingreso, '%d/%m/%Y') AS Fechaing, B.sueldo_base as sueldo, C.descripcion as contrato, D.descripcion as cargotr 
from liquidacion A 
join trabajador B on A.IdTrabajador = B.id 
join tipo_contrato C on B.id_contrato = C.id 
join cargo D on B.cargo = D.id 
where A.IdLiquidacion = ".$idtr."";

	$res = mysqli_query($con,$sql);
	while($row = mysqli_fetch_array($res)){
		$nombre = $row['nombre'];
		$apepat = $row['ApellidoPaterno'];
		$apemat = $row['ApellidoMaterno'];
		$rut = $row['rut'];
		$ingreso = $row['Fechaing'];
		$tipocontratod = $row['contrato'];
		$sueldo = $row['sueldo'];
		$cargotr = $row['cargotr'];
		$idtrabaj = $row['IdTrabajador'];
	}


	$Id_Periodo=$_SESSION['idPeriodo'];
	
	
	$query_uf = "SELECT * from valor_uf  where id_periodo=$Id_Periodo ";
	
	$result_uf = mysqli_query($con,$query_uf);
	while ($row_uf = mysqli_fetch_array($result_uf))
	{
		
		$valoruf=$row_uf['valor'];
		
	}
	mysqli_free_result($result_uf);
	$query = "SELECT trabajador.*, afp.descripcion as nombre_afp, afp.Factor, seguro_cesantia.NombreSeguroCesantia,seguro_cesantia.FactorSeguroCesantia, salud.descripcion as nombre_salud from trabajador left join salud on salud.id=trabajador.id_salud left join seguro_cesantia on 
								seguro_cesantia.IdSeguroCesantia=trabajador.id_afc left join afp on afp.id=trabajador.id_afp where (trabajador.id_contrato=1 or trabajador.id_contrato=2) and  trabajador.id=$idtrabaj";
	
	
	$result = mysqli_query($con,$query);
	while ($row = mysqli_fetch_array($result))
	{
		$descuentos=0;
		$id_trab=$row['id'];
		$id_afp=$row['id_afp'];
		$dias=$row['dias'];
		$afp=$row['nombre_afp'];
		$id_salud=$row['id_salud'];
		$salud=$row['nombre_salud'];
		$factor_afp=$row['Factor'];
		$afc=$row['NombreSeguroCesantia'];
		$factor_afc=$row['FactorSeguroCesantia'];
		$hrs_sem=$row['HrsSemanales'];
		$s_base = $row['sueldo_base'];
		$sueldo_base=$row['sueldo_base'];
		$bono_colacion=$row['bono_colacion'];
		$bono_movilizacion=$row['bono_movilizacion'];
		$asig_fam=$row['AsignacionFamiliar'];
		$idsalud = $row['id_salud']; 
		$valorisapre = $row['ValorIsapre'];
		$tipocontrato = $row['id_contrato']; 
		
		if($idsalud != 1 && $idsalud !=2){
			$valorisa = $valorisapre * $valoruf;
		}else{
			$valorisa=0;
		}
		$dias_fal=0;
		
		$sql_dias_f = "SELECT SUM(total_dias) as cantidad_fal ,id_trabajador from dias_faltados where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo;
		//echo $sql_dias_f;
		$res_dias_f = mysqli_query($con,$sql_dias_f);
		while($rw_dias_f = mysqli_fetch_array($res_dias_f)){		
			$dias_fal=$rw_dias_f['cantidad_fal'];
			if($dias_fal!="" && $dias_fal>0){
				
				$sueldo_base=round($sueldo_base/30*(30-$dias_fal));	 
				
			}
			
		}
		//$renta_minima = 264000;
		$renta_minima = 0;
		$sql_rm = "SELECT valor from renta_m_imponible where id = 1";
		//echo $sql_dias_f;
		$res_rm = mysqli_query($con,$sql_rm);
		while($rwr = mysqli_fetch_array($res_rm)){	
			$renta_minima = $rwr['valor'];
		}

		
		
		$totalhoraext=0;
		$c50=0;
		$c100=0;
		$mint100 = 0;
		/*$sql = "select sum(cantidad_50) as cant50,sum(cantidad_100) as cant100 from horas_extras where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo."";
		$res = mysqli_query($con,$sql);
		while($rw = mysqli_fetch_array($res)){
			$c50 = $rw['cant50'];
			$c100 = $rw['cant100'];
			
			$valorc50 = round(($sueldo_base/30*7/$hrs_sem*1.5)*$c50);
			$valorc100 = round(($sueldo_base/30*7/$hrs_sem*2)*$c100);
			$totalhoraext = $valorc50 + $valorc100;
		}*/
		$sql = "select sum(cantidad_50) as cant50,sum(cantidad_100) as cant100,sum(cantmin_50) as cantm50,sum(cantmin_100) as cantm100 from horas_extras where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo."";
		$res = mysqli_query($con,$sql);
		while($rw = mysqli_fetch_array($res)){
			$c50 = $rw['cant50'];
			$c100 = $rw['cant100'];
			$m50 = $rw['cantm50'];
			$m100 = $rw['cantm100'];
			
			$factormin50_ = $m50/60;	
			$factoraprox50 =  redondeado ($factormin50_,2);
			$mint50 = $c50 + $factoraprox50;			
			//$mint50 =  $c50.substr($factoraprox50,1);
											
											
			$valoru50 = str_replace(',','',number_format(($s_base/30*7/$hrs_sem)*1.5,2));
			//$valorc50 = round(($sueldo_base/30*7/$hrs_sem*1.5)*$c50);
			$valorc50 = round($valoru50 * $c50);
			$factor50min = number_format($valoru50/60,2);
			$valorc50min = round($factor50min *  $m50);
			$valort50 = $valorc50min + $valorc50;
			//$factormin = round(($minutos * 100) / 60); 
			//$valorc50 = round(($sueldo_base * 0.0077777)*$c50);
			
			if($c100>0){
				$valoru100 = str_replace(',','',number_format(($s_base/30*7/$hrs_sem)*2,2));
				//$valorc50 = round(($sueldo_base/30*7/$hrs_sem*1.5)*$c50);
				$valorc100 = round($valoru100 * $c100);
				$factor100min = number_format($valoru100/60,2);
				$valorc100min = round($factor50min *  $m50);
				$valort100 = $valorc100min + $valorc100;
				
				$factormin100_ = $m100/60;	
				$factoraprox100 =  redondeado ($factormin100_,2);
				$mint100 = $c100 + $factoraprox100;
				
			}
			
			//$totalhoraext = $valorc50 + $valorc100;
			$totalhoraext = $valort50 + $valort100;
		}
		
		$totalbono=0;
		$sql_bono = "select sum(valor) as sumavalor from bonos where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo." and tipo_bono='I'";
		$res_bono = mysqli_query($con,$sql_bono);
		while($rw_bono = mysqli_fetch_array($res_bono)){
			$totalbono = $rw_bono['sumavalor'];
			
		}
		if($totalbono>0){
			
		}else{
			$totalbono=0;
		}
		
		$dias_=0;
		$festivos_=0;
		$sql_dias = "select * from dias_habiles where id_periodo = ".$IdPeriodo."";
		$res_dias = mysqli_query($con,$sql_dias);
		while($rw_dias = mysqli_fetch_array($res_dias)){
			
			$dias_ = $rw_dias['dias'];
			$festivos_ = $rw_dias['festivos'];
		}

		$variable=(($dias_ - $dias_fal_p) * $festivos_);
		$valor_comision=0;
		$semana_c=0;
		$sql_comision = "select * from comisiones where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo."";
		$res_comsion = mysqli_query($con,$sql_comision);
		while($rw_comision = mysqli_fetch_array($res_comsion)){
			$valor_comision = $rw_comision['valor'];
			if($$variable==0){}else{
				$semana_c=round($valor_comision / ($dias_ - $dias_fal_p) * $festivos_) ;
			}
		}
		
		$gratificaciontope = round($renta_minima/12*4.75);
		$imponiblegratificacion = $valor_comision + $totalbono + $totalhoraext + $sueldo_base;
		$gratificacion=$imponiblegratificacion*25/100;
		$gratificacionp = 0;
		if($gratificacion > $gratificaciontope){
			$gratificacionp = $gratificaciontope;
		}else{
			$gratificacionp = $gratificacion;
		}
		
		$total_imponible= $semana_c + $valor_comision + $totalbono + $totalhoraext + $gratificacionp + $sueldo_base;
		$monto_asig_fam=0;
		$sql2 = "select * from asignacion_familiar where min<=$sueldo_base AND max>$sueldo_base";
		$valorasig = 0;
		$res2 = mysqli_query($con,$sql2);
		while($rw2 = mysqli_fetch_array($res2)){
			if($rw2['valor']!=""){
				$valorasig = $rw2['valor'];
				$monto_asig_fam=$asig_fam*$valorasig;
				
			}
		}
		
		
		$sql_bono = "select sum(valor) as sumavalor2 from bonos where id_trabajador = ".$row['id']." and id_periodo = ".$IdPeriodo." and tipo_bono='N'";
		$res_bono = mysqli_query($con,$sql_bono);
		while($rw_bono = mysqli_fetch_array($res_bono)){
			$totalbono2 = $rw_bono['sumavalor2'];
			
		}
		$total_asignaciones=$bono_colacion + $bono_movilizacion+$totalbono2;
		
		$monto_afp=  round($total_imponible * $factor_afp /100);
		$sis=  round($total_imponible * 1.15 /100);
		
		if($tipocontrato == 1){
			$monto_afc=  round($total_imponible * 0.6 /100);
			$monto_afc_empleador=  round($total_imponible * 2.4 /100);
		}else if($tipocontrato == 2){
			$monto_afc=  0;
			$monto_afc_empleador=  round($total_imponible * 3.0 /100);

		}
		if($id_salud!=1){
			$monto_fonasa=  round($total_imponible * 7 /100);
		}else{
			$monto_fonasa=0;
		}
		if($valorisa!=0){
			$difisapre = round($valorisa -  $monto_fonasa);
			if($difisapre < 0){
				$difisapre = 0;
			}
		}else{
			
			$difisapre=0;
			
		}
	$total_desc_prov= round($monto_afp + $monto_afc + $monto_fonasa + $difisapre);
		$impuesto_unico = round($total_imponible - $total_desc_prov);
		
		
		$sql1 = "select * from impuesto_unico_sc where monto_desde<=$impuesto_unico AND monto_hasta>$impuesto_unico";
		$valoraimpuesto = 0;
		$res2 = mysqli_query($con,$sql1);
		while($rw1 = mysqli_fetch_array($res2)){
			$factor = $rw1['factor'];
			$rebaja = $rw1['rebaja_monto'];
			
			$valoraimpuesto = round(($impuesto_unico * $factor)-$rebaja);
			
		}
		$totaldescuentonuevo = $total_desc_prov + $valoraimpuesto;  
		$sql_anticipo="select sum(ValorAnticipo) as monto_anticipo from anticipo where  IdTrabajador= ".$row['id']." and IdPeriodo=".$IdPeriodo." ";
		$res_anticipo=mysqli_query($con,$sql_anticipo);				
		$anticipo=0;
		while($rw_anticipo=mysqli_fetch_array($res_anticipo)){
			
			
			$anticipo=$rw_anticipo['monto_anticipo'];
			
		}
		if($anticipo==""){
			
			$anticipo=0;
		}
		
		
		
		$sql_descuentos="select sum(valor) as total_descuentos from descuentos where id_trabajador= ".$row['id']." and id_periodo=".$IdPeriodo." ";
		$res_descuentos=mysqli_query($con,$sql_descuentos);
		
		while($rw_descuentos=mysqli_fetch_array($res_descuentos)){
			
			
			$descuentos=$rw_descuentos['total_descuentos'];
			
		}
		if($descuentos==""){
			
			$descuentos=0;
		}
		
		
		$sql_hrs_falt="select sum(total_dias) as total_horas_falt,sum(minutos) as tminutos,sum(factor) as sumahoras from horas_faltadas where id_trabajador= ".$row['id']." and id_periodo=".$IdPeriodo." ";
		$res_hrs_falt=mysqli_query($con,$sql_hrs_falt);
		
		while($rw_hrs_falt=mysqli_fetch_array($res_hrs_falt)){
			
			/*$cant_horas_faltadas = $rw_hrs_falt['total_horas_falt'];
									$horas_faltadas=round(($sueldo_base/30*28/180)*$cant_horas_faltadas);*/
			$totalmin = $rw_hrs_falt['tminutos'];
			$cant_horas_faltadas = $rw_hrs_falt['total_horas_falt'];
			$valoru_horaf = round($s_base/30*28/180);
			$horas_faltadas_ = $valoru_horaf * $cant_horas_faltadas;
			$valorminf = number_format($valoru_horaf/60,2);
			$totalminf = round($valorminf * $totalmin);
			$horas_faltadas = $horas_faltadas_ + $totalminf;
			$factor_horas_total = $rw_hrs_falt['sumahoras'];
			//$horas_faltadas = $valoru_horaf * $cant_horas_faltadas;
			
		}
		if($horas_faltadas==""){
			
			$horas_faltadas=0;
		}
		
		if($cant_horas_faltadas==""){
			
			$cant_horas_faltadas=0;
		}
		
		
		$total_liquido=round($total_imponible+$monto_asig_fam+$total_asignaciones-$monto_afp-$monto_afc-$monto_fonasa-$difisapre-$valoraimpuesto-$anticipo-$descuentos - $horas_faltadas);
				
	}
	$nombreCompleto = $nombre. " ". $apepat. " ".$apemat;
	$nombreCompleto = strtoupper($nombreCompleto);

	$pdf->Ln(10);
	$pdf->SetX(190);
	$pdf->SetFont('Arial','',15);
	$pdf->Cell(200,15,utf8_decode('LIQUIDACIÓN DE SUELDOS'),'B',0,'C');

	$pdf->Ln(25);
	$pdf->SetX(250);
	$pdf->Cell(90,15,utf8_decode($mesperiodo).' '.$aPer,'B',0,'C');
	$pdf->Ln(25);
	$pdf->Ln(10);
$pdf->SetFont('Arial','B',9);
$pdf->Cell(100,15,utf8_decode('NOMBRE EMPRESA:'),0,0,'0');
$pdf->SetFont('Arial','',9);
$pdf->Cell(150,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','B',9);
$pdf->Cell(100,15,'R.U.T EMPRESA:',0,0,'0');
$pdf->SetFont('Arial','',9);
$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');

	$pdf->Cell(160,15,utf8_decode(''),0,0,'c');
	
	$pdf->Ln(10);
	$pdf->Ln(20);
	//$pdf->Line(100,$pdf->GetY(),325,$pdf->GetY());
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(100,15,'NOMBRE:',0,0,'1');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,utf8_decode($nombreCompleto),0,0,'1');
	
	$pdf->SetX(340);
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(150,15,'TIPO DE CONTRATO:',0,0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,$tipocontratod,0,0,'0');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(100,15,'R.U.T:',0,0,'1');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,$rut,0,0,'1');
	$pdf->SetX(340);
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(150,15,'CARGO/PUESTO DE TRABAJO:',0,0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,$cargotr,0,0,'0');

	$pdf->Ln(17);
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(100,15,'FECHA DE INGRESO:',0,0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,$ingreso,0,0,'0');

	$pdf->SetX(340);
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(150,15,'SUELDO BASE:',0,0,'0');
	$pdf->SetFont('Arial','',9);
	$pdf->Cell(160,15,number_format($sueldo,0,",","."),0,0,'0');
	//$pdf->Ln(17);
	


	

	


	$pdf->Ln(30);
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(240,15,'HABERES','RTL',0,'0');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(240,15,'DESCUENTOS','RTL',0,'0');

	$pdf->Ln(15);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'IMPONIBLES',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'DETALLE',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(30,10,'CANT',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'VALOR',1,0,'C');


	//Descuentos
	$pdf->SetX(310);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'Descuentos Prov',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'DETALLE',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(30,10,'CANT',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'VALOR',1,0,'C');

	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Días Faltados'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,number_format($dias_fal,0,",","."),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($sueldo_base,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos Prov',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('AFP '.$afp),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($monto_afp,0,",","."),0,0,'C');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Gratificación'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format(round($gratificacionp),0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos Prov',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('AFC'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($monto_afc,0,",","."),0,0,'C');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Hrs Extras 50%',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,$mint50,0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($valort50,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos Prov',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('SALUD '.$salud),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($monto_fonasa,0,",","."),0,0,'C');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Hrs Extras 100%',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,$mint100,0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($valort100,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos Prov',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('ADICIONAL SALUD'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($difisapre,0,",","."),0,0,'C');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'BONOS',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($totalbono,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos Prov',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('IMPUESTO UNICO'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($valoraimpuesto,0,",","."),0,0,'C');

	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'COMISIONES',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($valor_comision,0,",","."),0,0,'C');


	$pdf->Ln(27);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'IMPONIBLE',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Imponible',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format(round($total_imponible),0,",","."),0,0,'C');

	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Descuentos',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($totaldescuentonuevo,0,",","."),0,0,'C');

	$pdf->Ln(45);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'NO IMPONIBLE',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'DETALLE',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(30,10,'CANT',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'VALOR',1,0,'C');

	$pdf->SetX(310);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'Otros Descuentos',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'DETALLE',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(30,10,'CANT',1,0,'C');
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'VALOR',1,0,'C');

	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'No Imponible',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Asignación Familiar'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($monto_asig_fam,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Otros Descuentos',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Anticipo'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($anticipo,0,",","."),0,0,'C');
	$pdf->Ln(17);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'No Imponible',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Asignación Colación'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($bono_colacion,0,",","."),0,0,'C');
	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Descuentos',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($descuentos,0,",","."),0,0,'C');
	$pdf->Ln(17);

	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'No Imponible',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Asignación Movilización'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'0',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($bono_movilizacion,0,",","."),0,0,'C');

	$pdf->SetX(310);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Horas Faltadas',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,str_replace('.',',',$factor_horas_total),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($horas_faltadas,0,",","."),0,0,'C');
	$pdf->Ln(5);


	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,utf8_decode('Total No Imponible'),0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($total_asignaciones + $monto_asig_fam,0,",","."),0,0,'C');




	$pdf->Ln(30);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Imponible','TL',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'','T',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'','T',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format(round($total_imponible),0,",","."),'TR',0,'R');

	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total No imponible','L',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($monto_asig_fam + $total_asignaciones,0,",","."),'R',0,'R');

	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Descuentos Prov.','L',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'',0,0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($totaldescuentonuevo,0,",","."),'R',0,'R');

	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Anticipos','L',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'','',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'','',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($anticipo,0,",","."),'R',0,'R');
	
	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Descuentos','L',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'','',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'','',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($descuentos,0,",","."),'R',0,'R');
	
	$pdf->Ln(10);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'Total Horas Faltadas','BL',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'','B',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'','B',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($horas_faltadas,0,",","."),'BR',0,'R');
	
	$pdf->Ln(20);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(70,10,'Total Liquido A Cancelar','BLT',0,'L');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,'','BT',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(30,10,'','BT',0,'C');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,10,number_format($total_liquido,0,",","."),'TBR',0,'R');


	$pdf->Ln(20);
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(20,10,'Son:','',0,'L');

	$pdf->Cell(30,10,'','',0,'C');
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(500,10,ucfirst(convertir($total_liquido)).' Pesos ','',0,'L');

	$pdf->Ln(55);
	$pdf->SetX(130);
	$pdf->Cell(100,10,'','B',0,'L');
	$pdf->SetX(380);
	$pdf->Cell(100,10,'','B',0,'L');
	$pdf->Ln(15);
	$pdf->SetX(135);
	$pdf->Cell(70,10,'Firma Empleador','',0,'L');
	$pdf->SetX(385);
	$pdf->Cell(70,10,'Firma Trabajador','',0,'L');

	$pdf->Ln(70);
	$pdf->SetX(40);
	$pdf->SetFont('Arial','',7);
	$pdf->Cell(520,10,utf8_decode('Recibí conforme el alcance liquido de la presente liquidación, no teniendo cargo o cobro alguno que hacer por otro concepto'),'',0,'C');

	$pdf->Output();

}


if(isset($_REQUEST['lventas']) && $_REQUEST['lventas'] == '0'){
	
        $IdPeriodo = $_SESSION["idPeriodo"];

        $qp = "SELECT * FROM periodos WHERE IdPeriodo = ".$IdPeriodo;
        $rp = mysqli_query($con,$qp);
        $rowrp = mysqli_fetch_array($rp);

        $mesp = $rowrp['MesPeriodo'];
        if($mesp < 10){
            $mesp = "0".$mesp;
        }

        $primero = $rowrp['AnoPeriodo']."-".$mesp."-"."01";
        $ultimo = date('Y-m-t', strtotime($primero));


    
$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";

// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(200);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"LIBRO DE VENTAS",0,1,'C');
/*
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("BOLETA INTERNA"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');
*/


$sql = "select 'Boletas' docu, SUM(neto) as neto FROM boletas_pos A  WHERE (A.fecha between  '".$primero."' AND '".$ultimo."') and (A.tipo_boleta = 'B' or A.tipo_boleta = 'BE')  ";
//echo $sql;
$res = mysqli_query($con,$sql);
$row = mysqli_fetch_array($res);
$neto = $row['neto'];

$minmax = "SELECT min(boleta) as minima , max(boleta) as maxima FROM boletas_pos A WHERE (A.fecha between  '".$primero."' AND '".$ultimo."') and (A.tipo_boleta = 'B' or A.tipo_boleta = 'BE') ";
//echo $minmax;
$res1 = mysqli_query($con,$minmax);
$row1 = mysqli_fetch_array($res1);
$fac_min = $row1['minima'];
$fac_max = $row1['maxima'];


$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(40);
$pdf->Cell(50,15,'TOTALES:',0,0,'0');
$pdf->Ln(15);
	$pdf->Ln(4);

	$encabezado = array("Documento", "Periodo","Rango Documento", "Monto");
	$alineacion = array("C", "C", "C", "C");
			
	$w = array(110, 110, 225,110);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	
	
	
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$pdf->Cell($w[0], $yH, $row['docu'], 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $primero." / ".$ultimo, 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, "Desde: #".$fac_min." Hasta: #".$fac_max, 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($neto, 0, ",", "."), 'LRB',0, 'C');

				
		                              
	
						
	$sql = "select 'Facturas' docu, SUM(monto_total) as total FROM factura A WHERE (A.fecha between  '".$primero."' AND '".$ultimo."') and A.confirmada = 1 ";
	$res = mysqli_query($con,$sql);
	$row = mysqli_fetch_array($res);
	$totalf = $row['total'];

	$minmax = "SELECT min(factura) as minima , max(factura) as maxima FROM factura A WHERE (A.fecha between  '".$primero."' AND '".$ultimo."') and A.confirmada = 1 ";
	//echo $minmax;
	$res2 = mysqli_query($con,$minmax);
	$row2 = mysqli_fetch_array($res2 );
	$fac_min = $row2['minima'];
	$fac_max = $row2['maxima'];

	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$pdf->Cell($w[0], $yH, $row['docu'], 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $primero." / ".$ultimo, 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, "Desde: #".$fac_min." Hasta: #".$fac_max, 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($totalf, 0, ",", "."), 'LRB',0, 'C');
			
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$pdf->Cell($w[0], $yH, 'Total', 'LB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, '', 'B', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, '', 'B','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($totalf+$neto, 0, ",", "."), 'LRB',0, 'C');

				
		                              
	
						
			$pdf->Ln();				
		
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	
	
	$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(40);
$pdf->Cell(50,15,'FACTURAS:',0,0,'0');
$pdf->Ln(15);
	$pdf->Ln(4);

	$encabezado = array("#","Fecha", "Rut", utf8_decode("Nombre Cliente"),"Documento", "Total", "IVA", "Neto");
	$alineacion = array("C","C", "C", "C", "C", "C", "C","C");
			
	$w = array(20,50, 50, 210,45, 60, 60, 60);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select A.*,DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaFact', B.rut as rutcliente, B.razon_social as nombrecliente from factura A join clientes B on A.cliente_id = B.id ".$condicion." AND (A.fecha between  '".$primero."' AND '".$ultimo."') and A.confirmada = 1 ";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row["FechaFact"], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, $row["rutcliente"], 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, $row["nombrecliente"], 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, $row["factura"], 'LRB',0, 'C');
	
			$pdf->Cell($w[5], $yH, number_format($row["monto_total"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$pdf->Cell($w[6], $yH, number_format($row["iva"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			$pdf->Cell($w[7], $yH, number_format($row["neto"], 0, ",", "."), 'LRB', 0, 'C');		                                    
			
			$totalbruto +=$row["monto_total"];
						
			$pdf->Ln();
		}
	}
	
	$totalneto =round($totalbruto/1.19);
	$totaliva =$totalbruto - $totalneto;

	
$pdf->Ln(16);



$pdf->SetFont('Arial','',8);

	$pdf->SetX(410);
	$pdf->Cell(100,20,'VALOR NETO','TL',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totalneto, 0, ",", "."),'TR',0,'R');
	$pdf->Ln(20);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL IVA','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totaliva, 0, ",", "."),'R',0,'R');
	$pdf->Ln(20);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL BRUTO','LB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totalbruto, 0, ",", "."),'RB',0,'R');

$pdf->Output();
}


if(isset($_REQUEST['lcompras']) && $_REQUEST['lcompras'] == '0'){
	
       $IdPeriodo = $_SESSION['idPeriodo'];

		require_once("include/funciones.php");
        $qp = "SELECT * FROM periodos WHERE IdPeriodo = ".$IdPeriodo;
        $rp = mysqli_query($con,$qp);
        $rowrp = mysqli_fetch_array($rp);

        $mesp = $rowrp['MesPeriodo'];
        if($mesp < 10){
            $mesp = "0".$mesp;
        }

        $primero = $rowrp['AnoPeriodo']."-".$mesp."-"."01";
        $ultimo = date('Y-m-t', strtotime($primero));


    
$pdf=new FPDF('P','pt','Letter');
$des_hoy = "[ " . trim($fec_hoy) . " ] [ " . trim($hor_hoy) . " ]";
// Leer Encabezado
$fechaCotizacion="";
$nroCotizacion="";
$rutCliente="";
$nombreCliente="";
$contactoCliente="";
$observaciones="";

// 
$pdf->AddPage();
$pdf->SetFont('Arial','B',9);
$pdf->SetTextColor(234, 8, 8);
$pdf->Image($logo_empresa,30,10,40,0,'');
$pdf->SetX(200);
$pdf->SetFont('Arial','',12);
$pdf->Cell(200,12,"LIBRO DE COMPRAS",0,1,'C');
/*
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("BOLETA INTERNA"),'RL',1,'C');
$pdf->SetX(380);
$pdf->Cell(200,12,"",'RL',1,'L');
$pdf->SetX(380);
$pdf->Cell(200,12,utf8_decode("N°  ").right("00000".trim($nroBoleta),10)."",'RLB',1,'C');
$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(10);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,utf8_decode('SEÑOR(ES):'),0,0,'0');

$pdf->Cell(110,15,utf8_decode($señor),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'R.U.T:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($rut_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'GIRO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($giro_empresa),0,0,'c');
$pdf->Ln(17);
$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'DIRECCION:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($direccion_empresa),0,0,'c');

$pdf->Ln(17);
$pdf->Cell(80,15,utf8_decode('COMUNA:'),0,0,'c');
$pdf->SetX(110);
$pdf->Cell(100,15,utf8_decode($comuna_empresa),0,0,'c');
$pdf->SetFont('Arial','',9);
$pdf->Cell(50,15,'CIUDAD:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($ciudad_empresa),0,1,'c');

$pdf->SetFont('Arial','',9);
$pdf->Cell(80,15,'CONTACTO:',0,0,'0');

$pdf->Cell(110,15,utf8_decode($contacto_empresa),0,1,'c');
*/

/*
$sql = "select A.*,DATE_FORMAT( A.fecha, '%d/%m/%Y') AS 'FechaFact', B.rut as rutproveedor, B.razon_social as nombreproveedor from compras1 A join proveedores B on A.id_proveedor = B.id  WHERE (A.fecha between  '".$primero."' AND '".$ultimo."') order by A.fecha ASC";
//echo $sql;
$res = mysqli_query($con,$sql);
$row = mysqli_fetch_array($res);
$neto = $row['neto'];

$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(40);
$pdf->Cell(50,15,'COMPRAS:',0,0,'0');
$pdf->Ln(15);
	$pdf->Ln(4);

	$encabezado = array("Fecha", "Rut","Nombre Proveedor", "Documento" ,"Neto");
	$alineacion = array("C", "C", "C", "C", "C");
			
	$w = array(110, 70, 230,70,70);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	
	
	
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$pdf->Cell($w[0], $yH, $row['FechaFact'], 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $row['rutproveedor'], 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, $row['nombreproveedor'], 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, number_format($row['compra'], 0, ",", "."), 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, number_format($row['neto'], 0, ",", "."), 'LRB',0, 'C');

				
		                              
	
				
		
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
*/	
	
/*	$pdf->SetFont('Arial','',9);
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(40);
$pdf->Cell(50,15,'GASTOS:',0,0,'0');*/
$pdf->SetTextColor(0, 0, 0);
$pdf->Ln(15);
	$pdf->Ln(4);

	$encabezado = array("#","Tipo","Folio","Fecha","Rut", utf8_decode("Razón Social"), "Monto Total");
	$alineacion = array("C","C", "C", "C", "C", "C", "C");
			
	$w = array(20,50, 70, 70,60, 210, 70);  // DA EL ANCHO  DE LAS CELDAS 
	$pdf->SetFont('Arial','B',7);
	for($i = 0; $i < count($encabezado); $i++) {
		$pdf->Cell($w[$i], 14, $encabezado[$i], 1, 0, $alineacion[$i]);
	}
	$pdf->Ln();
	$x = $pdf->GetX();
	$y = $pdf->GetY();
	$i = 0;
	$suma=0;
	$yH = 24;
	$pdf->SetFont('Arial','',7);
	$query = "select A.*,DATE_FORMAT( A.fecha_ing, '%d/%m/%Y') as fechaventa from cuentas_por_pagar A left join tipo_doc B on A.tipo_documento = B.id where A.id_periodo = $IdPeriodo";
	$result = mysqli_query($con,$query);
	if ($result) {
		while ($row = mysqli_fetch_array($result))
		{
			
			if($row['exenta']!=1){
				 $total = $row['monto_doc'];		
				 $neto = round($row['monto_doc']/1.19);
				 $iva = $total - $neto;
				 $exento = 0;
				 $tasa = 19;
			 }else{
				 $total = $row['monto_doc'];		
				 $neto = 0;
				 $iva = 0;
				 $exento = $row['monto_doc'];
				 $tasa = 0;
			 }
			if($row['tipo_doc']==2){
				if($row['tipo_documento']==1){
					if($row['exenta']!=1){
						$tipo = 33;
					}else{
						$tipo = 34;
					}
				}else if($row['tipo_documento']==2){
					if($row['exenta']!=1){
						$tipo = 30;
					}else{
						$tipo = 32;
					}
				}else{
					$tipo = 30;
				}
			}else if($row['tipo_doc']==8){
				if($row['tipo_documento']==1){
					$tipo = 61;
				}else if($row['tipo_documento']==2){
					$tipo = 60;
				}else{
					$tipo = 60;
				}

				
			}else if($row['tipo_doc']==9){
				if($row['tipo_documento']==1){
					$tipo = 56;
				}else if($row['tipo_documento']==2){
					$tipo = 55;
				}else{
					$tipo = 55;
				}

				
			}
			
			$i++;			                 
			$pdf->Cell($w[0], $yH, number_format($i, 0), 'LRB', 0, 'C');
                        
			$pdf->Cell($w[1], $yH, $tipo, 'LRB', 0, 'C');
			 $y1 = $pdf->GetY();
			$pdf->MultiCell($w[2], $yH, $row["num_doc"], 'LRB','C');
                       
			$y2 = $pdf->GetY();
                        $yH = ($y2 - $y1);
			
			$pdf->SetXY($x + $w[2] + $w[0] + $w[1], $pdf->GetY() - $yH);
			$pdf->Cell($w[3], $yH, $row["fechaventa"], 'LRB',0, 'C');
			$pdf->Cell($w[4], $yH, $row["rut"], 'LRB',0, 'C');
	
			$pdf->Cell($w[5], $yH, wordlimit($row["emitido_doc_por"],5,'...'), 'LRB', 0, 'C');		                                    
			$pdf->Cell($w[6], $yH, number_format($total, 0, ",", "."), 'LRB', 0, 'C');		                                    
		                                    
			
			$totalbruto +=$total;
						
			$pdf->Ln();
		}
	}
			$totalneto +=round($totalbruto/1.19);
			$totaliva +=$totalbruto - $totalneto;

	
$pdf->Ln(16);



$pdf->SetFont('Arial','',8);

	/*$pdf->SetX(410);
	$pdf->Cell(100,20,'VALOR NETO','TL',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totalneto, 0, ",", "."),'TR',0,'R');
	$pdf->Ln(20);
	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL IVA','L',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totaliva, 0, ",", "."),'R',0,'R');
	$pdf->Ln(20);*/
	$pdf->SetX(410);
	$pdf->Cell(100,20,'TOTAL','TLB',0,'1');
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(70,20,number_format($totalbruto, 0, ",", "."),'TRB',0,'R');

$pdf->Output();
}



?>